/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

public class Queue
implements Worker.ITodo {
    Entry head;
    Entry tail;
    int size;
    int maxSize;

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFull() {
        boolean bl = false;
        if (this.size == this.maxSize) {
            bl = true;
        }
        return bl;
    }

    public synchronized Object tail() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.value;
    }

    public synchronized Object peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    public synchronized Object peek(int n) throws InterruptedException {
        while (this.size == 0) {
            if (n == -1) {
                this.wait();
                continue;
            }
            this.wait(n);
            break;
        }
        return this.peek();
    }

    public synchronized Object find(Object object) {
        Entry entry = this.head;
        while (entry != null) {
            if (entry.value.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized Object dequeue() {
        Entry entry = this.head;
        if (entry == null) {
            return null;
        }
        this.head = entry.next;
        if (this.head == null) {
            this.tail = null;
        }
        entry.next = null;
        --this.size;
        return entry.value;
    }

    public synchronized Object dequeue(int n) throws InterruptedException {
        while (this.size == 0) {
            if (n == -1) {
                this.wait();
                continue;
            }
            this.wait(n);
            break;
        }
        return this.dequeue();
    }

    public synchronized boolean enqueue(Object object) throws QueueFullException {
        if (this.size >= this.maxSize) {
            throw new QueueFullException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        Entry entry = this.newEntry(object);
        entry.next = null;
        if (this.tail == null) {
            this.head = this.tail = entry;
        } else {
            this.tail.next = entry;
            this.tail = entry;
        }
        ++this.size;
        this.notifyAll();
        return true;
    }

    public synchronized boolean push(Object object) throws QueueFullException {
        if (this.size >= this.maxSize) {
            throw new QueueFullException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        Entry entry = this.newEntry(object);
        entry.next = null;
        if (this.head == null) {
            this.head = this.tail = entry;
        } else {
            entry.next = this.head;
            this.head = entry;
        }
        ++this.size;
        this.notifyAll();
        return true;
    }

    Entry newEntry(Object object) {
        return new Entry(object);
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Entry entry = this.head;
        int n = 0;
        while (entry != null) {
            objectArray[n] = entry.value;
            entry = entry.next;
            ++n;
        }
        return objectArray;
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public Runnable todo(int n) throws InterruptedException {
        return (Runnable)this.dequeue(n);
    }

    public Queue(int n) {
        this.maxSize = n;
    }

    public Queue() {
        this(Integer.MAX_VALUE);
    }

    static class Entry {
        Entry next;
        Object value;

        Entry(Object object) {
            this.value = object;
        }
    }
}

