/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.RegistryException;
import javax.baja.sys.BModule;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.PatternFilter;

public class Lexicon {
    private static Log log = Log.getLog("sys.lexicon");
    private static HashMap common = new HashMap();
    private static Properties empty = new Properties();
    private static ArrayList extendedPropsModules = new ArrayList();
    private static final LexiconProcessor[] PROCESSORS = new LexiconProcessor[]{new NestedLexiconTag(), new BrandLexiconTag()};
    public final BModule module;
    public final String language;
    public final String country;
    public final String variant;
    private Properties moduleProps;
    private Properties langProps;

    public static Lexicon make(BModule bModule, String string, String string2, String string3) {
        return new Lexicon(bModule, string, string2, string3);
    }

    public static Lexicon make(BModule bModule, String string) {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equalsIgnoreCase(string)) {
            return Lexicon.make(bModule, locale.getLanguage(), locale.getCountry(), locale.getVariant());
        }
        return Lexicon.make(bModule, string, "", "");
    }

    public static Lexicon make(String string, String string2, String string3, String string4) {
        return Lexicon.make(Lexicon.module(string), string2, string3, string4);
    }

    public static Lexicon make(String string, String string2) {
        return Lexicon.make(Lexicon.module(string), string2);
    }

    public static Lexicon make(BModule bModule, Locale locale) {
        return Lexicon.make(bModule, locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static Lexicon make(BModule bModule, Context context) {
        return Lexicon.make(bModule, Lexicon.lang(context));
    }

    public static Lexicon make(String string, Locale locale) {
        return Lexicon.make(Lexicon.module(string), locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static Lexicon make(String string, Context context) {
        return Lexicon.make(Lexicon.module(string), Lexicon.lang(context));
    }

    public static Lexicon make(String string) {
        return Lexicon.make(Lexicon.module(string), Locale.getDefault());
    }

    public static Lexicon make(Class clazz) {
        return Lexicon.make(Sys.getModuleForClass(clazz), Locale.getDefault());
    }

    static BModule module(String string) {
        try {
            return Sys.loadModule(string);
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            if (log.isTraceOn()) {
                log.warning("Lexicon.make module not found: " + string);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static String lang(Context context) {
        if (context != null) {
            return context.getLanguage();
        }
        return Sys.getLanguage();
    }

    public static String removeUnderscore(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.setLength(string.length());
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '_') {
                stringBuffer.setCharAt(n++, c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Properties getModuleProperties() {
        return this.moduleProps;
    }

    public Properties getLanguageProperties() {
        return this.langProps;
    }

    public String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String get(String string) {
        String string2 = null;
        if (this.langProps != null) {
            string2 = (String)this.langProps.get(string);
        }
        if (string2 == null && this.moduleProps != null) {
            string2 = (String)this.moduleProps.get(string);
        }
        if (string2 == null) {
            return null;
        }
        string2 = Lexicon.process(string2, this);
        return string2;
    }

    public String getText(String string) {
        return this.get(string, string);
    }

    public String getText(String string, Object[] objectArray) {
        String string2 = this.get(string, null);
        if (string2 == null) {
            return string;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public String getTextAsName(String string) {
        return SlotPath.escape(this.getText(string));
    }

    public String toString() {
        String string = "Lexicon:" + this.module + ':' + this.language;
        if (this.country != null && this.country.length() > 0) {
            string = string + '_' + this.country;
        }
        return string;
    }

    private static final String process(String string, Lexicon lexicon) {
        if (string == null) {
            return string;
        }
        int n = 0;
        while (n < PROCESSORS.length) {
            string = PROCESSORS[n].format(string, lexicon);
            ++n;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Properties load(BModule bModule, String string) {
        HashMap hashMap = common;
        synchronized (hashMap) {
            Properties properties;
            block8: {
                String string2;
                block10: {
                    InputStream inputStream;
                    block9: {
                        string2 = Lexicon.getCommonKey(bModule, string);
                        properties = (Properties)common.get(string2);
                        if (properties != null) break block8;
                        properties = new Properties();
                        if (string == null) break block9;
                        try {
                            inputStream = Lexicon.getInputStreamFromModule(bModule, string, true);
                            properties.load(inputStream);
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            if (!"en".equals(string)) {
                                log.trace("Cannot load niagara default \"" + string2 + '\"');
                            }
                        }
                    }
                    try {
                        inputStream = Lexicon.getInputStream(bModule, string);
                        properties.load(inputStream);
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        if ("en".equals(string)) break block10;
                        log.trace("Cannot load \"" + string2 + '\"');
                    }
                }
                properties = Lexicon.trim(properties);
                common.put(string2, properties);
            }
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void loadFromModule(BModule bModule, String string) {
        HashMap hashMap = common;
        synchronized (hashMap) {
            String string2 = Lexicon.getCommonKey(bModule, string);
            Properties properties = (Properties)common.get(string2);
            if (properties == null) {
                return;
            }
            try {
                log.trace("Load extended \"" + string2 + "\" for module " + bModule.getModuleName());
                InputStream[] inputStreamArray = Lexicon.getInputStreamsFromModule(bModule, string);
                int n = 0;
                while (n < inputStreamArray.length) {
                    properties.load(inputStreamArray[n]);
                    inputStreamArray[n].close();
                    ++n;
                }
            }
            catch (Throwable throwable) {}
            properties = Lexicon.trim(properties);
            return;
        }
    }

    private static final String getCommonKey(BModule bModule, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bModule.getModuleName());
        if (string != null) {
            stringBuffer.append('-').append(string);
        }
        return stringBuffer.toString();
    }

    private static final Properties trim(Properties properties) {
        Properties properties2 = new Properties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)properties.get(string);
            properties2.put(string, string2.trim());
        }
        return properties2;
    }

    public static InputStream getInputStreamFromModule(BModule bModule, String string, boolean bl) throws Exception {
        String string2 = bModule.getModuleName();
        LexiconInfo[] lexiconInfoArray = Sys.getRegistry().getLexicons(string2, string);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < lexiconInfoArray.length) {
            InputStream inputStream;
            if (bl && lexiconInfoArray[n].isDefault() && (inputStream = Lexicon.getInputStreamFromModule(lexiconInfoArray[n])) != null) {
                return inputStream;
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw new BajaRuntimeException("No default lexicons found for " + string2 + " for locale key " + string);
        }
        return null;
    }

    public static InputStream[] getInputStreamsFromModule(BModule bModule, String string) throws Exception {
        String string2 = bModule.getModuleName();
        LexiconInfo[] lexiconInfoArray = Sys.getRegistry().getLexicons(string2, string);
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        int n = 0;
        while (n < lexiconInfoArray.length) {
            InputStream inputStream;
            if (!lexiconInfoArray[n].isDefault() && (inputStream = Lexicon.getInputStreamFromModule(lexiconInfoArray[n])) != null) {
                log.trace("  Adding module lexicon " + lexiconInfoArray[n].getContainerModuleName() + " to input stream list");
                arrayList.add(inputStream);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw new BajaRuntimeException("No lexicons found for " + string2);
        }
        return arrayList.toArray(new InputStream[0]);
    }

    public static InputStream getInputStreamFromModule(LexiconInfo lexiconInfo) throws Exception {
        Object object;
        String string = lexiconInfo.getModuleName();
        String string2 = lexiconInfo.getResourcePath();
        String string3 = lexiconInfo.getContainerModuleName();
        String string4 = lexiconInfo.getBrandPattern();
        String string5 = null;
        try {
            string5 = Brand.getBrandId();
        }
        catch (Exception exception) {}
        if (string4.length() != 0 && string5 != null && !((PatternFilter)(object = new PatternFilter(string4))).accept(string5)) {
            log.warning("Lexicon loading: No brand match in module" + string);
            return null;
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new RegistryException("Unknown registry lexicon for " + string);
        }
        object = Lexicon.module(string3);
        BIFile bIFile = ((BZipSpace)object).findFile(new FilePath("zip", string2));
        if (bIFile != null) {
            lexiconInfo.setLastModified(bIFile.getLastModified());
            InputStream inputStream = bIFile.getInputStream();
            return inputStream;
        }
        StringBuffer stringBuffer = new StringBuffer("module://");
        stringBuffer.append(string3).append("/").append(string2);
        BOrd bOrd = BOrd.make(stringBuffer.toString());
        BIFile bIFile2 = (BIFile)((Object)bOrd.resolve().get());
        lexiconInfo.setLastModified(bIFile2.getLastModified());
        InputStream inputStream = bIFile2.getInputStream();
        return inputStream;
    }

    public static InputStream getInputStream(BModule bModule, String string) throws Exception {
        String string2 = bModule.getModuleName();
        if (string != null) {
            return Nre.bootEnv.read("/lexicon/" + string + '/' + string2 + ".lexicon");
        }
        BOrd bOrd = BOrd.make("local:|module://" + string2 + '/' + string2 + ".lexicon");
        BIFile bIFile = (BIFile)((Object)bOrd.resolve().get());
        return bIFile.getInputStream();
    }

    private static final InputStream getBrandInputStream(BModule bModule) throws Exception {
        String string = bModule.getModuleName();
        BOrd bOrd = BOrd.make("local:|module://brand/" + string + "_brand.lexicon");
        BIFile bIFile = (BIFile)((Object)bOrd.resolve().get());
        return bIFile.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void invalidateCache() {
        HashMap hashMap = common;
        synchronized (hashMap) {
            log.trace("Entire lexicon cache is being cleared");
            common.clear();
            extendedPropsModules.clear();
            return;
        }
    }

    public static Vector searchLexiconCache(String string) {
        log.trace("  Searching for Lexicon entries containing " + string);
        Vector<String[]> vector = new Vector<String[]>();
        Iterator iterator = common.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Properties properties = (Properties)common.get(string2);
            Iterator<Object> iterator2 = properties.keySet().iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                String string4 = (String)properties.get(string3);
                if (string4.indexOf(string) < 0) continue;
                String[] stringArray = new String[]{string2, string3, string4};
                vector.add(stringArray);
            }
        }
        return vector;
    }

    protected Lexicon(BModule bModule, String string) {
        this(bModule, string, "", "");
    }

    protected Lexicon(BModule bModule, String string, String string2, String string3) {
        if (string == null || string.equals("")) {
            string = Sys.getLanguage();
        }
        if (string == null) {
            throw new RuntimeException("Invalid Nre boot sequence, Sys.lang null");
        }
        String string4 = string;
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            string4 = string4 + '_' + string2;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string3.length() > 0) {
            string4 = string4 + '_' + string3;
        }
        this.module = bModule;
        this.language = string;
        this.country = string2;
        this.variant = string3;
        if (bModule == null) {
            this.moduleProps = empty;
            this.langProps = empty;
            return;
        }
        this.moduleProps = Lexicon.load(bModule, null);
        this.langProps = Lexicon.load(bModule, string4);
        if (this.langProps.isEmpty()) {
            this.langProps = Lexicon.load(bModule, string);
        }
        String string5 = Lexicon.getCommonKey(bModule, string4);
        if (!extendedPropsModules.contains(bModule.getModuleName())) {
            Lexicon.loadFromModule(bModule, null);
            extendedPropsModules.add(bModule.getModuleName());
        }
        if (!extendedPropsModules.contains(string5)) {
            Lexicon.loadFromModule(bModule, string4);
            extendedPropsModules.add(string5);
        }
    }

    private static abstract class LexiconProcessor {
        public abstract String format(String var1, Lexicon var2);

        private LexiconProcessor() {
        }
    }

    private static class NestedLexiconTag
    extends LexiconTag {
        private static final String TAG = "lexicon";

        public String getTagName() {
            return TAG;
        }

        public String getValue(String string, Lexicon lexicon) {
            String[] stringArray = TextUtil.split((String)string, (char)':');
            if (stringArray.length == 1) {
                return Lexicon.process(lexicon.get(stringArray[0].trim()), lexicon);
            }
            if (stringArray.length == 2) {
                Lexicon lexicon2 = Lexicon.make(stringArray[0].trim(), lexicon.language, lexicon.country, lexicon.variant);
                if (lexicon2.module == null) {
                    return stringArray[1].trim();
                }
                return Lexicon.process(lexicon2.get(stringArray[1].trim()), lexicon2);
            }
            throw new BajaRuntimeException("Invalid parameters: " + string);
        }

        private NestedLexiconTag() {
        }
    }

    private static class BrandLexiconTag
    extends LexiconTag {
        protected static String TAG = "brand";

        public String getTagName() {
            return TAG;
        }

        public String getValue(String string, Lexicon lexicon) {
            String string2 = "";
            try {
                string2 = Brand.getBrandId();
            }
            catch (Exception exception) {
                return null;
            }
            String[] stringArray = TextUtil.split((String)string, (char)':');
            if (stringArray.length == 3) {
                if (string2.equalsIgnoreCase(stringArray[0].trim())) {
                    if (stringArray[1].trim() != lexicon.module.getModuleName()) {
                        Lexicon lexicon2 = Lexicon.make(stringArray[1].trim());
                        return lexicon2.getText(stringArray[2].trim());
                    }
                    return lexicon.getText(stringArray[2].trim());
                }
                return stringArray[2].trim();
            }
            if (stringArray.length == 2) {
                if (string2.equalsIgnoreCase(stringArray[0].trim())) {
                    return lexicon.getText(stringArray[1].trim());
                }
                return stringArray[1].trim();
            }
            throw new BajaRuntimeException("Invalid parameters: " + string);
        }

        private BrandLexiconTag() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static abstract class LexiconTag
    extends LexiconProcessor {
        protected final String tagStart;

        public abstract String getTagName();

        public abstract String getValue(String var1, Lexicon var2);

        public final String format(String string, Lexicon lexicon) {
            while (string.indexOf(this.tagStart) != -1) {
                int n = string.indexOf(this.tagStart);
                int n2 = string.indexOf("}", n);
                StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.25));
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(this.getValue(string.substring(n + this.tagStart.length(), n2), lexicon));
                stringBuffer.append(string.substring(n2 + 1));
                string = stringBuffer.toString();
            }
            return string;
        }

        private final /* synthetic */ void this() {
            this.tagStart = "{" + this.getTagName() + ':';
        }

        private LexiconTag() {
            this.this();
        }
    }
}

