/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CoalesceQueue
extends Queue {
    HashEntry[] table;
    int hashSize;
    int threshold;
    float loadFactor;

    public synchronized Object find(Object object) {
        HashEntry hashEntry;
        if (object instanceof ICoalesceable && (hashEntry = this.get((ICoalesceable)object)) != null) {
            return hashEntry.value;
        }
        return null;
    }

    public synchronized Object dequeue() {
        Queue.Entry entry = this.head;
        if (entry == null) {
            return null;
        }
        super.dequeue();
        if (entry.value instanceof ICoalesceable) {
            this.remove((ICoalesceable)entry.value);
        }
        return entry.value;
    }

    public synchronized boolean enqueue(Object object) throws QueueFullException {
        ICoalesceable iCoalesceable;
        HashEntry hashEntry;
        if (object instanceof ICoalesceable && (hashEntry = this.get(iCoalesceable = (ICoalesceable)object)) != null) {
            ICoalesceable iCoalesceable2 = (ICoalesceable)hashEntry.value;
            hashEntry.value = iCoalesceable2.coalesce(iCoalesceable);
            return false;
        }
        return super.enqueue(object);
    }

    Queue.Entry newEntry(Object object) {
        if (object instanceof ICoalesceable) {
            return this.put((ICoalesceable)object);
        }
        return new Queue.Entry(object);
    }

    public synchronized void clear() {
        super.clear();
        this.hashSize = 0;
        this.table = new HashEntry[this.table.length];
    }

    HashEntry get(ICoalesceable iCoalesceable) {
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        HashEntry[] hashEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashEntryArray.length;
        HashEntry hashEntry = hashEntryArray[n2];
        while (hashEntry != null) {
            if (hashEntry.hash == n && ((ICoalesceable)hashEntry.value).getCoalesceKey().equals(object)) {
                return hashEntry;
            }
            hashEntry = hashEntry.hashNext;
        }
        return null;
    }

    void rehash() {
        int n = this.table.length;
        HashEntry[] hashEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashEntry[] hashEntryArray2 = new HashEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashEntry hashEntry = hashEntryArray[n3];
            while (hashEntry != null) {
                HashEntry hashEntry2 = hashEntry;
                hashEntry = hashEntry.hashNext;
                int n4 = (hashEntry2.hash & Integer.MAX_VALUE) % n2;
                hashEntry2.hashNext = hashEntryArray2[n4];
                hashEntryArray2[n4] = hashEntry2;
            }
        }
    }

    HashEntry put(ICoalesceable iCoalesceable) {
        if (this.hashSize >= this.threshold) {
            this.rehash();
            return this.put(iCoalesceable);
        }
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        HashEntry[] hashEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashEntryArray.length;
        HashEntry hashEntry = new HashEntry(iCoalesceable);
        hashEntry.hash = n;
        hashEntry.hashNext = hashEntryArray[n2];
        hashEntryArray[n2] = hashEntry;
        ++this.hashSize;
        return hashEntry;
    }

    Object remove(ICoalesceable iCoalesceable) {
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        HashEntry[] hashEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashEntryArray.length;
        HashEntry hashEntry = hashEntryArray[n2];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hash == n && ((ICoalesceable)hashEntry.value).getCoalesceKey().equals(object)) {
                if (hashEntry2 != null) {
                    hashEntry2.hashNext = hashEntry.hashNext;
                } else {
                    hashEntryArray[n2] = hashEntry.hashNext;
                }
                --this.hashSize;
                return hashEntry.value;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.hashNext;
        }
        throw new IllegalStateException();
    }

    private final /* synthetic */ void this() {
        this.loadFactor = 0.75f;
    }

    public CoalesceQueue(int n) {
        super(n);
        this.this();
        this.table = new HashEntry[Math.max(16, Math.min(n / 3, 101))];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public CoalesceQueue() {
        this(Integer.MAX_VALUE);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HashEntry
    extends Queue.Entry {
        int hash;
        HashEntry hashNext;

        HashEntry(Object object) {
            super(object);
        }
    }
}

