/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BClassSpec
extends BSimple {
    public static final BClassSpec NULL = new BClassSpec();
    public static final BClassSpec DEFAULT;
    public static final Type TYPE;
    private String spec;
    private String moduleName;
    private String className;
    private Class cls;
    static /* synthetic */ Class class$javax$baja$util$BClassSpec;

    public static final BClassSpec make(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        BClassSpec bClassSpec = new BClassSpec();
        bClassSpec.moduleName = string;
        bClassSpec.className = string2;
        bClassSpec.spec = string + ':' + string2;
        return (BClassSpec)bClassSpec.intern();
    }

    public static final BClassSpec make(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        try {
            BClassSpec bClassSpec = new BClassSpec();
            int n = string.indexOf(58);
            bClassSpec.moduleName = string.substring(0, n);
            bClassSpec.className = string.substring(n + 1);
            bClassSpec.spec = string;
            return (BClassSpec)bClassSpec.intern();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    public static final BClassSpec make(BModule bModule, Class clazz) {
        BClassSpec bClassSpec = new BClassSpec();
        bClassSpec.moduleName = bModule.getModuleName();
        bClassSpec.className = clazz.getName();
        bClassSpec.spec = bClassSpec.moduleName + ':' + bClassSpec.className;
        bClassSpec = (BClassSpec)bClassSpec.intern();
        bClassSpec.cls = clazz;
        return bClassSpec;
    }

    public static final BClassSpec make(Class clazz) {
        BClassSpec bClassSpec = new BClassSpec();
        bClassSpec.moduleName = Sys.getModuleForClass(clazz).getModuleName();
        bClassSpec.className = clazz.getName();
        bClassSpec.spec = bClassSpec.moduleName + ':' + bClassSpec.className;
        bClassSpec = (BClassSpec)bClassSpec.intern();
        bClassSpec.cls = clazz;
        return bClassSpec;
    }

    public final boolean isNull() {
        return this.spec.equals("null");
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final String getClassName() {
        return this.className;
    }

    public final Class getResolvedClass() throws IOException, ModuleException, ClassNotFoundException {
        if (this.cls == null) {
            BModule bModule = Sys.loadModule(this.moduleName);
            if (bModule == null) {
                throw new ModuleException("Should never happen");
            }
            this.cls = bModule.loadClass(this.className);
            return this.cls;
        }
        return this.cls;
    }

    public final Object newInstance() throws IOException, ModuleException, IllegalAccessException, InstantiationException, ClassNotFoundException, ClassCastException {
        return this.getResolvedClass().newInstance();
    }

    public final int hashCode() {
        return this.spec.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BClassSpec) {
            return this.spec.equals(((BClassSpec)object).spec);
        }
        return false;
    }

    public final String toString(Context context) {
        return this.spec;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.spec);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BClassSpec.make(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.spec;
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BClassSpec.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid type spec: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BClassSpec() {
    }

    static {
        BClassSpec.NULL.spec = "null";
        DEFAULT = NULL;
        Class clazz = class$javax$baja$util$BClassSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BClassSpec = BClassSpec.class("[Ljavax.baja.util.BClassSpec;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

