/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.user.BUserPasswordConfiguration;
import javax.baja.category.BCategoryMask;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.NavFileDecoder;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.baja.user.PermissionsManager;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUser
extends BComponent
implements BIStatus,
Context {
    public static final Property fullName = BUser.newProperty(0, "", null);
    public static final Property enabled = BUser.newProperty(0, true, null);
    public static final Property expiration = BUser.newProperty(0, BAbsTime.NULL, BFacets.make("fieldEditor", "wbutil:ExpirationFE"));
    public static final Property lockOut = BUser.newProperty(1, false, null);
    public static final Property permissions = BUser.newProperty(0, BPermissionsMap.DEFAULT, null);
    public static final Property language = BUser.newProperty(0, "", BFacets.make("fieldWidth", BInteger.make(6)));
    public static final Property email = BUser.newProperty(256, "", null);
    public static final Property password = BUser.newProperty(256, BPassword.DEFAULT, BFacets.make("fieldEditor", "wbutil:UserPasswordFE"));
    public static final Property facets = BUser.newProperty(256, BFacets.NULL, BFacets.make("fieldEditor", "wbutil:UserFacetsFE"));
    public static final Property navFile = BUser.newProperty(0, BOrd.NULL, null);
    public static final Property prototypeName = BUser.newProperty(0, "", BFacets.make("fieldEditor", BString.make("workbench:UserPrototypeFE")));
    public static final Property networkUser = BUser.newProperty(0, false, BFacets.make("fieldEditor", "wbutil:NetworkUserFE"));
    public static final Property version = BUser.newProperty(5, "", null);
    public static final Property prototypeVersion = BUser.newProperty(5, "", null);
    public static final Property cellPhoneNumber = BUser.newProperty(256, "", null);
    public static final Action clearLockOut = BUser.newAction(0, null);
    public static final Action setModified = BUser.newAction(0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final Log log;
    static final BOrd DEFAULT_HOME_PAGE;
    public static final Context pwConverted;
    private static volatile boolean checkLicense;
    private static boolean guestLicensed;
    Queue authFailTimes = new Queue();
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public String getFullName() {
        return this.getString(fullName);
    }

    public void setFullName(String string) {
        this.setString(fullName, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    public void setExpiration(BAbsTime bAbsTime) {
        this.set(expiration, (BValue)bAbsTime, null);
    }

    public boolean getLockOut() {
        return this.getBoolean(lockOut);
    }

    public void setLockOut(boolean bl) {
        this.setBoolean(lockOut, bl, null);
    }

    public BPermissionsMap getPermissions() {
        return (BPermissionsMap)this.get(permissions);
    }

    public void setPermissions(BPermissionsMap bPermissionsMap) {
        this.set(permissions, (BValue)bPermissionsMap, null);
    }

    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String string) {
        this.setString(language, string, null);
    }

    public String getEmail() {
        return this.getString(email);
    }

    public void setEmail(String string) {
        this.setString(email, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BOrd getNavFile() {
        return (BOrd)this.get(navFile);
    }

    public void setNavFile(BOrd bOrd) {
        this.set(navFile, (BValue)bOrd, null);
    }

    public String getPrototypeName() {
        return this.getString(prototypeName);
    }

    public void setPrototypeName(String string) {
        this.setString(prototypeName, string, null);
    }

    public boolean getNetworkUser() {
        return this.getBoolean(networkUser);
    }

    public void setNetworkUser(boolean bl) {
        this.setBoolean(networkUser, bl, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String string) {
        this.setString(version, string, null);
    }

    public String getPrototypeVersion() {
        return this.getString(prototypeVersion);
    }

    public void setPrototypeVersion(String string) {
        this.setString(prototypeVersion, string, null);
    }

    public String getCellPhoneNumber() {
        return this.getString(cellPhoneNumber);
    }

    public void setCellPhoneNumber(String string) {
        this.setString(cellPhoneNumber, string, null);
    }

    public void clearLockOut() {
        this.invoke(clearLockOut, null, null);
    }

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    static BUser makeAdmin() {
        BUser bUser = new BUser();
        bUser.setFlags(permissions, bUser.getFlags(permissions) | 1);
        bUser.setFlags(expiration, bUser.getFlags(expiration) | 1);
        bUser.checkAdmin();
        return bUser;
    }

    static BUser makeGuest() {
        BUser bUser = new BUser();
        bUser.setEnabled(false);
        bUser.checkGuest();
        return bUser;
    }

    private final void checkAdmin() {
        if (!this.getExpiration().isNull()) {
            this.setExpiration(BAbsTime.NULL);
        }
        if (!this.getPermissions().isSuperUser()) {
            this.setPermissions(BPermissionsMap.SUPER_USER);
        }
    }

    private final void checkGuest() {
        Object object;
        if (!this.isRunning()) {
            return;
        }
        if (checkLicense) {
            try {
                object = Sys.getLicenseManager().getFeature("tridium", "station");
                guestLicensed = object.getb("guestEnabled", false);
            }
            catch (LicenseException licenseException) {
                guestLicensed = false;
            }
            checkLicense = false;
            if (!guestLicensed && log.isTraceOn()) {
                log.trace("Guest user account not licensed. Guest user is disabled.");
            }
        }
        if (guestLicensed) {
            object = this.getParent();
            Property property = this.getPropertyInParent();
            if (object != null && property != null) {
                int n = ((BComplex)object).getFlags(property);
                if ((n & 4) != 0) {
                    n &= 0xFFFFFFFB;
                }
                if ((n & 1) != 0) {
                    n &= 0xFFFFFFFE;
                }
                ((BComplex)object).setFlags(property, n);
                Flags.setAllReadonly(this, false, null);
            }
        } else {
            if (this.getEnabled()) {
                this.setEnabled(false);
            }
            object = this.getParent();
            Property property = this.getPropertyInParent();
            if (object != null && property != null) {
                int n = ((BComplex)object).getFlags(property);
                if ((n & 4) == 0) {
                    n |= 4;
                }
                if ((n & 1) == 0) {
                    n |= 1;
                }
                ((BComplex)object).setFlags(property, n);
                Flags.setAllReadonly(this, true, null);
            }
        }
    }

    public String getUsername() {
        String string = this.getName();
        if (string == null) {
            return "";
        }
        return SlotPath.unescape(string);
    }

    public boolean isExpired() {
        return BUser.isExpired(this.getExpiration());
    }

    public static boolean isExpired(BAbsTime bAbsTime) {
        if (bAbsTime.isNull()) {
            return false;
        }
        boolean bl = false;
        if (bAbsTime.getMillis() < Clock.millis()) {
            bl = true;
        }
        return bl;
    }

    public BOrd getHomePage() {
        try {
            BOrd bOrd = this.getNavFile();
            if (!bOrd.isNull()) {
                BNavFileNode bNavFileNode = NavFileDecoder.load(bOrd).getRootNode();
                return bNavFileNode.getOrdInSession();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return DEFAULT_HOME_PAGE;
    }

    public final Context getBase() {
        return null;
    }

    public final BUser getUser() {
        return this;
    }

    public final BObject getFacet(String string) {
        return this.getFacets().get(string);
    }

    public BStatus getStatus() {
        int n = 0;
        if (!this.getEnabled()) {
            n |= 1;
        }
        if (this.isExpired()) {
            n |= 2;
        }
        if (this.getLockOut()) {
            n |= 8;
        }
        return BStatus.make(n);
    }

    public void authenticateOk(BUserService bUserService) {
        this.authFailTimes.clear();
    }

    public void authenticateFailed(BUserService bUserService) {
        if (!bUserService.getLockOutEnabled()) {
            return;
        }
        BAbsTime bAbsTime = BAbsTime.now();
        this.authFailTimes.enqueue(bAbsTime);
        BAbsTime bAbsTime2 = bAbsTime.subtract(bUserService.getLockOutWindow());
        while (((BAbsTime)this.authFailTimes.peek()).isBefore(bAbsTime2)) {
            this.authFailTimes.dequeue();
        }
        if (this.authFailTimes.size() >= bUserService.getMaxBadLoginsBeforeLockOut()) {
            this.setLockOut(true);
            this.authenticateOk(bUserService);
            Clock.schedule((BComponent)this, bUserService.getLockOutPeriod(), clearLockOut, null);
        }
    }

    public void doClearLockOut() {
        this.setLockOut(false);
    }

    private final BPermissionsMap getPermissionsMap(BIProtected bIProtected) {
        if (this.getParent() instanceof BUserService) {
            BUserService bUserService = (BUserService)this.getParent();
            PermissionsManager[] permissionsManagerArray = bUserService.getPermissionsManagers();
            int n = 0;
            while (n < permissionsManagerArray.length) {
                BPermissionsMap bPermissionsMap = permissionsManagerArray[n].getPermissionsMap(this, bIProtected);
                if (bPermissionsMap != null) {
                    return bPermissionsMap;
                }
                ++n;
            }
        }
        return this.getPermissions();
    }

    public BPermissions getPermissions(Context context) {
        BPermissions bPermissions = super.getPermissions(context);
        BUser bUser = null;
        if (context != null) {
            bUser = context.getUser();
        }
        if (bUser == null) {
            return bPermissions;
        }
        if (bUser != this) {
            if (!bPermissions.hasAdminRead()) {
                return BPermissions.none;
            }
            if (!bPermissions.hasAdminWrite()) {
                bPermissions = BPermissions.make(bPermissions.getMask() & 0xFFFFFFFD);
            } else if (this.getPermissions().isSuperUser() && !bUser.getPermissions().isSuperUser()) {
                bPermissions = BPermissions.make(bPermissions.getMask() & 0xFFFFFFDF);
                bPermissions = BPermissions.make(bPermissions.getMask() & 0xFFFFFFFD);
            }
        }
        return bPermissions;
    }

    public BPermissions getPermissionsFor(BIProtected bIProtected) {
        BComplex bComplex;
        BCategoryMask bCategoryMask;
        BPermissions bPermissions;
        BPermissions bPermissions2;
        BCategoryMask bCategoryMask2 = bIProtected.getAppliedCategoryMask();
        if (bIProtected instanceof BComponent && !((BComponent)bIProtected).isMounted() && bCategoryMask2.isNull()) {
            return BPermissions.all;
        }
        BPermissionsMap bPermissionsMap = this.getPermissions();
        if (!bPermissionsMap.isSuperUser()) {
            bPermissionsMap = this.getPermissionsMap(bIProtected);
        }
        if (!(bPermissions2 = bPermissionsMap.getPermissions(bCategoryMask2)).hasOperatorRead() && (bIProtected instanceof BComponent || bIProtected instanceof BComponentSpace) && (bPermissions = bPermissionsMap.getPermissions(bCategoryMask = ((ComponentSlotMap)(bComplex = bIProtected instanceof BComponent ? (BComponent)bIProtected : ((BComponentSpace)bIProtected).getRootComponent()).fw(1)).getDeepOrCategoryMask())).getMask() != 0) {
            bPermissions2 = BPermissions.operatorRead;
        }
        if (bIProtected instanceof BComplex && (bComplex = ((BComplex)((Object)bIProtected)).getParent()) instanceof BUser) {
            bIProtected = (BIProtected)((Object)bComplex);
        }
        if (bIProtected instanceof BUser && bIProtected != this && !bPermissionsMap.isSuperUser() && ((BUser)bIProtected).getPermissions().isSuperUser()) {
            bPermissions2 = BPermissions.make(bPermissions2.getMask() & 0xFFFFFFDF);
            bPermissions2 = BPermissions.make(bPermissions2.getMask() & 0xFFFFFFFD);
        }
        return bPermissions2;
    }

    public void check(BIProtected bIProtected, BPermissions bPermissions) throws PermissionException {
        BPermissions bPermissions2 = this.getPermissionsFor(bIProtected);
        if (!bPermissions2.has(bPermissions)) {
            throw new PermissionException(bPermissions2 + " < " + bPermissions);
        }
    }

    public void checkRead(BComponent bComponent, Slot slot) {
        if (Flags.isOperator(bComponent, slot)) {
            this.check(bComponent, BPermissions.operatorRead);
        } else {
            this.check(bComponent, BPermissions.adminRead);
        }
    }

    public void checkWrite(BComponent bComponent, Slot slot) {
        if (bComponent instanceof BUser && slot.equals(permissions) && ((BUser)bComponent).getPermissions().isSuperUser() && !this.getPermissions().isSuperUser()) {
            throw new PermissionException("SuperUser required");
        }
        if (Flags.isOperator(bComponent, slot)) {
            this.check(bComponent, BPermissions.operatorWrite);
        } else {
            this.check(bComponent, BPermissions.adminWrite);
        }
    }

    public void checkInvoke(BComponent bComponent, Slot slot) {
        if (Flags.isOperator(bComponent, slot)) {
            this.check(bComponent, BPermissions.operatorInvoke);
        } else {
            this.check(bComponent, BPermissions.adminInvoke);
        }
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                BComponentSpace bComponentSpace = this.getComponentSpace();
                if (bComponentSpace != null && !bComponentSpace.fireDirectCallbacks()) break;
                this.fwChanged((Property)object, (Context)object2);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BUserService) {
            if (this.getName().equals("admin")) {
                this.checkAdmin();
            } else if (this.getName().equals("guest")) {
                this.checkGuest();
            }
            if (this.getLockOut()) {
                Clock.schedule((BComponent)this, ((BUserService)bComplex).getLockOutPeriod(), clearLockOut, null);
            }
        } else if (this.getLockOut()) {
            this.setLockOut(false);
        }
        if (this.getVersion().length() == 0) {
            this.updateVersion();
        }
    }

    private final void fwChanged(Property property, Context context) {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BUserService) {
            if (this.getName().equals("admin")) {
                this.checkAdmin();
            } else if (this.getName().equals("guest")) {
                this.checkGuest();
            }
            if (property.equals(password) && context != pwConverted) {
                this.convertToPbkdf2Password();
            }
        }
        if (this.isRunning() && property.equals(prototypeName)) {
            this.setPrototypeVersion("");
        }
    }

    private final BUserPasswordConfiguration getPasswordConfig() {
        return (BUserPasswordConfiguration)this.getMixIn(BUserPasswordConfiguration.TYPE);
    }

    private final void updatePasswordHistory() {
        BUserPasswordConfiguration bUserPasswordConfiguration;
        if (((BUserService)this.getParent()).canUsePasswordFeatures(this) && (bUserPasswordConfiguration = this.getPasswordConfig()) != null) {
            bUserPasswordConfiguration.passwordModified();
        }
    }

    boolean convertToPbkdf2Password() {
        BPassword bPassword = this.getPassword();
        if (bPassword.getPasswordEncoder().isReversible()) {
            this.updatePasswordHistory();
            BPassword bPassword2 = BPassword.make(bPassword.getValue(), "pbkdf2hmacsha256/text");
            this.set("password", (BValue)bPassword2, pwConverted);
            return true;
        }
        return false;
    }

    private final void fwDescendantsStarted() {
    }

    public String toString(Context context) {
        return this.getUsername();
    }

    public BIcon getIcon() {
        return icon;
    }

    public void doSetModified() {
        BComponent bComponent = (BComponent)this.getParent();
        if (bComponent instanceof BUserService) {
            ((BUserService)bComponent).setModified(this);
        } else {
            this.updateVersion();
        }
    }

    public void updateVersion() {
        String string = "";
        if (Sys.getStation() != null) {
            string = Sys.getStation().getStationName();
        }
        this.setVersion(string + ':' + System.currentTimeMillis());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$user$BUser;
        if (clazz == null) {
            clazz = class$javax$baja$user$BUser = BUser.class("[Ljavax.baja.user.BUser;", false);
        }
        TYPE = Sys.loadType(clazz);
        icon = BIcon.std("user.png");
        log = Log.getLog("sys.service");
        DEFAULT_HOME_PAGE = BOrd.make("station:|slot:/");
        pwConverted = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.pwConverted";
            }
        };
        checkLicense = true;
        guestLicensed = false;
    }
}

