/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class UnitDifferentialConverter {
    static HashMap byDifferential = new HashMap();
    static HashMap byAbsolute = new HashMap();
    private static UnitDifferentialConverter INSTANCE = new UnitDifferentialConverter();

    public final BUnit getDifferential(BUnit bUnit) {
        BUnit bUnit2 = (BUnit)byAbsolute.get(bUnit.getUnitName());
        if (bUnit2 != null) {
            return bUnit2;
        }
        return bUnit;
    }

    public final BUnit getAbsolute(BUnit bUnit) {
        BUnit bUnit2 = (BUnit)byDifferential.get(bUnit.getUnitName());
        if (bUnit2 != null) {
            return bUnit2;
        }
        return bUnit;
    }

    public static final UnitDifferentialConverter getInstance() {
        return INSTANCE;
    }

    private UnitDifferentialConverter() {
        try {
            XElem xElem = XParser.make((InputStream)Nre.bootEnv.read("/lib/unitDifferentialConversion.xml")).parse();
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem2 = xElemArray[n];
                try {
                    BUnit bUnit = UnitDatabase.getUnit(xElem2.get("differential"));
                    BUnit bUnit2 = UnitDatabase.getUnit(xElem2.get("absolute"));
                    byDifferential.put(bUnit.getUnitName(), bUnit2);
                    byAbsolute.put(bUnit2.getUnitName(), bUnit);
                }
                catch (Exception exception) {
                    Log.getLog("sys.unitConversion").warning("Parsing convert [line " + xElem2.line() + ']', exception);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Log.getLog("sys.unitConversion").error("Error parsing unitDifferentialConversion.xml", exception);
        }
    }
}

