/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import com.tridium.sys.Nre;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.TimeZoneDatabaseManifest;
import com.tridium.timezone.TzJarUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.baja.log.Log;
import javax.baja.timezone.BTimeZone;

public class TimeZoneDatabase {
    private static final short CACHE_SIZE;
    public static final long TOLERANCE;
    public static final String htzManifest = "META-INF/tzdb.xml";
    public static final String htzJarFileName = "timezones.jar";
    private static String[] supportedZones;
    private static HistoricalTimeZoneCache cache;
    private static final Log logger;
    private static TimeZoneDatabaseManifest MANIFEST_INSTANCE;
    private static TimeZoneDatabase INSTANCE;

    public static final synchronized TimeZoneDatabase get() {
        if (INSTANCE == null) {
            INSTANCE = new TimeZoneDatabase();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized TimeZoneDatabaseManifest getManifest() {
        if (MANIFEST_INSTANCE != null) return MANIFEST_INSTANCE;
        try {
            JarFile jarFile = new JarFile(Nre.bootEnv.findTimeZoneDatabase());
            ZipEntry zipEntry = jarFile.getEntry(htzManifest);
            if (zipEntry == null) {
                zipEntry = jarFile.getEntry(htzManifest.toLowerCase());
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                MANIFEST_INSTANCE = TimeZoneDatabaseManifest.make(inputStream);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var4_6 = null;
                try {}
                catch (Exception exception) {}
                inputStream.close();
                try {}
                catch (Exception exception) {
                    return MANIFEST_INSTANCE;
                }
                jarFile.close();
                return MANIFEST_INSTANCE;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("error loading timezones.jar manifest: " + exception.getMessage());
        }
        return MANIFEST_INSTANCE;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static BTimeZone getTimeZone(String string) {
        TimeZoneDatabase.get();
        return BTimeZone.getTimeZone(string);
    }

    protected final synchronized HistoricalTimeZone getHistoricalTimeZone(String string) {
        return this.getHistoricalTimeZone(string, System.currentTimeMillis());
    }

    protected final synchronized HistoricalTimeZone getHistoricalTimeZone(String string, long l) {
        logger.trace("attempting to retrieve the timezone: " + string);
        if (!TimeZoneDatabase.isZoneIdSupported(string)) {
            logger.trace("timezone: " + string + " was not found in timezones.jar, returning null");
            return null;
        }
        HistoricalTimeZone historicalTimeZone = (HistoricalTimeZone)cache.get(string);
        if (historicalTimeZone == null) {
            historicalTimeZone = TzJarUtil.getCompleteTimeZone(string);
            cache.put(string, historicalTimeZone);
        }
        return historicalTimeZone;
    }

    public static final boolean isZoneIdSupported(String string) {
        if (string.equals("NULL")) {
            return true;
        }
        if (supportedZones != null) {
            int n = 0;
            while (n < supportedZones.length) {
                if (supportedZones[n].equals(string)) {
                    return true;
                }
                n = (short)(n + 1);
            }
        }
        return false;
    }

    public static final String[] getAllSupportedZoneIds() {
        return supportedZones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized String[] getAllAvailableZoneIds() {
        try {
            String[] stringArray;
            JarFile jarFile = new JarFile(Nre.bootEnv.findTimeZoneDatabase());
            InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(htzManifest));
            try {
                stringArray = TimeZoneDatabaseManifest.make(inputStream).getZoneIds();
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            inputStream.close();
            try {}
            catch (Exception exception) {}
            jarFile.close();
            return stringArray;
        }
        catch (Exception exception) {
            logger.error("error reading timezones.jar: " + exception.getMessage());
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized BTimeZone[] getTimeZones() {
        try {
            BTimeZone[] bTimeZoneArray;
            File file = Nre.bootEnv.findTimeZoneDatabase();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                bTimeZoneArray = (BTimeZone[])TzJarUtil.getTimeZones(bufferedInputStream).trim();
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            ((InputStream)bufferedInputStream).close();
            return bTimeZoneArray;
        }
        catch (Exception exception) {
            logger.error("error reading timezones.jar: " + exception.getMessage());
            return new BTimeZone[0];
        }
    }

    private TimeZoneDatabase() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        logger = Log.getLog("timezone.db");
        int n = 20;
        long l = 3600000L;
        try {
            try {
                JarFile jarFile = new JarFile(Nre.bootEnv.findTimeZoneDatabase());
                ZipEntry zipEntry = jarFile.getEntry(htzManifest);
                if (zipEntry == null) {
                    zipEntry = jarFile.getEntry(htzManifest.toLowerCase());
                }
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                try {
                    MANIFEST_INSTANCE = TimeZoneDatabaseManifest.make(inputStream);
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        jarFile.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    Object var9_8 = null;
                }
                try {}
                catch (Exception exception) {}
                inputStream.close();
                try {}
                catch (Exception exception) {}
                jarFile.close();
                if (MANIFEST_INSTANCE == null) {
                    supportedZones = new String[0];
                    throw new NullPointerException("Time Zone Manifest Unavailable");
                }
                supportedZones = MANIFEST_INSTANCE.getZoneIds();
                if (supportedZones == null) {
                    supportedZones = new String[0];
                    throw new NullPointerException("No Time Zones Supported");
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= supportedZones.length) {
                        n = Short.parseShort(System.getProperty("niagara.timezone.dbCache.max", "20"));
                        l = Long.parseLong(System.getProperty("niagara.timezone.eraTolerance", "3600000"));
                    }
                    TimeZoneDatabase.supportedZones[n2] = supportedZones[n2].replace('\\', '/');
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.error("error loading timezones.jar manifest: " + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            CACHE_SIZE = (short)n;
            TOLERANCE = l;
            throw throwable;
        }
        {
            Object var4_12 = null;
        }
        CACHE_SIZE = (short)n;
        TOLERANCE = l;
        cache = new HistoricalTimeZoneCache(CACHE_SIZE + 1, 0.75f, true);
    }

    private static class HistoricalTimeZoneCache
    extends LinkedHashMap {
        protected boolean removeEldestEntry(Map.Entry entry) {
            boolean bl = false;
            if (this.size() > CACHE_SIZE) {
                bl = true;
            }
            return bl;
        }

        protected HistoricalTimeZoneCache(int n, float f, boolean bl) {
            super(n, f, bl);
        }
    }
}

