/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.security.InvalidParameterException;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TypeSubscriber {
    private Array subscriptions;
    private BComponentSpace space;
    private BComponentEventMask mask;
    static /* synthetic */ Class class$javax$baja$sys$Type;

    public final synchronized boolean isSubscribed(Type type) {
        return this.subscriptions.contains((Object)type);
    }

    public final synchronized boolean isSubscribed(Type[] typeArray) {
        int n = 0;
        while (n < typeArray.length) {
            if (!this.isSubscribed(typeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    public final synchronized Type[] getSubscriptions() {
        Type[] typeArray = (Type[])this.subscriptions.array();
        Type[] typeArray2 = new Type[this.subscriptions.size()];
        System.arraycopy(typeArray, 0, typeArray2, 0, this.subscriptions.size());
        return typeArray2;
    }

    public final synchronized void subscribe(Type type, Context context) {
        if (!type.is(BComponent.TYPE)) {
            throw new InvalidParameterException(type + " is not a BComponent type");
        }
        this.subscribe(new Type[]{type}, context);
    }

    public final synchronized void subscribe(Type[] typeArray, Context context) {
        if (typeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < typeArray.length) {
            if (!typeArray[n].is(BComponent.TYPE)) {
                throw new InvalidParameterException(typeArray[n] + " is not a BComponent type");
            }
            ++n;
        }
        this.updateSpaceSubscription(typeArray, true);
        n = 0;
        while (n < typeArray.length) {
            if (this.subscriptions.contains((Object)typeArray[n])) {
                return;
            }
            this.subscriptions.add((Object)typeArray[n]);
            try {
                this.subscribed(typeArray[n], context);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public final synchronized void unsubscribe(Type type) {
        this.unsubscribe(type, null);
    }

    public final synchronized void unsubscribe(Type type, Context context) {
        this.unsubscribe(new Type[]{type}, context);
    }

    public final synchronized void unsubscribe(Type[] typeArray, Context context) {
        if (typeArray.length == 0) {
            return;
        }
        this.updateSpaceSubscription(typeArray, false);
        int n = 0;
        while (n < typeArray.length) {
            this.subscriptions.remove((Object)typeArray[n]);
            try {
                this.unsubscribed(typeArray[n], context);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public final synchronized void unsubscribeAll() {
        this.unsubscribe(this.getSubscriptions(), null);
    }

    private final void updateSpaceSubscription(Type[] typeArray, boolean bl) {
        if (this.space != null) {
            if (bl) {
                this.space.subscribe(typeArray, this);
            } else {
                this.space.unsubscribe(typeArray, this);
            }
        }
    }

    public final BComponentEventMask getMask() {
        return this.mask;
    }

    public final synchronized void setMask(BComponentEventMask bComponentEventMask) {
        this.mask = bComponentEventMask;
        if (this.space != null && this.subscriptions.size() > 0) {
            this.space.updateSubscription(this.getSubscriptions(), this);
        }
    }

    public abstract void event(BComponentEvent var1);

    protected void subscribed(Type type, Context context) {
    }

    protected void unsubscribed(Type type, Context context) {
    }

    public void spy(SpyWriter spyWriter) {
        spyWriter.startTable(true);
        Type[] typeArray = this.getSubscriptions();
        spyWriter.trTitle("Subscriptions (" + typeArray.length + " Types)", 1);
        int n = 0;
        while (n < typeArray.length) {
            spyWriter.tr(typeArray[n].getTypeSpec().toString());
            ++n;
        }
        spyWriter.endTable();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$javax$baja$sys$Type;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Type = TypeSubscriber.class("[Ljavax.baja.sys.Type;", false);
        }
        this.subscriptions = new Array(clazz);
        this.mask = BComponentEventMask.SELF_EVENTS;
    }

    public TypeSubscriber(BComponentSpace bComponentSpace) {
        this.this();
        this.space = bComponentSpace;
    }
}

