/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

public class BasicContext
implements Context {
    protected Context base;
    protected BUser user;
    protected BFacets facets;
    protected String lang;

    private final void invariant() {
        if (this.facets == null) {
            this.facets = BFacets.NULL;
        }
        if (this.lang == null) {
            this.lang = this.user != null && !this.user.getLanguage().equals("") ? this.user.getLanguage() : Sys.getLanguage();
        }
    }

    public BUser getUser() {
        return this.user;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public BObject getFacet(String string) {
        return this.facets.getFacet(string);
    }

    public String getLanguage() {
        return this.lang;
    }

    public Context getBase() {
        return this.base;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BasicContext[facets=");
        stringBuffer.append(this.facets);
        stringBuffer.append(" lang=");
        stringBuffer.append(this.lang);
        stringBuffer.append(" user=");
        stringBuffer.append(this.user);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public BasicContext(BUser bUser, BFacets bFacets) {
        this.user = bUser;
        this.facets = BFacets.make(bUser.getFacets(), bFacets);
        this.invariant();
    }

    public BasicContext(BUser bUser) {
        this.user = bUser;
        this.facets = bUser != null ? bUser.getFacets() : BFacets.NULL;
        this.invariant();
    }

    public BasicContext(BUser bUser, String string) {
        this.user = bUser;
        this.facets = bUser != null ? bUser.getFacets() : BFacets.NULL;
        this.lang = string;
        this.invariant();
    }

    public BasicContext(Context context) {
        if (context != null) {
            this.base = context;
            this.user = context.getUser();
            this.facets = context.getFacets();
            this.lang = context.getLanguage();
        }
        this.invariant();
    }

    public BasicContext(Context context, BFacets bFacets) {
        if (context != null) {
            this.base = context;
            this.user = context.getUser();
            this.facets = context.getFacets();
            this.lang = context.getLanguage();
        }
        this.facets = BFacets.make(this.facets, bFacets);
        this.invariant();
    }

    public BasicContext() {
        this.invariant();
    }
}

