/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BRelTime
extends BSimple
implements BIDataValue,
BIComparable {
    public static final BRelTime DEFAULT = new BRelTime(0L);
    public static final Type TYPE;
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final BRelTime SECOND;
    public static final BRelTime MINUTE;
    public static final BRelTime HOUR;
    public static final BRelTime DAY;
    public static final String SHOW_DAYS = "showDays";
    public static final String SHOW_HOURS = "showHours";
    public static final String SHOW_MINUTES = "showMinutes";
    private long ms;
    static /* synthetic */ Class class$javax$baja$sys$BRelTime;

    public static final BRelTime make(long l) {
        if (l == 0L) {
            return DEFAULT;
        }
        return (BRelTime)new BRelTime(l).intern();
    }

    public static final BRelTime make(String string) throws IOException {
        return (BRelTime)DEFAULT.decodeFromString(string);
    }

    public static final BRelTime makeDays(int n) {
        return BRelTime.make(86400000L * (long)n);
    }

    public static final BRelTime makeHours(int n) {
        return BRelTime.make(3600000L * (long)n);
    }

    public static final BRelTime makeMinutes(int n) {
        return BRelTime.make(60000L * (long)n);
    }

    public static final BRelTime makeSeconds(int n) {
        return BRelTime.make(1000L * (long)n);
    }

    public final long getMillis() {
        return this.ms;
    }

    public final int getSeconds() {
        return (int)(this.ms / 1000L);
    }

    public final int getMinutes() {
        return (int)(this.ms / 60000L);
    }

    public final int getHours() {
        return (int)(this.ms / 3600000L);
    }

    public final int getDays() {
        return (int)(this.ms / 86400000L);
    }

    public final long getMillisPart() {
        return this.ms % 1000L;
    }

    public final int getSecondsPart() {
        return (int)((this.ms - this.getMillisPart()) % 60000L / 1000L);
    }

    public final int getMinutesPart() {
        return (int)((this.ms - 1000L * (long)this.getSecondsPart()) % 3600000L / 60000L);
    }

    public final int getHoursPart() {
        return (int)((this.ms - 60000L * (long)this.getMinutesPart()) % 86400000L / 3600000L);
    }

    public final int getDaysPart() {
        return (int)((this.ms - 3600000L * (long)this.getHoursPart()) / 86400000L);
    }

    public final BRelTime abs() {
        if (this.ms >= 0L) {
            return this;
        }
        return BRelTime.make(Math.abs(this.ms));
    }

    public final int hashCode() {
        return (int)(this.ms ^ this.ms >> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof BRelTime) {
            boolean bl = false;
            if (((BRelTime)object).ms == this.ms) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        BRelTime bRelTime = (BRelTime)object;
        long l = this.getMillis() - bRelTime.getMillis();
        if (l == 0L) {
            return 0;
        }
        if (l < 0L) {
            return -1;
        }
        return 1;
    }

    public static final String toString(long l) {
        return BRelTime.toString(l, null);
    }

    public static final String toString(long l, Context context) {
        long l2;
        Comparable<StringBuffer> comparable;
        BBoolean bBoolean;
        BBoolean bBoolean2;
        BBoolean bBoolean3;
        BBoolean bBoolean4;
        boolean bl = true;
        if (context != null && (bBoolean4 = (BBoolean)context.getFacet("showMilliseconds")) != null) {
            bl = bBoolean4.getBoolean();
        }
        boolean bl2 = true;
        if (context != null && (bBoolean3 = (BBoolean)context.getFacet("showSeconds")) != null) {
            bl2 = bBoolean3.getBoolean();
        }
        boolean bl3 = true;
        if (context != null && (bBoolean2 = (BBoolean)context.getFacet(SHOW_MINUTES)) != null) {
            bl3 = bBoolean2.getBoolean();
        }
        boolean bl4 = true;
        if (context != null && (bBoolean = (BBoolean)context.getFacet(SHOW_HOURS)) != null) {
            bl4 = bBoolean.getBoolean();
        }
        boolean bl5 = true;
        if (context != null && (comparable = (BBoolean)context.getFacet(SHOW_DAYS)) != null) {
            bl5 = ((BBoolean)comparable).getBoolean();
        }
        comparable = new StringBuffer();
        if (l < 0L) {
            ((StringBuffer)comparable).append('-');
            l = -l;
        }
        if (l < 1000L) {
            if (bl2) {
                if (bl) {
                    return ((StringBuffer)comparable).append(l).append("ms").toString();
                }
                return "0 sec";
            }
            if (bl3) {
                return "0 minutes";
            }
            if (bl4) {
                return "0 hours";
            }
            if (bl5) {
                return "0 days";
            }
        }
        if (l >= 86400000L && bl5) {
            l2 = l / 86400000L;
            l %= 86400000L;
            ((StringBuffer)comparable).append(l2).append(l2 == 1L ? "day " : "days ");
        }
        if (l >= 3600000L && bl4) {
            l2 = l / 3600000L;
            l %= 3600000L;
            ((StringBuffer)comparable).append(l2).append(l2 == 1L ? "hour " : "hours ");
        }
        if (l >= 60000L && bl3) {
            l2 = l / 60000L;
            l %= 60000L;
            ((StringBuffer)comparable).append(l2).append(l2 == 1L ? "min " : "mins ");
        }
        if (l > 0L && bl2) {
            boolean bl6;
            l2 = l / 1000L;
            l %= 1000L;
            ((StringBuffer)comparable).append(l2);
            boolean bl7 = false;
            if (l2 != 1L) {
                bl7 = bl6 = true;
            }
            if (bl && l > 0L) {
                ((StringBuffer)comparable).append('.');
                if (l < 10L) {
                    ((StringBuffer)comparable).append("00");
                } else if (l < 100L) {
                    ((StringBuffer)comparable).append('0');
                }
                ((StringBuffer)comparable).append(l);
                boolean bl8 = false;
                if (bl6 || l != 0L) {
                    bl8 = true;
                }
                bl6 = bl8;
            }
            ((StringBuffer)comparable).append(bl6 ? "secs" : "sec");
        }
        if (((StringBuffer)comparable).length() > 0 && ((StringBuffer)comparable).charAt(((StringBuffer)comparable).length() - 1) == ' ') {
            ((StringBuffer)comparable).setLength(((StringBuffer)comparable).length() - 1);
        }
        return ((StringBuffer)comparable).toString();
    }

    public final String toString(Context context) {
        return BRelTime.toString(this.ms, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.ms);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BRelTime.make(dataInput.readLong());
    }

    public final String encodeToString() {
        return String.valueOf(this.ms);
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.equals("0")) {
            return DEFAULT;
        }
        return (BRelTime)new BRelTime(new Long(string)).intern();
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 116) {
            if (Math.abs(this.ms) > 1000L && this.getMillisPart() != 0L) {
                return Boolean.TRUE;
            }
            return null;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BRelTime(long l) {
        this.ms = l;
    }

    static {
        Class clazz = class$javax$baja$sys$BRelTime;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BRelTime = BRelTime.class("[Ljavax.baja.sys.BRelTime;", false);
        }
        TYPE = Sys.loadType(clazz);
        SECOND = BRelTime.make(1000L);
        MINUTE = BRelTime.make(60000L);
        HOUR = BRelTime.make(3600000L);
        DAY = BRelTime.make(86400000L);
    }
}

