/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLong
extends BNumber {
    private static final BLong ZERO = new BLong(0L);
    public static final BLong MIN = new BLong(Long.MIN_VALUE);
    public static final BLong MAX = new BLong(Long.MAX_VALUE);
    public static final BLong DEFAULT = ZERO;
    public static final Type TYPE;
    private static final DecimalFormat format;
    private long value;
    static /* synthetic */ Class class$javax$baja$sys$BLong;

    public static final BLong make(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l == Long.MIN_VALUE) {
            return MIN;
        }
        if (l == Long.MAX_VALUE) {
            return MAX;
        }
        return new BLong(l);
    }

    public static final BLong make(String string) {
        return BLong.make(BLong.decode(string));
    }

    public final long getLong() {
        return this.value;
    }

    public final int getInt() {
        return (int)this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final double getDouble() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof BLong) {
            boolean bl = false;
            if (((BLong)object).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        long l = this.value;
        long l2 = ((BNumber)object).getLong();
        if (l == l2) {
            return 0;
        }
        if (l < l2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BLong.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BLong.make(dataInput.readLong());
    }

    public final String encodeToString() throws IOException {
        return BLong.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BLong.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid long: " + string);
        }
    }

    public static final long decode(String string) {
        if (string.equals("min")) {
            return Long.MIN_VALUE;
        }
        if (string.equals("max")) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(string);
    }

    public static final String encode(long l) {
        if (l == Long.MIN_VALUE) {
            return "min";
        }
        if (l == Long.MAX_VALUE) {
            return "max";
        }
        return String.valueOf(l);
    }

    public static final String toString(long l, Context context) {
        BUnit bUnit;
        Object object;
        int n = 10;
        BUnit bUnit2 = null;
        int n2 = Nre.unitConversion;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (context != null) {
            object = (BNumber)context.getFacet("radix");
            if (object != null) {
                n = ((BNumber)object).getInt();
            }
            if ((bUnit2 = (BUnit)context.getFacet("units")) != null && bUnit2.isNull()) {
                bUnit2 = null;
            }
            n2 = context.getFacets().geti("unitConversion", n2);
            bl = context.getFacets().getb("showUnits", bl);
            bl2 = context.getFacets().getb("showSeparators", bl2);
            bl3 = context.getFacets().getb("forceSign", bl3);
        }
        if (n2 != 0 && bUnit2 != null && (bUnit = ((BUnitConversion)(object = BUnitConversion.make(n2))).getDesiredUnit(bUnit2)) != bUnit2) {
            l = (long)bUnit2.convertTo(bUnit, l);
            bUnit2 = bUnit;
        }
        Object object2 = object = bl3 && l > 0L ? "+" : "";
        object = l == Long.MIN_VALUE ? "min" : (l == Long.MAX_VALUE ? "max" : (n == 2 ? Long.toBinaryString(l) : (n == 8 ? Long.toOctalString(l) : (n == 16 ? Long.toHexString(l) : (n != 10 ? Long.toString(l, n) : (bl2 ? (String)object + format.format(l) : (String)object + Long.toString(l)))))));
        if (bl && bUnit2 != null) {
            object = (String)object + ' ' + bUnit2.getSymbol();
        }
        return object;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLong(long l) {
        this.value = l;
    }

    static {
        Class clazz = class$javax$baja$sys$BLong;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BLong = BLong.class("[Ljavax.baja.sys.BLong;", false);
        }
        TYPE = Sys.loadType(clazz);
        format = new DecimalFormat("#,##0");
    }
}

