/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInteger
extends BNumber {
    private static final BInteger ZERO = new BInteger(0);
    private static final BInteger ONE = new BInteger(1);
    private static final BInteger TWO = new BInteger(2);
    private static final BInteger THREE = new BInteger(3);
    private static final BInteger FOUR = new BInteger(4);
    private static final BInteger FIVE = new BInteger(5);
    public static final BInteger MIN = new BInteger(Integer.MIN_VALUE);
    public static final BInteger MAX = new BInteger(Integer.MAX_VALUE);
    public static final BInteger DEFAULT = ZERO;
    public static final Type TYPE;
    private static final DecimalFormat format;
    private int value;
    static /* synthetic */ Class class$javax$baja$sys$BInteger;

    public static final BInteger make(int n) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case -2147483648: {
                return MIN;
            }
            case 0x7FFFFFFF: {
                return MAX;
            }
        }
        return new BInteger(n);
    }

    public static final BInteger make(String string) {
        return BInteger.make(BInteger.decode(string));
    }

    public final int getInt() {
        return this.value;
    }

    public final long getLong() {
        return this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final double getDouble() {
        return this.value;
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object object) {
        if (object instanceof BInteger) {
            boolean bl = false;
            if (((BInteger)object).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        int n = this.value;
        int n2 = ((BNumber)object).getInt();
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BInteger.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BInteger.make(dataInput.readInt());
    }

    public final String encodeToString() throws IOException {
        return BInteger.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BInteger.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid integer: " + string);
        }
    }

    public static final int decode(String string) {
        if (string.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (string.equals("max")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(string);
    }

    public static final String encode(int n) {
        if (n == Integer.MIN_VALUE) {
            return "min";
        }
        if (n == Integer.MAX_VALUE) {
            return "max";
        }
        return String.valueOf(n);
    }

    public static final String toString(int n, Context context) {
        BUnit bUnit;
        Object object;
        int n2 = 10;
        BUnit bUnit2 = null;
        int n3 = Nre.unitConversion;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (context != null) {
            object = (BNumber)context.getFacet("radix");
            if (object != null) {
                n2 = ((BNumber)object).getInt();
            }
            if ((bUnit2 = (BUnit)context.getFacet("units")) != null && bUnit2.isNull()) {
                bUnit2 = null;
            }
            n3 = context.getFacets().geti("unitConversion", n3);
            bl = context.getFacets().getb("showUnits", bl);
            bl2 = context.getFacets().getb("showSeparators", bl2);
            bl3 = context.getFacets().getb("forceSign", bl3);
        }
        if (n3 != 0 && bUnit2 != null && (bUnit = ((BUnitConversion)(object = BUnitConversion.make(n3))).getDesiredUnit(bUnit2)) != bUnit2) {
            n = (int)bUnit2.convertTo(bUnit, n);
            bUnit2 = bUnit;
        }
        Object object2 = object = bl3 && n > 0 ? "+" : "";
        if (bl && bUnit2 != null && bUnit2.getIsPrefix()) {
            object = (String)object + bUnit2.getSymbol() + ' ';
        }
        object = n == Integer.MIN_VALUE ? "min" : (n == Integer.MAX_VALUE ? "max" : (n2 == 2 ? Integer.toBinaryString(n) : (n2 == 8 ? Integer.toOctalString(n) : (n2 == 16 ? Integer.toHexString(n) : (n2 != 10 ? Integer.toString(n, n2) : (bl2 ? (String)object + format.format(n) : (String)object + Integer.toString(n)))))));
        if (bl && bUnit2 != null && !bUnit2.getIsPrefix()) {
            object = (String)object + ' ' + bUnit2.getSymbol();
        }
        return object;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BInteger(int n) {
        this.value = n;
    }

    static {
        Class clazz = class$javax$baja$sys$BInteger;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BInteger = BInteger.class("[Ljavax.baja.sys.BInteger;", false);
        }
        TYPE = Sys.loadType(clazz);
        format = new DecimalFormat("#,##0");
    }
}

