/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFloat
extends BNumber {
    public static final BFloat POSITIVE_INFINITY = new BFloat(Float.POSITIVE_INFINITY);
    public static final BFloat NEGATIVE_INFINITY = new BFloat(Float.NEGATIVE_INFINITY);
    public static final BFloat NaN = new BFloat(Float.NaN);
    public static final BFloat DEFAULT = new BFloat(0.0f);
    public static final Type TYPE;
    private float value;
    static /* synthetic */ Class class$javax$baja$sys$BFloat;

    public static final BFloat make(float f) {
        if (f == 0.0f) {
            return DEFAULT;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (f == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Float.isNaN(f)) {
            return NaN;
        }
        return new BFloat(f);
    }

    public static final BFloat make(String string) {
        return BFloat.make(BFloat.decode(string));
    }

    public final int getInt() {
        return (int)this.value;
    }

    public final long getLong() {
        return (long)this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final double getDouble() {
        return this.value;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public final boolean equals(Object object) {
        if (object instanceof BFloat) {
            float f = ((BFloat)object).value;
            if (f == this.value) {
                return true;
            }
            if (Float.isNaN(f) && Float.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean equals(float f, float f2) {
        if (f == f2) {
            return true;
        }
        return Float.isNaN(f) && Float.isNaN(f2);
    }

    public final int compareTo(Object object) {
        float f = this.value;
        float f2 = ((BNumber)object).getFloat();
        if (f == f2) {
            return 0;
        }
        if (Float.isNaN(f) && Float.isNaN(f2)) {
            return 0;
        }
        if (f < f2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BFloat.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BFloat.make(dataInput.readFloat());
    }

    public final String encodeToString() throws IOException {
        return BFloat.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BFloat.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid float: " + string);
        }
    }

    public static final String encode(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Float.isNaN(f)) {
            return "nan";
        }
        return String.valueOf(f);
    }

    public static final float decode(String string) {
        if (string.equals("+inf")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string.equals("-inf")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (string.equals("nan")) {
            return Float.NaN;
        }
        return Float.parseFloat(string);
    }

    public static final String toString(float f, Context context) {
        return BDouble.toString(f, context);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BFloat(float f) {
        this.value = f;
    }

    static {
        Class clazz = class$javax$baja$sys$BFloat;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BFloat = BFloat.class("[Ljavax.baja.sys.BFloat;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

