/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFacets
extends BSimple
implements Context {
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String TRUE_TEXT = "trueText";
    public static final String FALSE_TEXT = "falseText";
    public static final String PRECISION = "precision";
    public static final String UNITS = "units";
    public static final String RADIX = "radix";
    public static final String RANGE = "range";
    public static final String SHOW_DATE = "showDate";
    public static final String SHOW_TIME = "showTime";
    public static final String SHOW_SECONDS = "showSeconds";
    public static final String SHOW_MILLISECONDS = "showMilliseconds";
    public static final String SHOW_TIME_ZONE = "showTimeZone";
    public static final String TIME_ZONE = "TimeZone";
    public static final String MULTI_LINE = "multiLine";
    public static final String FIELD_WIDTH = "fieldWidth";
    public static final String ALLOW_NULL = "allowNull";
    public static final String ORD_RELATIVIZE = "ordRelativize";
    public static final String FIELD_EDITOR = "fieldEditor";
    public static final String INPLACE_EDITOR = "inplaceEditor";
    public static final String CELL_EDITOR = "cellEditor";
    public static final String TARGET_TYPE = "targetType";
    public static final String UNIT_CONVERSION = "unitConversion";
    public static final String REALMS = "realms";
    public static final String SHOW_UNITS = "showUnits";
    public static final String SHOW_SEPARATORS = "showSeparators";
    public static final String FORCE_SIGN = "forceSign";
    public static final String MAX_OVERRIDE_DURATION = "maxOverrideDuration";
    private static final String[] BOOLEAN_KEYS;
    private static final BString TRUE_STRING;
    private static final BString FALSE_STRING;
    private static final String[] NUMERIC_KEYS;
    private static final String[] INT_KEYS;
    private static final String[] ENUM_KEYS;
    public static final BFacets NULL;
    public static final BFacets DEFAULT;
    public static final Type TYPE;
    private static final boolean internDisabled;
    private static final String defaultExcludedFacetKeys = "sourceName;historyId;lastTimestamp;firstTimestamp;startTime;endTime;foxSessionId;historyCursorPreRec;historyCursorPostRec";
    private static final Array noInternFacetKeys;
    private String[] keys;
    private BIDataValue[] values;
    private String encodeStr;
    private Object pickle;
    static /* synthetic */ Class class$javax$baja$sys$BFacets;
    static /* synthetic */ Class class$java$lang$String;

    public static final BFacets makeBoolean(BString bString, BString bString2) {
        return BFacets.factory(BOOLEAN_KEYS, new BIDataValue[]{bString, bString2});
    }

    public static final BFacets makeBoolean(String string, String string2) {
        return BFacets.makeBoolean(BString.make(string), BString.make(string2));
    }

    public static final BFacets makeBoolean() {
        return BFacets.makeBoolean(TRUE_STRING, FALSE_STRING);
    }

    public static final BFacets makeNumeric(BUnit bUnit, BInteger bInteger, BNumber bNumber, BNumber bNumber2) {
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        return BFacets.factory(NUMERIC_KEYS, new BIDataValue[]{bUnit, bInteger, bNumber, bNumber2});
    }

    public static final BFacets makeNumeric() {
        return BFacets.makeNumeric(null, BInteger.make(1), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static final BFacets makeNumeric(int n) {
        return BFacets.makeNumeric(null, BInteger.make(n), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static final BFacets makeNumeric(BUnit bUnit, int n) {
        return BFacets.makeNumeric(bUnit, BInteger.make(n), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static final BFacets makeNumeric(BUnit bUnit, BNumber bNumber, BNumber bNumber2) {
        return BFacets.makeNumeric(bUnit, BInteger.make(1), bNumber, bNumber2);
    }

    public static final BFacets makeNumeric(BUnit bUnit, int n, double d, double d2) {
        return BFacets.makeNumeric(bUnit, BInteger.make(n), BDouble.make(d), BDouble.make(d2));
    }

    public static final BFacets makeInt(BUnit bUnit, int n, int n2, int n3) {
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        return BFacets.factory(INT_KEYS, new BIDataValue[]{bUnit, BInteger.make(n), BInteger.make(n2), BInteger.make(n3)});
    }

    public static final BFacets makeInt(BUnit bUnit, int n, int n2) {
        return BFacets.makeInt(bUnit, n, n2, 10);
    }

    public static final BFacets makeInt(BUnit bUnit) {
        return BFacets.makeInt(bUnit, Integer.MIN_VALUE, Integer.MAX_VALUE, 10);
    }

    public static final BFacets makeInt(int n, int n2) {
        return BFacets.makeInt(null, n, n2, 10);
    }

    public static final BFacets makeInt() {
        return BFacets.makeInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 10);
    }

    public static final BFacets makeEnum(BEnumRange bEnumRange) {
        if (bEnumRange == null) {
            bEnumRange = BEnumRange.NULL;
        }
        if (bEnumRange.asFacets == null) {
            bEnumRange.asFacets = BFacets.factory(ENUM_KEYS, new BIDataValue[]{bEnumRange});
        }
        return bEnumRange.asFacets;
    }

    public static final BFacets makeEnum() {
        return BFacets.makeEnum(null);
    }

    public static final BFacets make(String string, boolean bl) {
        return BFacets.make(string, BBoolean.make(bl));
    }

    public static final BFacets make(String string, int n) {
        return BFacets.make(string, BInteger.make(n));
    }

    public static final BFacets make(String string, long l) {
        return BFacets.make(string, BLong.make(l));
    }

    public static final BFacets make(String string, String string2) {
        return BFacets.make(string, BString.make(string2));
    }

    public static final BFacets make(String string, BIDataValue bIDataValue) {
        if (string.equals(RANGE) && bIDataValue instanceof BEnumRange) {
            return BFacets.makeEnum((BEnumRange)bIDataValue);
        }
        SlotPath.verifyValidName(string);
        BFacets.verifyValue(bIDataValue);
        return BFacets.factory(new String[]{string}, new BIDataValue[]{bIDataValue});
    }

    public static final BFacets make(String string, BIDataValue bIDataValue, String string2, BIDataValue bIDataValue2) {
        SlotPath.verifyValidName(string);
        BFacets.verifyValue(bIDataValue);
        SlotPath.verifyValidName(string2);
        BFacets.verifyValue(bIDataValue2);
        return BFacets.factory(new String[]{string, string2}, new BIDataValue[]{bIDataValue, bIDataValue2});
    }

    public static final BFacets make(String string, BIDataValue bIDataValue, String string2, BIDataValue bIDataValue2, String string3, BIDataValue bIDataValue3) {
        SlotPath.verifyValidName(string);
        BFacets.verifyValue(bIDataValue);
        SlotPath.verifyValidName(string2);
        BFacets.verifyValue(bIDataValue2);
        SlotPath.verifyValidName(string3);
        BFacets.verifyValue(bIDataValue3);
        return BFacets.factory(new String[]{string, string2, string3}, new BIDataValue[]{bIDataValue, bIDataValue2, bIDataValue3});
    }

    public static final BFacets make(String string) throws IOException {
        return (BFacets)DEFAULT.decodeFromString(string);
    }

    public static final BFacets tryMake(String string) {
        try {
            return BFacets.make(string);
        }
        catch (IOException iOException) {
            return NULL;
        }
    }

    public static final BFacets make(Map map) {
        if (map.size() == 0) {
            return NULL;
        }
        String[] stringArray = new String[map.size()];
        BIDataValue[] bIDataValueArray = new BIDataValue[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SlotPath.verifyValidName(string);
            BIDataValue bIDataValue = (BIDataValue)map.get(string);
            BFacets.verifyValue(bIDataValue);
            stringArray[n] = string;
            bIDataValueArray[n] = bIDataValue;
            ++n;
        }
        return BFacets.factory(stringArray, bIDataValueArray);
    }

    public static final BFacets make(String[] stringArray, BIDataValue[] bIDataValueArray) {
        if (stringArray.length != bIDataValueArray.length) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < bIDataValueArray.length) {
            SlotPath.verifyValidName(stringArray[n]);
            BFacets.verifyValue(bIDataValueArray[n]);
            ++n;
        }
        return BFacets.factory((String[])stringArray.clone(), (BIDataValue[])bIDataValueArray.clone());
    }

    public static final BFacets make(BFacets bFacets, String string, BIDataValue bIDataValue) {
        SlotPath.verifyValidName(string);
        BFacets.verifyValue(bIDataValue);
        int n = bFacets.indexOf(string);
        if (n >= 0) {
            if (bFacets.values[n].equals(bIDataValue)) {
                return bFacets;
            }
            BIDataValue[] bIDataValueArray = (BIDataValue[])bFacets.values.clone();
            bIDataValueArray[n] = bIDataValue;
            return BFacets.factory(bFacets.keys, bIDataValueArray);
        }
        int n2 = bFacets.keys.length;
        String[] stringArray = new String[n2 + 1];
        BIDataValue[] bIDataValueArray = new BIDataValue[n2 + 1];
        System.arraycopy(bFacets.keys, 0, stringArray, 0, n2);
        System.arraycopy(bFacets.values, 0, bIDataValueArray, 0, n2);
        stringArray[n2] = string;
        bIDataValueArray[n2] = bIDataValue;
        return BFacets.factory(stringArray, bIDataValueArray);
    }

    public static final BFacets makeRemove(BFacets bFacets, String string) {
        int n = bFacets.indexOf(string);
        if (n < 0) {
            return bFacets;
        }
        if (bFacets.keys.length == 1) {
            return NULL;
        }
        int n2 = bFacets.keys.length;
        String[] stringArray = new String[n2 - 1];
        System.arraycopy(bFacets.keys, 0, stringArray, 0, n);
        System.arraycopy(bFacets.keys, n + 1, stringArray, n, n2 - n - 1);
        BIDataValue[] bIDataValueArray = new BIDataValue[n2 - 1];
        System.arraycopy(bFacets.values, 0, bIDataValueArray, 0, n);
        System.arraycopy(bFacets.values, n + 1, bIDataValueArray, n, n2 - n - 1);
        return BFacets.factory(stringArray, bIDataValueArray);
    }

    public static final BFacets makeRemove(BFacets bFacets, String[] stringArray) {
        if (bFacets.keys.length == 0) {
            return NULL;
        }
        IntHashMap intHashMap = new IntHashMap();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = bFacets.indexOf(stringArray[n]);
            if (n2 >= 0) {
                intHashMap.put(n2, (Object)stringArray[n]);
            }
            ++n;
        }
        if (intHashMap.isEmpty()) {
            return bFacets;
        }
        n = bFacets.keys.length;
        String[] stringArray2 = new String[n - intHashMap.size()];
        BIDataValue[] bIDataValueArray = new BIDataValue[n - intHashMap.size()];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (intHashMap.get(n4) == null) {
                stringArray2[n3] = bFacets.keys[n4];
                bIDataValueArray[n3] = bFacets.values[n4];
                ++n3;
            }
            ++n4;
        }
        return BFacets.factory(stringArray2, bIDataValueArray);
    }

    public static final BFacets make(BFacets bFacets, BFacets bFacets2) {
        if (bFacets == null || bFacets.isNull()) {
            return bFacets2 == null ? NULL : bFacets2;
        }
        if (bFacets2 == null || bFacets2.isNull()) {
            return bFacets == null ? NULL : bFacets;
        }
        int n = bFacets.keys.length + bFacets2.keys.length;
        String[] stringArray = new String[n];
        BIDataValue[] bIDataValueArray = new BIDataValue[n];
        System.arraycopy(bFacets.keys, 0, stringArray, 0, bFacets.keys.length);
        System.arraycopy(bFacets.values, 0, bIDataValueArray, 0, bFacets.values.length);
        int n2 = bFacets.keys.length;
        int n3 = 0;
        while (n3 < bFacets2.keys.length) {
            int n4 = bFacets.indexOf(bFacets2.keys[n3]);
            if (n4 == -1) {
                stringArray[n2] = bFacets2.keys[n3];
                bIDataValueArray[n2++] = bFacets2.values[n3];
            } else {
                bIDataValueArray[n4] = bFacets2.values[n3];
            }
            ++n3;
        }
        if (n2 != n) {
            String[] stringArray2 = new String[n2];
            BIDataValue[] bIDataValueArray2 = new BIDataValue[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            System.arraycopy(bIDataValueArray, 0, bIDataValueArray2, 0, n2);
            return BFacets.factory(stringArray2, bIDataValueArray2);
        }
        return BFacets.factory(stringArray, bIDataValueArray);
    }

    public static final BFacets make(BFacets bFacets) {
        if (bFacets == null) {
            return NULL;
        }
        return bFacets;
    }

    public static final BFacets makePickle(BFacets bFacets, Object object) {
        BFacets bFacets2 = new BFacets(bFacets.keys, bFacets.values, bFacets.encodeStr);
        bFacets2.pickle = object;
        return bFacets2;
    }

    private static final BFacets factory(String[] stringArray, BIDataValue[] bIDataValueArray) {
        return (BFacets)new BFacets(stringArray, bIDataValueArray, null).intern();
    }

    private static final String encode(String[] stringArray, BIDataValue[] bIDataValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            BObject bObject = (BObject)((Object)bIDataValueArray[n]);
            if (n > 0) {
                stringBuffer.append('|');
            }
            try {
                stringBuffer.append(string).append('=').append(DataUtil.marshal(bObject));
            }
            catch (Exception exception) {
                throw new BajaRuntimeException(exception);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String[] list() {
        return (String[])this.keys.clone();
    }

    private final int indexOf(String string) {
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final BObject get(String string) {
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return (BObject)((Object)this.values[n]);
            }
            ++n;
        }
        return null;
    }

    public final BObject get(String string, BObject bObject) {
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return (BObject)((Object)this.values[n]);
            }
            ++n;
        }
        return bObject;
    }

    public final boolean getb(String string, boolean bl) {
        BObject bObject = this.get(string);
        if (bObject instanceof BBoolean) {
            return ((BBoolean)bObject).getBoolean();
        }
        return bl;
    }

    public final int geti(String string, int n) {
        BObject bObject = this.get(string);
        if (bObject instanceof BNumber) {
            return ((BNumber)bObject).getInt();
        }
        if (bObject instanceof BEnum) {
            return ((BEnum)bObject).getOrdinal();
        }
        return n;
    }

    public final long getl(String string, long l) {
        BObject bObject = this.get(string);
        if (bObject instanceof BNumber) {
            return ((BNumber)bObject).getLong();
        }
        if (bObject instanceof BEnum) {
            return ((BEnum)bObject).getOrdinal();
        }
        return l;
    }

    public final float getf(String string, float f) {
        BObject bObject = this.get(string);
        if (bObject instanceof BNumber) {
            return ((BNumber)bObject).getFloat();
        }
        return f;
    }

    public final double getd(String string, double d) {
        BObject bObject = this.get(string);
        if (bObject instanceof BNumber) {
            return ((BNumber)bObject).getDouble();
        }
        return d;
    }

    public final String gets(String string, String string2) {
        BObject bObject = this.get(string);
        if (bObject == null) {
            return string2;
        }
        return bObject.toString();
    }

    public final Context getBase() {
        return null;
    }

    public final BUser getUser() {
        return null;
    }

    public final BObject getFacet(String string) {
        return this.get(string);
    }

    public final String getLanguage() {
        return Sys.getLanguage();
    }

    public final BFacets getFacets() {
        return this;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.keys.length == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BFacets)) {
            return false;
        }
        BFacets bFacets = this;
        BFacets bFacets2 = (BFacets)object;
        if (bFacets.keys.length != bFacets2.keys.length) {
            return false;
        }
        int n = 0;
        while (n < bFacets.keys.length) {
            String string = bFacets.keys[n];
            BObject bObject = bFacets.get(string);
            BObject bObject2 = bFacets2.get(string);
            if (bObject2 == null || !((Object)bObject).equals(bObject2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.keys.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.keys[n]).append('=').append(this.values[n].toString(context));
            ++n;
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        try {
            return this.encodeToString().hashCode();
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final BIDataValue toDataValue() {
        try {
            return BString.make(this.encodeToString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BString.make(this.toString());
        }
    }

    public final String encodeToString() throws IOException {
        if (this.encodeStr == null) {
            this.encodeStr = BFacets.encode(this.keys, this.values);
        }
        return this.encodeStr;
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return NULL;
        }
        try {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<BObject> arrayList2 = new ArrayList<BObject>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                int n = ((String)object).indexOf(61);
                String string2 = ((String)object).substring(0, n);
                SlotPath.verifyValidName(string2);
                BObject bObject = DataUtil.unmarshal(((String)object).substring(n + 1));
                arrayList.add(string2);
                arrayList2.add(bObject);
            }
            if (arrayList.size() == 0) {
                return NULL;
            }
            object = BFacets.factory(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new BIDataValue[arrayList2.size()]));
            return object;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    private static final void verifyValue(BIDataValue bIDataValue) {
        if (bIDataValue == null) {
            throw new NullPointerException();
        }
    }

    public final Object getPickle() {
        return this.pickle;
    }

    public final void setPickle(Object object) {
        this.pickle = object;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 116) {
            int n2 = 0;
            while (n2 < noInternFacetKeys.size()) {
                if (this.get((String)noInternFacetKeys.get(n2)) != null) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
            return null;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BFacets(String[] stringArray, BIDataValue[] bIDataValueArray, String string) {
        this.keys = stringArray;
        this.values = bIDataValueArray;
        this.encodeStr = string;
    }

    static {
        String string;
        BOOLEAN_KEYS = new String[]{TRUE_TEXT, FALSE_TEXT};
        TRUE_STRING = BString.make("true");
        FALSE_STRING = BString.make("false");
        NUMERIC_KEYS = new String[]{UNITS, PRECISION, MIN, MAX};
        INT_KEYS = new String[]{UNITS, MIN, MAX, RADIX};
        ENUM_KEYS = new String[]{RANGE};
        DEFAULT = NULL = BFacets.factory(new String[0], new BIDataValue[0]);
        Class clazz = class$javax$baja$sys$BFacets;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BFacets = BFacets.class("[Ljavax.baja.sys.BFacets;", false);
        }
        TYPE = Sys.loadType(clazz);
        internDisabled = Boolean.getBoolean("niagara.intern.disabled");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = BFacets.class("[Ljava.lang.String;", false);
        }
        noInternFacetKeys = new Array(clazz2);
        if (!internDisabled && (string = System.getProperty("niagara.intern.excludedFacetKeys", defaultExcludedFacetKeys)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    noInternFacetKeys.add((Object)stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

