/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDate
extends BSimple
implements BIDate,
BIComparable {
    public static final BDate DEFAULT;
    public static final BDate NULL;
    public static final Type TYPE;
    private final int year;
    private final BMonth month;
    private final int day;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$sys$BDate;

    public static final BDate make() {
        return BDate.make(BAbsTime.now());
    }

    public static final BDate today() {
        return BDate.make(BAbsTime.now());
    }

    public static final BDate make(BAbsTime bAbsTime) {
        return new BDate(bAbsTime.getYear(), bAbsTime.getMonth(), bAbsTime.getDay());
    }

    public static final BDate make(BAbsTime bAbsTime, BTimeZone bTimeZone) {
        BAbsTime bAbsTime2 = BAbsTime.make(bAbsTime, bTimeZone);
        return new BDate(bAbsTime2.getYear(), bAbsTime2.getMonth(), bAbsTime2.getDay());
    }

    public static final BDate make(int n, BMonth bMonth, int n2) {
        return new BDate(n, bMonth, n2);
    }

    public static final BDate makeDayOfYear(int n, int n2) {
        int n3 = BAbsTime.getDaysInYear(n);
        if (n2 > n3) {
            throw new IllegalArgumentException(n2 + " > " + n3);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(n2 + " < 1");
        }
        BMonth bMonth = BMonth.january;
        int n4 = BAbsTime.getDaysInMonth(n, bMonth);
        while (n2 > n4) {
            n2 -= n4;
            bMonth = bMonth.next();
            n4 = BAbsTime.getDaysInMonth(n, bMonth);
        }
        return BDate.make(n, bMonth, n2);
    }

    public static final BDate make(String string) throws IOException {
        return (BDate)DEFAULT.decodeFromString(string);
    }

    public final int compareTo(Object object) {
        BDate bDate = (BDate)object;
        if (this.year != bDate.year) {
            return this.year - bDate.year;
        }
        if (this.month.getMonthOfYear() != bDate.month.getMonthOfYear()) {
            return this.month.getMonthOfYear() - bDate.month.getMonthOfYear();
        }
        if (this.day != bDate.day) {
            return this.day - bDate.day;
        }
        return 0;
    }

    public final boolean isBefore(BDate bDate) {
        boolean bl = false;
        if (this.compareTo(bDate) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(BDate bDate) {
        boolean bl = false;
        if (this.compareTo(bDate) > 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            Log.getLog("sys").warning("Could not create hashCode for '" + this + "'.", exception);
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BDate) {
            BDate bDate = (BDate)object;
            boolean bl = false;
            if (this.year == bDate.year && this.month.getMonthOfYear() == bDate.month.getMonthOfYear() && this.day == bDate.day) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.year);
        dataOutput.writeInt(this.month.getMonthOfYear());
        dataOutput.writeInt(this.day);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return new BDate(dataInput.readInt(), BMonth.make(dataInput.readInt() - 1), dataInput.readInt());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.year).append('-');
        int n = this.month.getOrdinal() + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('-');
        if (this.day < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.day);
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.length() != 10) {
            throw new BajaRuntimeException("Invalid date '" + string + '\'');
        }
        char[] cArray = string.toCharArray();
        int n = (cArray[0] - 48) * 1000 + (cArray[1] - 48) * 100 + (cArray[2] - 48) * 10 + (cArray[3] - 48);
        if (cArray[4] != '-') {
            throw new BajaRuntimeException("Invalid date '" + string + '\'');
        }
        int n2 = (cArray[5] - 48) * 10 + (cArray[6] - 48);
        if (cArray[7] != '-') {
            throw new BajaRuntimeException("Invalid date '" + string + '\'');
        }
        int n3 = (cArray[8] - 48) * 10 + (cArray[9] - 48);
        return new BDate(n, BMonth.make(n2 - 1), n3);
    }

    public final boolean isNull() {
        return this.equals(NULL);
    }

    public final int getYear() {
        return this.year;
    }

    public final BMonth getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.day;
    }

    public final BWeekday getWeekday() {
        return BAbsTime.getWeekday(this.year, this.month, this.day);
    }

    public final int getDayOfYear() {
        int n = 0;
        BMonth bMonth = BMonth.january;
        while (bMonth != this.month) {
            n += BAbsTime.getDaysInMonth(this.year, bMonth);
            bMonth = bMonth.next();
        }
        return n += this.day;
    }

    public final boolean isLeapDay() {
        boolean bl = false;
        if (this.month == BMonth.february && this.day == 29) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public final BDate add(int var1_1) {
        block3: {
            if (var1_1 == 0) {
                return this;
            }
            var2_2 = this.getDayOfYear() + var1_1;
            var3_3 = this.year;
            if (var1_1 <= 0) ** GOTO lbl12
            while (var2_2 > BAbsTime.getDaysInYear(var3_3)) {
                var2_2 -= BAbsTime.getDaysInYear(var3_3);
                ++var3_3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var2_2 += BAbsTime.getDaysInYear(--var3_3);
lbl12:
                // 2 sources

                ** while (var2_2 < 1)
            }
        }
        return BDate.makeDayOfYear(var3_3, var2_2);
    }

    public final BDate subtract(int n) {
        return this.add(-n);
    }

    public final int delta(BDate bDate) {
        int n = this.compareTo(bDate);
        if (n == 0) {
            return 0;
        }
        BDate bDate2 = this;
        int n2 = 1;
        if (n > 0) {
            bDate2 = bDate;
            bDate = this;
            n2 = -1;
        }
        int n3 = bDate2.getYear();
        int n4 = bDate.getYear();
        int n5 = bDate2.getDayOfYear();
        int n6 = bDate.getDayOfYear();
        if (n3 == n4) {
            return n2 * (n6 - n5);
        }
        int n7 = 0;
        int n8 = n3 + 1;
        while (n8 < n4) {
            n7 += BAbsTime.getDaysInYear(n8);
            ++n8;
        }
        return n2 * (n7 + n6 + (BAbsTime.getDaysInYear(n3) - n5));
    }

    public final BDate nextDay() {
        return this.add(1);
    }

    public final BDate prevDay() {
        return this.add(-1);
    }

    public final BDate nextMonth() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n2 == 11) {
            n2 = 0;
            ++n;
        } else if (n3 == BAbsTime.getDaysInMonth(n, BMonth.make(n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(++n2));
        } else if (n3 > BAbsTime.getDaysInMonth(n, BMonth.make(++n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(n2));
        }
        return BDate.make(n, BMonth.make(n2), n3);
    }

    public final BDate prevMonth() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n2 == 0) {
            n2 = 11;
            --n;
        } else if (n3 == BAbsTime.getDaysInMonth(n, BMonth.make(n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(--n2));
        } else if (n3 > BAbsTime.getDaysInMonth(n, BMonth.make(--n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(n2));
        }
        return BDate.make(n, BMonth.make(n2), n3);
    }

    public final BDate nextYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return BDate.make(this.getYear() + 1, this.getMonth(), n);
    }

    public final BDate prevYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return BDate.make(this.getYear() - 1, this.getMonth(), n);
    }

    public final BDate next(BWeekday bWeekday) {
        BDate bDate = this.nextDay();
        while (bDate.getWeekday() != bWeekday) {
            bDate = bDate.nextDay();
        }
        return bDate;
    }

    public final BDate prev(BWeekday bWeekday) {
        BDate bDate = this.prevDay();
        while (bDate.getWeekday() != bWeekday) {
            bDate = bDate.prevDay();
        }
        return bDate;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BDate(int n, BMonth bMonth, int n2) {
        this.this();
        if (n2 < 1 || n2 > BAbsTime.getDaysInMonth(n, bMonth)) {
            throw new IllegalArgumentException("day '" + n2 + "' is invalid, in year '" + n + "', month '" + bMonth + "'.");
        }
        this.year = n;
        this.month = bMonth;
        this.day = n2;
    }

    static {
        NULL = DEFAULT = new BDate(1970, BMonth.january, 1);
        Class clazz = class$javax$baja$sys$BDate;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BDate = BDate.class("[Ljavax.baja.sys.BDate;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

