/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NProperty;
import java.util.HashMap;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.TypeIntrospectionException;
import javax.baja.util.BFacetsMap;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BComplex
extends BValue {
    private static CopyHints copyHintsDefault = new CopyHints();
    private static CopyHints copyHintsExact = new CopyHints();
    public static final Type TYPE;
    ComplexSlotMap slotMap;
    static /* synthetic */ Class class$javax$baja$sys$BComplex;

    public final String getName() {
        return this.slotMap.getName();
    }

    public final String getDisplayName(Context context) {
        return this.slotMap.getDisplayName(context);
    }

    public String getDisplayName(Slot slot, Context context) {
        BValue bValue;
        BFormat bFormat;
        BValue bValue2 = this.get("displayNames");
        if (bValue2 instanceof BNameMap && (bFormat = (bValue = (BNameMap)bValue2).get(slot.getName())) != null) {
            return bFormat.format(null, context);
        }
        if (slot.isDynamic() && (bValue = this.get((Property)slot)) instanceof BIMixIn) {
            return ((BIMixIn)((Object)bValue)).getDisplayNameInParent(context);
        }
        return slot.getDefaultDisplayName(context);
    }

    public final BComplex getParent() {
        return this.slotMap.getParent();
    }

    public final Property getPropertyInParent() {
        return this.slotMap.getPropertyInParent();
    }

    public final BComponent getParentComponent() {
        BComplex bComplex = this;
        while (!bComplex.isComponent()) {
            if ((bComplex = bComplex.getParent()) != null) continue;
            return null;
        }
        return bComplex.asComponent();
    }

    public final Property getPropertyInParentComponent() {
        if (this.isComponent() || this.getParent() == null) {
            return null;
        }
        BComplex bComplex = this;
        while (!bComplex.getParent().isComponent()) {
            if ((bComplex = bComplex.getParent()).getParent() != null) continue;
            return null;
        }
        return bComplex.getPropertyInParent();
    }

    public final synchronized BValue newCopy() {
        return this.slotMap.newCopy(copyHintsDefault, BComplex.copySerialNum());
    }

    public final synchronized BValue newCopy(boolean bl) {
        return this.slotMap.newCopy(bl ? copyHintsExact : copyHintsDefault, BComplex.copySerialNum());
    }

    public final synchronized BValue newCopy(CopyHints copyHints) {
        return this.slotMap.newCopy(copyHints, BComplex.copySerialNum());
    }

    public final void copyFrom(BComplex bComplex, Context context) {
        this.slotMap.copyFrom(bComplex.slotMap, context);
    }

    public final void copyFrom(BComplex bComplex) {
        this.slotMap.copyFrom(bComplex.slotMap, Context.copying);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean equivalent(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.slotMap.equivalent(((BComplex)object).slotMap);
    }

    public final void setFacets(Slot slot, BFacets bFacets) {
        this.setFacets(slot, bFacets, null);
    }

    public final void setFacets(Slot slot, BFacets bFacets, Context context) {
        if (slot.isFrozen()) {
            BComplex bComplex = this;
            BComponent bComponent = null;
            StringBuffer stringBuffer = new StringBuffer();
            while (!bComplex.isComponent()) {
                stringBuffer.insert(0, '/');
                stringBuffer.insert(0, bComplex.getName());
                bComplex = bComplex.getParent();
                if (bComplex == null) break;
            }
            if (bComplex != null) {
                bComponent = bComplex.asComponent();
            }
            if (bComponent != null && bComponent instanceof BComponent) {
                BFacetsMap bFacetsMap = (BFacetsMap)bComponent.get("slotFacets_");
                HashMap<String, BFacets> hashMap = new HashMap<String, BFacets>();
                if (bFacetsMap != null) {
                    String[] stringArray = bFacetsMap.list();
                    int n = 0;
                    while (n < stringArray.length) {
                        hashMap.put(stringArray[n], bFacetsMap.get(stringArray[n]));
                        ++n;
                    }
                }
                if (bFacets.isNull()) {
                    hashMap.remove(stringBuffer.toString() + slot.getName());
                } else {
                    hashMap.put(stringBuffer.toString() + slot.getName(), BFacets.makeRemove(bFacets, slot.getFacets().list()));
                }
                if (hashMap.size() == 0) {
                    if (bFacetsMap != null) {
                        bComponent.remove("slotFacets_", context);
                    }
                } else {
                    boolean bl = false;
                    if (bFacetsMap == null) {
                        bl = true;
                    }
                    boolean bl2 = bl;
                    bFacetsMap = BFacetsMap.make(hashMap);
                    if (bl2) {
                        bComponent.add("slotFacets_", bFacetsMap, 4, context);
                    } else {
                        bComponent.set("slotFacets_", (BValue)bFacetsMap, context);
                    }
                }
            }
        } else {
            this.slotMap.setFacets(slot, bFacets, context);
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.isFrozen()) {
            BFacets bFacets;
            BFacetsMap bFacetsMap;
            BComplex bComplex = this;
            BComponent bComponent = null;
            StringBuffer stringBuffer = new StringBuffer();
            while (!bComplex.isComponent()) {
                stringBuffer.insert(0, '/');
                stringBuffer.insert(0, bComplex.getName());
                bComplex = bComplex.getParent();
                if (bComplex == null) break;
            }
            if (bComplex != null) {
                bComponent = bComplex.asComponent();
            }
            if (bComponent != null && (bFacetsMap = (BFacetsMap)bComponent.get("slotFacets_")) != null && (bFacets = bFacetsMap.get(stringBuffer.toString() + slot.getName())) != null) {
                return BFacets.make(bFacets, slot.getFacets());
            }
        }
        return slot.getFacets();
    }

    public String propertyValueToString(Property property, Context context) {
        BFacets bFacets = this.getSlotFacets(property);
        if (context == null) {
            context = bFacets;
        } else if (!bFacets.isNull()) {
            context = new BasicContext(context, bFacets);
        }
        return this.get(property).toString(context);
    }

    public final BComplex loadSlots() {
        this.slotMap.loadSlots();
        return this;
    }

    public final Slot getSlot(String string) {
        return this.slotMap.getSlot(string);
    }

    public final Property getProperty(String string) {
        return (Property)this.slotMap.getSlot(string);
    }

    public final Action getAction(String string) {
        return (Action)this.slotMap.getSlot(string);
    }

    public final Topic getTopic(String string) {
        return (Topic)this.slotMap.getSlot(string);
    }

    public final int getSlotCount() {
        return this.slotMap.getSlotCount();
    }

    public final int getSlotCount(Class clazz) {
        int n = 0;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(clazz)) {
            ++n;
        }
        return n;
    }

    public final Slot[] getSlotsArray() {
        return this.slotMap.getSlotsArray();
    }

    public final SlotCursor getSlots() {
        return this.slotMap.getSlots();
    }

    public final Property[] getPropertiesArray() {
        return this.slotMap.getPropertiesArray();
    }

    public final Property[] getFrozenPropertiesArray() {
        return this.slotMap.getFrozenPropertiesArray();
    }

    public final Property[] getDynamicPropertiesArray() {
        return this.slotMap.getDynamicPropertiesArray();
    }

    public final SlotCursor getProperties() {
        return this.slotMap.getProperties();
    }

    public final Action[] getActionsArray() {
        return this.slotMap.getActionsArray();
    }

    public final SlotCursor getActions() {
        return this.slotMap.getActions();
    }

    public final Topic[] getTopicsArray() {
        return this.slotMap.getTopicsArray();
    }

    public final SlotCursor getTopics() {
        return this.slotMap.getTopics();
    }

    public final BValue get(Property property) {
        return this.slotMap.get(property);
    }

    public final boolean getBoolean(Property property) {
        return this.slotMap.getBoolean(property);
    }

    public final int getInt(Property property) {
        return this.slotMap.getInt(property);
    }

    public final long getLong(Property property) {
        return this.slotMap.getLong(property);
    }

    public final float getFloat(Property property) {
        return this.slotMap.getFloat(property);
    }

    public final double getDouble(Property property) {
        return this.slotMap.getDouble(property);
    }

    public final String getString(Property property) {
        return this.slotMap.getString(property);
    }

    public final BValue get(String string) {
        return this.slotMap.get(string);
    }

    public final void set(Property property, BValue bValue, Context context) {
        BValue bValue2 = this.get(property);
        ComplexSlotMap complexSlotMap = bValue2 == null ? null : bValue2.getSlotMap();
        this.slotMap.set(property, bValue2, complexSlotMap, bValue, bValue.getSlotMap(), context);
    }

    public final void set(Property property, BValue bValue) {
        this.set(property, bValue, null);
    }

    public final void setBoolean(Property property, boolean bl, Context context) {
        this.slotMap.setBoolean(property, bl, context);
    }

    public final void setInt(Property property, int n, Context context) {
        this.slotMap.setInt(property, n, context);
    }

    public final void setLong(Property property, long l, Context context) {
        this.slotMap.setLong(property, l, context);
    }

    public final void setFloat(Property property, float f, Context context) {
        this.slotMap.setFloat(property, f, context);
    }

    public final void setDouble(Property property, double d, Context context) {
        this.slotMap.setDouble(property, d, context);
    }

    public final void setString(Property property, String string, Context context) {
        this.slotMap.setString(property, string, context);
    }

    public final void setBoolean(Property property, boolean bl) {
        this.slotMap.setBoolean(property, bl, null);
    }

    public final void setInt(Property property, int n) {
        this.slotMap.setInt(property, n, null);
    }

    public final void setLong(Property property, long l) {
        this.slotMap.setLong(property, l, null);
    }

    public final void setFloat(Property property, float f) {
        this.slotMap.setFloat(property, f, null);
    }

    public final void setDouble(Property property, double d) {
        this.slotMap.setDouble(property, d, null);
    }

    public final void setString(Property property, String string) {
        this.slotMap.setString(property, string, null);
    }

    public final void set(String string, BValue bValue) {
        Property property = this.getProperty(string);
        if (property == null) {
            throw new NoSuchSlotException(string);
        }
        this.set(property, bValue);
    }

    public final void set(String string, BValue bValue, Context context) {
        Property property = this.getProperty(string);
        if (property == null) {
            throw new NoSuchSlotException("No such slot: " + string);
        }
        this.set(property, bValue, context);
    }

    public final int getFlags(Slot slot) {
        return this.slotMap.getFlags(slot);
    }

    public final void setFlags(Slot slot, int n) {
        this.slotMap.setFlags(slot, n, null);
    }

    public final void setFlags(Slot slot, int n, Context context) {
        this.slotMap.setFlags(slot, n, context);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        this.spyProperties(spyWriter);
        this.spyActions(spyWriter);
        this.spyTopics(spyWriter);
        this.spyKnobs(spyWriter);
        this.spySubscribers(spyWriter);
        this.spySpaceNode(spyWriter);
        this.spyDebug(spyWriter);
        spyWriter.endProps();
    }

    void spyProperties(SpyWriter spyWriter) {
        this.loadSlots();
        BComponent bComponent = (BComponent)this;
        BPermissions bPermissions = bComponent.getPermissions(spyWriter.getContext());
        SlotCursor slotCursor = this.getProperties();
        boolean bl = true;
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            BObject bObject = slotCursor.get();
            boolean bl2 = false;
            if (!bPermissions.hasAdminRead() && bPermissions.hasOperatorRead()) {
                if ((bObject.isSimple() || bObject.isStruct()) && Flags.isOperator(this, slotCursor.slot())) {
                    bl2 = true;
                } else if (bObject.isComponent() && ((BComponent)bObject).getPermissions(spyWriter.getContext()).hasOperatorRead()) {
                    bl2 = true;
                }
            } else if (bPermissions.hasAdminRead()) {
                bl2 = true;
            }
            if (!bl2) continue;
            if (bl) {
                spyWriter.trTitle("Properties", 2);
                bl = false;
            }
            String string = property.getName();
            this.spySlot(spyWriter, string, this.getFlags(property), bObject);
        }
    }

    void spyActions(SpyWriter spyWriter) {
        Action[] actionArray = this.getActionsArray();
        if (actionArray.length == 0) {
            return;
        }
        boolean bl = true;
        BComponent bComponent = (BComponent)this;
        BPermissions bPermissions = bComponent.getPermissions(spyWriter.getContext());
        int n = 0;
        while (n < actionArray.length) {
            if (bPermissions.hasAdminRead() || !bPermissions.hasAdminRead() && bPermissions.hasOperatorRead() && Flags.isOperator(this, actionArray[n])) {
                if (bl) {
                    spyWriter.trTitle("Actions", 2);
                    bl = false;
                }
                this.spySlot(spyWriter, actionArray[n].getName(), this.getFlags(actionArray[n]), actionArray[n]);
            }
            ++n;
        }
    }

    void spyTopics(SpyWriter spyWriter) {
        Topic[] topicArray = this.getTopicsArray();
        if (topicArray.length == 0) {
            return;
        }
        boolean bl = true;
        BComponent bComponent = (BComponent)this;
        BPermissions bPermissions = bComponent.getPermissions(spyWriter.getContext());
        int n = 0;
        while (n < topicArray.length) {
            if (bPermissions.hasAdminRead() || !bPermissions.hasAdminRead() && bPermissions.hasOperatorRead() && Flags.isOperator(this, topicArray[n])) {
                if (bl) {
                    spyWriter.trTitle("Topics", 2);
                    bl = false;
                }
                this.spySlot(spyWriter, topicArray[n].getName(), this.getFlags(topicArray[n]), topicArray[n]);
            }
            ++n;
        }
    }

    void spySlot(SpyWriter spyWriter, String string, int n, Object object) {
        Slot slot = this.getSlot(string);
        if (slot.isProperty()) {
            string = "<a href='" + spyWriter.href(SlotPath.escape(string)) + "'>" + string + "</a>";
        }
        spyWriter.w("<tr><td align='left' nowrap='true'><b>").w(string).w("</b>");
        if (n == 0) {
            spyWriter.w("{0}");
        } else {
            spyWriter.w(" {").w(Flags.encodeToString(n)).w("}");
        }
        spyWriter.w("</td><td align='left' nowrap='true'>").safe(object.toString()).w("</td></tr>\n");
    }

    void spyKnobs(SpyWriter spyWriter) {
        if (!this.isComponent()) {
            return;
        }
        Knob[] knobArray = this.asComponent().getKnobs();
        if (knobArray.length == 0) {
            return;
        }
        spyWriter.trTitle("Knobs", 2);
        int n = 0;
        while (n < knobArray.length) {
            spyWriter.prop((Object)knobArray[n].getSourceSlotName(), knobArray[n].getLink());
            ++n;
        }
    }

    void spySubscribers(SpyWriter spyWriter) {
        if (!this.isComponent()) {
            return;
        }
        Subscriber[] subscriberArray = this.asComponent().getSubscribers();
        if (subscriberArray.length == 0) {
            return;
        }
        spyWriter.trTitle("Subscribers", 2);
        int n = 0;
        while (n < subscriberArray.length) {
            spyWriter.w("<tr><td colspan='2'>").w(subscriberArray[n]).w("</td></tr>");
            ++n;
        }
    }

    void spySpaceNode(SpyWriter spyWriter) {
        if (!this.isComponent()) {
            return;
        }
        BComponent bComponent = (BComponent)this;
        spyWriter.trTitle("SpaceNode", 2);
        spyWriter.prop((Object)"isMounted", bComponent.isMounted());
        spyWriter.prop((Object)"handle", bComponent.getHandle());
        spyWriter.prop((Object)"slotPath", bComponent.getSlotPath());
        spyWriter.prop((Object)"host", bComponent.getHost());
        spyWriter.prop((Object)"session", bComponent.getSession());
        spyWriter.prop((Object)"space", bComponent.getSpace());
        spyWriter.prop((Object)"absoluteOrd", bComponent.getAbsoluteOrd());
        spyWriter.prop((Object)"ordInHost", bComponent.getOrdInHost());
        spyWriter.prop((Object)"ordInSession", bComponent.getOrdInSession());
        spyWriter.prop((Object)"ordInSpace", bComponent.getOrdInSpace());
        spyWriter.prop((Object)"handleOrd", bComponent.getHandleOrd());
        spyWriter.prop((Object)"slotPathOrd", bComponent.getSlotPathOrd());
        spyWriter.prop((Object)"navOrd", bComponent.getNavOrd());
    }

    void spyDebug(SpyWriter spyWriter) {
        spyWriter.trTitle("Debug", 2);
        spyWriter.prop((Object)"debugString", this.toDebugString());
        spyWriter.prop((Object)"type", this.getType());
        spyWriter.prop((Object)"parent", this.getParent());
        spyWriter.prop((Object)"propertyInParent", this.getPropertyInParent());
        if (this.isComponent()) {
            BComponent bComponent = (BComponent)this;
            spyWriter.prop((Object)"running", bComponent.isRunning());
            spyWriter.prop((Object)"subscribed", bComponent.isSubscribed());
            spyWriter.prop((Object)"permanentlySubscribed", bComponent.isPermanentlySubscribed());
            spyWriter.prop((Object)"knobCount", bComponent.getKnobCount());
            spyWriter.prop((Object)"permissions", bComponent.getPermissions(spyWriter.getContext()));
            spyWriter.prop((Object)"slotsLoaded", ((ComponentSlotMap)this.slotMap).isBrokerPropsLoaded());
            spyWriter.prop((Object)"categoryMask", bComponent.getCategoryMask());
            spyWriter.prop((Object)"appliedCategoryMask", bComponent.getAppliedCategoryMask());
            spyWriter.prop((Object)"deepOrCategoryMask", ((ComponentSlotMap)this.slotMap).getDeepOrCategoryMask());
        }
    }

    protected static Property newProperty(int n, BValue bValue, BFacets bFacets) {
        if (bValue == null) {
            throw new NullPointerException("Null defaultValue");
        }
        if (bFacets == null) {
            bFacets = BFacets.NULL;
        }
        return new NProperty(n, bValue, bFacets);
    }

    protected static Property newProperty(int n, boolean bl, BFacets bFacets) {
        return BComplex.newProperty(n, BBoolean.make(bl), bFacets);
    }

    protected static Property newProperty(int n, int n2, BFacets bFacets) {
        return BComplex.newProperty(n, BInteger.make(n2), bFacets);
    }

    protected static Property newProperty(int n, long l, BFacets bFacets) {
        return BComplex.newProperty(n, BLong.make(l), bFacets);
    }

    protected static Property newProperty(int n, float f, BFacets bFacets) {
        return BComplex.newProperty(n, BFloat.make(f), bFacets);
    }

    protected static Property newProperty(int n, double d, BFacets bFacets) {
        return BComplex.newProperty(n, BDouble.make(d), bFacets);
    }

    protected static Property newProperty(int n, String string, BFacets bFacets) {
        return BComplex.newProperty(n, BString.make(string), bFacets);
    }

    protected static Property newProperty(int n, BValue bValue) {
        return BComplex.newProperty(n, bValue, null);
    }

    protected static Property newProperty(int n, boolean bl) {
        return BComplex.newProperty(n, BBoolean.make(bl), null);
    }

    protected static Property newProperty(int n, int n2) {
        return BComplex.newProperty(n, BInteger.make(n2), null);
    }

    protected static Property newProperty(int n, long l) {
        return BComplex.newProperty(n, BLong.make(l), null);
    }

    protected static Property newProperty(int n, float f) {
        return BComplex.newProperty(n, BFloat.make(f), null);
    }

    protected static Property newProperty(int n, double d) {
        return BComplex.newProperty(n, BDouble.make(d), null);
    }

    protected static Property newProperty(int n, String string) {
        return BComplex.newProperty(n, BString.make(string), null);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 1) {
            return this.slotMap;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    final ComplexSlotMap getSlotMap() {
        return this.slotMap;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    BComplex() {
        ComplexType complexType = (ComplexType)this.getType();
        if (complexType.getTypeClass() != this.getClass() && !this.getClass().getName().startsWith("auto.")) {
            throw new TypeIntrospectionException(this.getClass(), "Class does override the getType() method");
        }
        this.slotMap = complexType.newSlotMap();
        this.slotMap.init(complexType, this);
    }

    static {
        BComplex.copyHintsDefault.defaultOnClone = true;
        BComplex.copyHintsExact.defaultOnClone = false;
        Class clazz = class$javax$baja$sys$BComplex;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BComplex = BComplex.class("[Ljavax.baja.sys.BComplex;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

