/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public abstract class Transaction
extends SyncBuffer
implements Context {
    private Context baseContext;

    public static Context start(BComponent bComponent, Context context) {
        BComponentSpace bComponentSpace = bComponent.getComponentSpace();
        if (bComponentSpace != null) {
            return bComponentSpace.newTransaction(context);
        }
        return context;
    }

    public static void end(BComponent bComponent, Context context) throws Exception {
        if (context instanceof Transaction) {
            Transaction transaction = (Transaction)context;
            transaction.commit(transaction.baseContext);
        }
    }

    public Context getBase() {
        return this.baseContext;
    }

    public BUser getUser() {
        return this.baseContext.getUser();
    }

    public BFacets getFacets() {
        return this.baseContext.getFacets();
    }

    public BObject getFacet(String string) {
        return this.baseContext.getFacet(string);
    }

    public String getLanguage() {
        return this.baseContext.getLanguage();
    }

    protected Transaction(BComponentSpace bComponentSpace, Context context) {
        super(bComponentSpace, false);
        if (context instanceof Transaction) {
            throw new IllegalStateException("Nested transactions not supported");
        }
        this.baseContext = context == null ? new BasicContext() : context;
    }
}

