/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.engine.NKnob;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.io.ValueDocEncoder;
import javax.baja.security.BPermissions;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class SyncEncoder
extends ValueDocEncoder {
    boolean encodeForLoad;

    public boolean isSyncEncoder() {
        return true;
    }

    protected void encodingComponent(BComponent bComponent) throws IOException {
        if (this.encodeForLoad) {
            this.encodeLoadInfo(bComponent);
            NKnob[] nKnobArray = (NKnob[])bComponent.getKnobs();
            if (nKnobArray.length > 0) {
                this.startArray("nk");
                int n = 0;
                while (n < nKnobArray.length) {
                    this.encodeKnob(nKnobArray[n]);
                    ++n;
                }
                this.endArray();
            }
        }
    }

    protected void encodingComponentStub(BComponent bComponent) throws IOException {
        this.encodeLoadInfo(bComponent);
        BValue bValue = bComponent.get("icon");
        if (bValue instanceof BIcon) {
            this.newLine().incrementIndent().indent();
            this.key("icon");
            this.encode("icon", bValue, 0);
            this.decrementIndent().indent();
        }
    }

    private final void encodeLoadInfo(BComponent bComponent) throws IOException {
        BPermissions bPermissions = this.getPermissionsFor(bComponent);
        this.key("l").start("load").attr("p", bPermissions.encodeToString()).end();
    }

    protected void encodingSyncOp(SyncOp syncOp) throws IOException {
    }

    void encodeKnob(NKnob nKnob) throws IOException {
        this.indent();
        this.start("nknob");
        this.attr("id", String.valueOf(nKnob.id));
        this.attr("ss", nKnob.getSourceSlotName());
        this.attr("to", nKnob.getTargetOrd().toString());
        this.attr("ts", nKnob.getTargetSlotName()).end().newLine();
    }

    public SyncEncoder(ValueDocEncoder.IEncoderPlugin iEncoderPlugin, Context context) throws Exception {
        super(iEncoderPlugin, context);
        this.setEncodeComments(false);
        this.setEncodeTransients(true);
    }

    public SyncEncoder(OutputStream outputStream, Context context) throws Exception {
        super(outputStream, context);
        this.setEncodeComments(false);
        this.setEncodeTransients(true);
    }
}

