/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferStrategy;
import java.util.HashMap;
import javax.baja.category.BCategoryMask;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SyncBuffer {
    static BFacets noAutoStartFacets;
    BComponentSpace space;
    OpLinkedList loads;
    OpLinkedList ops;
    boolean coalesce;
    HashMap propChanges;
    TransferListener listener;
    boolean checkForAutoStart;

    public BComponentSpace getSpace() {
        return this.space;
    }

    public boolean isCoalesced() {
        return this.coalesce;
    }

    public void encode(SyncEncoder syncEncoder) throws Exception {
        syncEncoder.start("sync").attr("ver", "1.0").endAttr().newLine();
        syncEncoder.startArray("ops");
        SyncOp[] syncOpArray = this.list();
        int n = 0;
        while (n < syncOpArray.length) {
            try {
                syncOpArray[n].encode(syncEncoder);
            }
            catch (SyncOp.SyncOpSecurityException syncOpSecurityException) {}
            ++n;
        }
        syncEncoder.endArray();
        syncEncoder.end("sync").newLine();
    }

    public void decode(SyncDecoder syncDecoder) throws Exception {
        if (this.loads.head != null || this.ops.head != null) {
            throw new IllegalStateException("Already contains changes");
        }
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        if (iElement == null) {
            syncDecoder.next();
            iElement = syncDecoder.elem();
        }
        if (iElement == null) {
            return;
        }
        if (!iElement.name().equals("sync")) {
            throw syncDecoder.err("Invalid root element " + iElement.name());
        }
        while (true) {
            int n;
            if ((n = syncDecoder.next()) == 2) {
                if (syncDecoder.elem().name().equals("sync")) break;
                throw syncDecoder.err("Expected end sync");
            }
            if (n != 1) {
                throw syncDecoder.err("Expected element start");
            }
            int n2 = syncDecoder.depth();
            ValueDocDecoder.IElement iElement2 = syncDecoder.elem();
            char c = iElement2.name().charAt(0);
            SyncOp syncOp = SyncOp.make(c);
            syncOp.decode(this, this.space, syncDecoder);
            this.add(syncOp);
            syncDecoder.skip(n2);
        }
    }

    public final void commit() throws Exception {
        this.commit(null);
    }

    protected SyncOp[] startCommit(SyncOp[] syncOpArray, Context context) {
        return syncOpArray;
    }

    protected void endCommit() throws Exception {
    }

    protected void abortCommit(Exception exception) {
    }

    public void commit(Context context) throws Exception {
        SyncOp[] syncOpArray = this.startCommit(this.list(), context);
        try {
            Context context2 = context;
            if (!this.space.isProxyComponentSpace()) {
                context2 = new BasicContext(context, noAutoStartFacets);
            }
            int n = 0;
            while (n < syncOpArray.length) {
                if (!syncOpArray[n].committed) {
                    this.commitOp(syncOpArray[n], context2);
                }
                ++n;
            }
            if (this.checkForAutoStart) {
                this.checkForAutoStart = false;
                n = 0;
                while (n < syncOpArray.length) {
                    try {
                        SyncOp syncOp = syncOpArray[n];
                        if (syncOp instanceof AddOp) {
                            this.checkAutoStart(((AddOp)syncOp).value);
                        }
                        if (syncOp instanceof SetOp) {
                            this.checkAutoStart(((SetOp)syncOp).value);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                }
            }
            this.endCommit();
        }
        catch (Exception exception) {
            this.abortCommit(exception);
            throw exception;
        }
    }

    protected void commitOp(SyncOp syncOp, Context context) throws Exception {
        block7: {
            try {
                if (syncOp.committed) {
                    return;
                }
                syncOp.committed = true;
                if (syncOp.component == null) {
                    try {
                        syncOp.component = this.findByHandle(syncOp.handle, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (syncOp.component != null) {
                    syncOp.commit(this, this.space, context);
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: SyncOp.commit: " + syncOp);
                exception.printStackTrace();
                if (this.space.isProxyComponentSpace()) break block7;
                throw exception;
            }
        }
    }

    protected void checkAutoStart(BValue bValue) {
        BComponent bComponent;
        BComponent bComponent2;
        if (bValue instanceof BComponent && (bComponent2 = (BComponent)(bComponent = (BComponent)bValue).getParent()) != null && bComponent2.isRunning()) {
            if (this.listener != null) {
                this.listener.updateStatus("Starting \"" + TransferStrategy.toString(bComponent) + "\"...");
            }
            bComponent.start();
        }
    }

    protected BComponent findByHandle(Object object, boolean bl) {
        return this.space.findByHandle(object, bl);
    }

    public void set(BComponent bComponent, Property[] propertyArray, BValue bValue, Context context) {
        String string;
        if (this.coalesce) {
            this.add(new SetOp(bComponent, propertyArray[0].getName(), null));
            return;
        }
        if (propertyArray.length == 1) {
            string = propertyArray[0].getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer(propertyArray[0].getName());
            int n = 1;
            while (n < propertyArray.length) {
                stringBuffer.append('/').append(propertyArray[n].getName());
                ++n;
            }
            string = stringBuffer.toString();
        }
        this.add(new SetOp(bComponent, string, bValue));
    }

    public void add(BComponent bComponent, String string, BValue bValue, int n, BFacets bFacets, Context context) {
        this.add(new AddOp(bComponent, string, bValue, n, bFacets));
    }

    public void remove(BComponent bComponent, Property property, Context context) {
        this.add(new RemoveOp(bComponent, property.getName()));
    }

    public void rename(BComponent bComponent, Property property, String string, Context context) {
        this.add(new RenameOp(bComponent, property.getName(), string));
    }

    public void reorder(BComponent bComponent, Property[] propertyArray, Context context) {
        String[] stringArray = new String[propertyArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = propertyArray[n].getName();
            ++n;
        }
        this.add(new ReorderOp(bComponent, stringArray));
    }

    public void setFlags(BComponent bComponent, Slot slot, int n, Context context) {
        this.add(new SetFlagsOp(bComponent, slot.getName(), n));
    }

    public void setFacets(BComponent bComponent, Slot slot, BFacets bFacets, Context context) {
        this.add(new SetFacetsOp(bComponent, slot.getName(), bFacets));
    }

    public void setCategoryMask(BComponent bComponent, BCategoryMask bCategoryMask, Context context) {
        this.add(new SetCategoryMaskOp(bComponent, bCategoryMask));
    }

    public synchronized SyncOp[] list() {
        SyncOp[] syncOpArray = new SyncOp[this.loads.size + this.ops.size];
        int n = 0;
        SyncOp syncOp = this.loads.head;
        while (syncOp != null) {
            syncOpArray[n] = syncOp;
            syncOp = syncOp.next;
            ++n;
        }
        syncOp = this.ops.head;
        while (syncOp != null) {
            syncOpArray[n] = syncOp;
            syncOp = syncOp.next;
            ++n;
        }
        return syncOpArray;
    }

    public synchronized void add(SyncOp syncOp) {
        if (syncOp.prev != null || syncOp.next != null) {
            throw new IllegalStateException("Already in linked list " + syncOp);
        }
        if (this.coalesce && syncOp instanceof SetOp) {
            this.addSet((SetOp)syncOp);
        } else if (syncOp instanceof LoadOp) {
            this.loads.append(syncOp);
        } else {
            this.ops.append(syncOp);
        }
    }

    private final void addSet(SetOp setOp) {
        BComponent bComponent = setOp.component;
        String string = setOp.name;
        HashMap<String, SetOp> hashMap = (HashMap<String, SetOp>)this.propChanges.get(bComponent);
        if (hashMap != null) {
            SetOp setOp2 = (SetOp)hashMap.get(string);
            if (setOp2 != null) {
                this.ops.remove(setOp2);
            }
        } else {
            hashMap = new HashMap<String, SetOp>(13);
            this.propChanges.put(bComponent, hashMap);
        }
        hashMap.put(string, setOp);
        this.ops.append(setOp);
    }

    public void fw(Object object) {
        if (object instanceof TransferListener) {
            this.listener = (TransferListener)object;
        }
    }

    private final /* synthetic */ void this() {
        this.checkForAutoStart = true;
    }

    public SyncBuffer(BComponentSpace bComponentSpace, boolean bl) {
        this.this();
        this.space = bComponentSpace;
        this.loads = new OpLinkedList();
        this.ops = new OpLinkedList();
        this.coalesce = bl;
        if (bl) {
            this.propChanges = new HashMap();
        }
    }

    static {
        HashMap<String, BBoolean> hashMap = new HashMap<String, BBoolean>();
        hashMap.put("niagaraAutoStart", BBoolean.FALSE);
        noAutoStartFacets = BFacets.make(hashMap);
    }

    static class OpLinkedList {
        SyncOp head;
        SyncOp tail;
        int size;

        void append(SyncOp syncOp) {
            if (this.tail == null) {
                this.head = this.tail = syncOp;
            } else {
                this.tail.next = syncOp;
                syncOp.prev = this.tail;
                this.tail = syncOp;
            }
            ++this.size;
        }

        void remove(SyncOp syncOp) {
            SyncOp syncOp2 = syncOp.prev;
            SyncOp syncOp3 = syncOp.next;
            if (syncOp2 != null) {
                syncOp2.next = syncOp3;
            } else {
                this.head = syncOp3;
            }
            if (syncOp3 != null) {
                syncOp3.prev = syncOp2;
            } else {
                this.tail = syncOp2;
            }
            --this.size;
        }

        void replace(SyncOp syncOp, SyncOp syncOp2) {
            syncOp2.prev = syncOp.prev;
            syncOp2.next = syncOp.next;
            if (syncOp.prev != null) {
                syncOp.prev.next = syncOp2;
            } else {
                this.head = syncOp2;
            }
            if (syncOp.next != null) {
                syncOp.next.prev = syncOp2;
            } else {
                this.tail = syncOp2;
            }
        }

        OpLinkedList() {
        }
    }
}

