/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;

public class SetFlagsOp
extends SyncOp {
    String name;
    int flags;

    public int getId() {
        return 102;
    }

    public String getSlotName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        this.component.setFlags(this.component.getSlot(this.name), this.flags, context);
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        syncEncoder.attr("n", this.name);
        syncEncoder.attr("f", Flags.encodeToString(this.flags)).end().newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        this.name = iElement.get("n");
        this.flags = Flags.decodeFromString(iElement.get("f"));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SetFlags: ").append(this.componentToString()).append('.').append(this.name).append(" -> ").append(Flags.encodeToString(this.flags));
        return stringBuffer.toString();
    }

    public SetFlagsOp(BComponent bComponent, String string, int n) {
        super(bComponent);
        this.name = string;
        this.flags = n;
    }

    public SetFlagsOp() {
    }
}

