/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.engine.ProxyKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LoadOp
extends SyncOp {
    int depth;
    BComponent current;
    HashMap knobs;
    boolean partialLoad;

    public int getId() {
        return 108;
    }

    public int getDepth() {
        return this.depth;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        this.syncComponent(this.current, this.component, this.partialLoad);
        if (!this.partialLoad) {
            this.loadKnobs(bComponentSpace);
        }
    }

    void syncComponent(BComponent bComponent, BComponent bComponent2, boolean bl) throws Exception {
        Object object;
        Object object2;
        if (bComponent.getType() != bComponent2.getType()) {
            throw new IllegalStateException(bComponent.getType() + " != " + bComponent2.getType());
        }
        if (bComponent2.getHandle() == null || !bComponent2.getHandle().equals(bComponent.getHandle())) {
            throw new IllegalStateException("from.h != to.h -> " + bComponent.getHandle() + " != " + bComponent2.getHandle());
        }
        ComponentSlotMap componentSlotMap = (ComponentSlotMap)bComponent.fw(1);
        ComponentSlotMap componentSlotMap2 = (ComponentSlotMap)bComponent2.fw(1);
        componentSlotMap2.setCachedPermissions(componentSlotMap.getCachedPermissions());
        componentSlotMap2.setCategoryMask(componentSlotMap.getCategoryMask(), Context.commit);
        boolean bl2 = ((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded();
        if (!bl2) {
            this.syncIcon(bComponent, bComponent2);
            if (!bl) {
                return;
            }
        }
        if (!bl) {
            ((ComponentSlotMap)bComponent2.fw(1)).setBrokerPropsLoaded(true);
        }
        HashMap<String, Property> hashMap = new HashMap<String, Property>();
        Property[] propertyArray = bComponent2.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            hashMap.put(propertyArray[n].getName(), propertyArray[n]);
            ++n;
        }
        SlotCursor slotCursor = bComponent.getSlots();
        while (slotCursor.next()) {
            object2 = slotCursor.slot().getName();
            object = slotCursor.slot();
            Slot slot = bComponent2.getSlot((String)object2);
            int n2 = bComponent.getFlags((Slot)object);
            if (slot == null) {
                Property property = (Property)object;
                BValue bValue = bComponent.get(property);
                BValue bValue2 = this.newCopy(bValue);
                bComponent2.add((String)object2, bValue2, n2, bComponent.getSlotFacets(property), Context.commit);
                if (!bValue.isComponent()) continue;
                this.syncComponent((BComponent)bValue, (BComponent)bValue2, false);
                continue;
            }
            hashMap.remove(object2);
            bComponent2.setFlags(slot, n2, Context.commit);
            if (!object.isProperty()) continue;
            this.syncValue(bComponent, (Property)object, bComponent2, (Property)slot, false);
        }
        if (hashMap.size() > 0) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                bComponent2.remove((String)object, Context.commit);
            }
        }
    }

    void syncValue(BComplex bComplex, Property property, BComplex bComplex2, Property property2, boolean bl) throws Exception {
        BValue bValue = bComplex.get(property);
        BValue bValue2 = bComplex2.get(property2);
        if (bValue.getClass() != bValue2.getClass() || bValue.isSimple() || bValue2.isComponent() && (bValue2.asComponent().getHandle() == null || bValue2.asComponent().getComponentSpace() == null)) {
            if (bValue.isComponent() && bValue.asComponent().getHandle() == null) {
                if (bValue.asComponent().getPropertyInParent().isDynamic()) {
                    throw new IllegalStateException("LoadOp - dynamic slot with no handle");
                }
                System.out.println("WARNING: remote VM does not have frozen slot \"" + bComplex.getType() + '.' + property.getName() + '\"');
                bComplex2.setFlags(property2, bComplex2.getFlags(property2) | 4, Context.commit);
                return;
            }
            bValue2 = this.newCopy(bValue);
            bComplex2.set(property2, bValue2, Context.commit);
            if (bValue.isComponent()) {
                this.syncComponent((BComponent)bValue, (BComponent)bValue2, bl);
            }
            return;
        }
        if (bValue.isComponent()) {
            BComponent bComponent = (BComponent)bValue;
            BComponent bComponent2 = (BComponent)bValue2;
            if (bComponent2.getHandle() == null) {
                throw new IllegalStateException();
            }
            this.syncComponent(bComponent, bComponent2, bl);
            return;
        }
        BStruct bStruct = (BStruct)bValue;
        BStruct bStruct2 = (BStruct)bValue2;
        SlotCursor slotCursor = bStruct.getProperties();
        while (slotCursor.next()) {
            Property property3;
            Property property4 = slotCursor.property();
            if (property4 != (property3 = bStruct2.getProperty(property4.getName()))) {
                throw new IllegalStateException("Structs should have same prop " + property4 + " != " + property3);
            }
            this.syncValue(bStruct, property4, bStruct2, property3, bl);
        }
    }

    BValue newCopy(BValue bValue) {
        if (bValue.isComponent()) {
            BComponent bComponent = (BComponent)bValue;
            BComponent bComponent2 = (BComponent)bComponent.getType().getInstance();
            ((ComponentSlotMap)bComponent2.fw(1)).setHandle(bComponent.getHandle());
            return bComponent2;
        }
        return bValue.newCopy(true);
    }

    void loadKnobs(BComponentSpace bComponentSpace) throws Exception {
        Iterator iterator = this.knobs.keySet().iterator();
        while (iterator.hasNext()) {
            BComponent bComponent = (BComponent)iterator.next();
            if (!((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) continue;
            BComponent bComponent2 = bComponentSpace.findByHandle(bComponent.getHandle(), false);
            if (bComponent2 == null) {
                throw new IllegalStateException("" + bComponent.getHandle());
            }
            ArrayList arrayList = (ArrayList)this.knobs.get(bComponent);
            ArrayList<ProxyKnob> arrayList2 = new ArrayList<ProxyKnob>(arrayList.size());
            int n = 0;
            while (n < arrayList.size()) {
                ValueDocDecoder.IElement iElement = (ValueDocDecoder.IElement)arrayList.get(n);
                ProxyKnob proxyKnob = SyncDecoder.decodeKnob(bComponent2, iElement);
                if (proxyKnob != null) {
                    arrayList2.add(proxyKnob);
                }
                ++n;
            }
            ((ComponentSlotMap)bComponent2.fw(1)).mergeKnobs(arrayList2);
        }
    }

    void syncIcon(BComponent bComponent, BComponent bComponent2) {
        Property property = bComponent.getProperty("icon");
        if (property == null) {
            return;
        }
        BValue bValue = bComponent.get(property);
        if (!(bValue instanceof BSimple)) {
            return;
        }
        Property property2 = bComponent2.getProperty("icon");
        if (property2 == null) {
            bComponent2.add("icon", bValue, Context.commit);
        } else {
            bComponent2.set(property2, bValue, Context.commit);
        }
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        if (this.partialLoad) {
            syncEncoder.attr("partialLoad", true);
        }
        syncEncoder.endAttr().newLine().key("b");
        syncEncoder.encodeForLoad = true;
        boolean bl = syncEncoder.setEncodeTransients(true);
        syncEncoder.encode(null, this.component, this.depth);
        syncEncoder.setEncodeTransients(bl);
        syncEncoder.encodeForLoad = true;
        syncEncoder.end(String.valueOf((char)this.getId())).newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        this.partialLoad = iElement.get("partialLoad", "false").equals("true");
        syncDecoder.knobs = null;
        syncDecoder.next();
        this.current = (BComponent)syncDecoder.decode();
        this.knobs = syncDecoder.knobs;
        syncDecoder.knobs = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Load: " + this.componentToString());
        if (this.partialLoad) {
            stringBuffer.append(", partialLoad enabled");
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.partialLoad = false;
    }

    public LoadOp(BComponent bComponent, int n) {
        super(bComponent);
        this.this();
        this.depth = n;
    }

    public LoadOp() {
        this.this();
    }

    public LoadOp(BComponent bComponent, int n, boolean bl) {
        this(bComponent, n);
        this.partialLoad = bl;
    }
}

