/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Topic;

public class FireTopicOp
extends SyncOp {
    String name;
    BValue event;

    public int getId() {
        return 116;
    }

    public String getSlotName() {
        return this.name;
    }

    public BValue getEvent() {
        return this.event;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        Topic topic = this.component.getTopic(this.name);
        if (topic != null) {
            this.component.fire(topic, this.event, Context.commit);
        }
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        BPermissions bPermissions;
        if (this.event != null && this.event.isComponent() && !(bPermissions = syncEncoder.getPermissionsFor(this.event.asComponent())).hasOperatorRead()) {
            throw new SyncOp.SyncOpSecurityException(this, "Missing op read permission on value");
        }
        super.encode(syncEncoder);
        syncEncoder.attr("n", this.name).endAttr().newLine();
        if (this.event != null) {
            syncEncoder.key("b");
            syncEncoder.encode(this.event);
        }
        syncEncoder.end(String.valueOf((char)this.getId())).newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        this.name = syncDecoder.elem().get("n");
        syncDecoder.next();
        if (syncDecoder.type() == 1 && syncDecoder.elem().name().equals("p")) {
            this.event = syncDecoder.decode();
        }
    }

    public String toString() {
        return "FireTopic: " + this.componentToString() + '.' + this.name + " -> " + this.event;
    }

    public FireTopicOp(BComponent bComponent, String string, BValue bValue) {
        super(bComponent);
        this.name = string;
        this.event = bValue;
    }

    public FireTopicOp() {
    }
}

