/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.io.ValueDocDecoder;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;

public class AddOp
extends SyncOp {
    String name;
    BValue value;
    int flags;
    BFacets facets;
    String newName;

    public int getId() {
        return 97;
    }

    public String getSlotName() {
        return this.name;
    }

    public BValue getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public String getNewSlotName() {
        return this.newName;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        block3: {
            try {
                ComponentSlotMap componentSlotMap = (ComponentSlotMap)this.component.fw(1);
                ComplexSlotMap complexSlotMap = (ComplexSlotMap)this.value.fw(1);
                Property property = componentSlotMap.add(this.name, this.flags, this.value, complexSlotMap, this.facets, context, syncBuffer.listener);
                if (property != null) {
                    this.newName = property.getName();
                }
            }
            catch (DuplicateSlotException duplicateSlotException) {
                if (bComponentSpace.isProxyComponentSpace()) break block3;
                throw duplicateSlotException;
            }
        }
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        BPermissions bPermissions;
        if (this.value.isComponent() && !(bPermissions = syncEncoder.getPermissionsFor(this.value.asComponent())).hasOperatorRead()) {
            throw new SyncOp.SyncOpSecurityException(this, "Missing op read permission on value");
        }
        super.encode(syncEncoder);
        if (this.name != null) {
            syncEncoder.attr("n", this.name);
        }
        if (this.flags != 0) {
            syncEncoder.attr("f", Flags.encodeToString(this.flags));
        }
        if (this.facets != null && !this.facets.isNull()) {
            syncEncoder.attr("facets", this.facets.encodeToString());
        }
        syncEncoder.endAttr().newLine().key("b");
        syncEncoder.encode(this.value);
        syncEncoder.end(String.valueOf((char)this.getId())).newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        this.name = iElement.get("n", null);
        this.flags = Flags.decodeFromString(iElement.get("f", "0"));
        this.facets = (BFacets)BFacets.DEFAULT.decodeFromString(iElement.get("facets", ""));
        syncDecoder.next();
        this.value = syncDecoder.decode();
    }

    public String toString() {
        return "Add: " + this.componentToString() + " -> " + this.name + " = " + this.value;
    }

    public AddOp(BComponent bComponent, String string, BValue bValue, int n, BFacets bFacets) {
        super(bComponent);
        this.name = string;
        this.value = bValue;
        this.flags = n;
        this.facets = bFacets;
    }

    public AddOp() {
    }
}

