/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.status;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.status.BIStatus;
import javax.baja.sys.BBitString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BStatus
extends BBitString
implements BIStatus {
    public static BSimple disabledFg;
    public static BSimple disabledBg;
    public static BSimple faultFg;
    public static BSimple faultBg;
    public static BSimple downFg;
    public static BSimple downBg;
    public static BSimple alarmFg;
    public static BSimple alarmBg;
    public static BSimple staleFg;
    public static BSimple staleBg;
    public static BSimple overriddenFg;
    public static BSimple overriddenBg;
    private static BStatus[] nullLookupTable;
    public static final int DISABLED = 1;
    public static final int FAULT = 2;
    public static final int DOWN = 4;
    public static final int ALARM = 8;
    public static final int STALE = 16;
    public static final int OVERRIDDEN = 32;
    public static final int NULL = 64;
    public static final int UNACKED_ALARM = 128;
    public static final BStatus ok;
    public static final BStatus disabled;
    public static final BStatus fault;
    public static final BStatus down;
    public static final BStatus alarm;
    public static final BStatus stale;
    public static final BStatus overridden;
    public static final BStatus nullStatus;
    public static final BStatus unackedAlarm;
    public static final BStatus DEFAULT;
    private static BBitString.Support support;
    public static final String ACTIVE_LEVEL = "activeLevel";
    public static final Type TYPE;
    private int bits;
    private BFacets facets;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$status$BStatus;

    public static final BStatus make(int n) {
        return BStatus.make(n, BFacets.NULL);
    }

    public static final BStatus make(BStatus bStatus, int n) {
        if (bStatus.bits == n) {
            return bStatus;
        }
        return BStatus.make(n, bStatus.facets);
    }

    public static final BStatus make(int n, BFacets bFacets) {
        if ((bFacets == null || bFacets.isNull()) && n < 256) {
            if (nullLookupTable[n] == null) {
                BStatus.nullLookupTable[n] = new BStatus(n, BFacets.NULL);
            }
            return nullLookupTable[n];
        }
        return (BStatus)new BStatus(n, bFacets).intern();
    }

    public static final BStatus make(BStatus bStatus, int n, boolean bl) {
        int n2;
        int n3 = n2 = bl ? bStatus.bits | n : bStatus.bits & ~n;
        if (n2 == 0 && bStatus.facets.isNull()) {
            return ok;
        }
        if (bStatus.bits == n2) {
            return bStatus;
        }
        return BStatus.make(n2, bStatus.facets);
    }

    public static final BStatus makeDisabled(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 1, bl);
    }

    public static final BStatus makeFault(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 2, bl);
    }

    public static final BStatus makeDown(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 4, bl);
    }

    public static final BStatus makeAlarm(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 8, bl);
    }

    public static final BStatus makeStale(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 16, bl);
    }

    public static final BStatus makeOverridden(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 32, bl);
    }

    public static final BStatus makeNull(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 64, bl);
    }

    public static final BStatus makeUnackedAlarm(BStatus bStatus, boolean bl) {
        return BStatus.make(bStatus, 128, bl);
    }

    public static final BStatus make(BStatus bStatus, String string, BIDataValue bIDataValue) {
        BFacets bFacets = BFacets.make(bStatus.facets, string, bIDataValue);
        if (bFacets == bStatus.facets) {
            return bStatus;
        }
        return BStatus.make(bStatus.bits, bFacets);
    }

    public static final BStatus make(BStatus bStatus, String string, boolean bl) {
        return BStatus.make(bStatus, string, BBoolean.make(bl));
    }

    public static final BStatus make(BStatus bStatus, String string, int n) {
        return BStatus.make(bStatus, string, BInteger.make(n));
    }

    public static final BStatus make(BStatus bStatus, String string, float f) {
        return BStatus.make(bStatus, string, BFloat.make(f));
    }

    public static final BStatus make(BStatus bStatus, String string, String string2) {
        return BStatus.make(bStatus, string, BString.make(string2));
    }

    public final BStatus getStatus() {
        return this;
    }

    public final BFacets getFacets() {
        return this.facets;
    }

    public final BObject get(String string) {
        return this.facets.get(string);
    }

    public final boolean getb(String string, boolean bl) {
        return this.facets.getb(string, bl);
    }

    public final int geti(String string, int n) {
        return this.facets.geti(string, n);
    }

    public final long getl(String string, long l) {
        return this.facets.getl(string, l);
    }

    public final float getf(String string, float f) {
        return this.facets.getf(string, f);
    }

    public final double getd(String string, double d) {
        return this.facets.getd(string, d);
    }

    public final String gets(String string, String string2) {
        return this.facets.gets(string, string2);
    }

    public final int getBits() {
        return this.bits;
    }

    public final boolean isValid() {
        boolean bl = false;
        if ((this.bits & 1) == 0 && (this.bits & 2) == 0 && (this.bits & 4) == 0 && (this.bits & 0x10) == 0 && (this.bits & 0x40) == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOk() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDisabled() {
        boolean bl = false;
        if ((this.bits & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isFault() {
        boolean bl = false;
        if ((this.bits & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDown() {
        boolean bl = false;
        if ((this.bits & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAlarm() {
        boolean bl = false;
        if ((this.bits & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isStale() {
        boolean bl = false;
        if ((this.bits & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOverridden() {
        boolean bl = false;
        if ((this.bits & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNull() {
        boolean bl = false;
        if ((this.bits & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isUnackedAlarm() {
        boolean bl = false;
        if ((this.bits & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(int n) {
        boolean bl = false;
        if ((this.bits & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(String string) {
        return this.getBit(this.tagToOrdinal(string));
    }

    public final int[] getOrdinals() {
        return support.getOrdinals();
    }

    public final boolean isOrdinal(int n) {
        return support.isOrdinal(n);
    }

    public final String getTag(int n) {
        return support.getTag(n);
    }

    public final String getDisplayTag(int n, Context context) {
        return support.getDisplayTag(n, context);
    }

    public final BBitString getInstance(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n |= nArray[n2];
            ++n2;
        }
        return BStatus.make(n);
    }

    public final boolean isTag(String string) {
        return support.isTag(string);
    }

    public final int tagToOrdinal(String string) {
        return support.tagToOrdinal(string);
    }

    public final boolean isEmpty() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final String getEmptyTag() {
        return "ok";
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.bits << 13 ^ this.facets.hashCode();
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object instanceof BStatus) {
            BStatus bStatus = (BStatus)object;
            boolean bl = false;
            if (bStatus.bits == this.bits && bStatus.facets.equals(this.facets)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String flagsToString(Context context) {
        if (this.bits == 0) {
            return Lexicon.make(Sys.getBajaModule(), context).getText("Status.ok");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDisabled()) {
            stringBuffer.append(this.getDisplayTag(1, context)).append(',');
        }
        if (this.isFault()) {
            stringBuffer.append(this.getDisplayTag(2, context)).append(',');
        }
        if (this.isDown()) {
            stringBuffer.append(this.getDisplayTag(4, context)).append(',');
        }
        if (this.isAlarm()) {
            stringBuffer.append(this.getDisplayTag(8, context)).append(',');
        }
        if (this.isStale()) {
            stringBuffer.append(this.getDisplayTag(16, context)).append(',');
        }
        if (this.isOverridden()) {
            stringBuffer.append(this.getDisplayTag(32, context)).append(',');
        }
        if (this.isNull()) {
            stringBuffer.append(this.getDisplayTag(64, context)).append(',');
        }
        if (this.isUnackedAlarm()) {
            stringBuffer.append(this.getDisplayTag(128, context)).append(',');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{').append(this.flagsToString(context)).append('}');
        if (!this.facets.isNull()) {
            String[] stringArray = this.facets.list();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                BObject bObject = this.facets.get(string);
                if (string.equals(ACTIVE_LEVEL)) {
                    stringBuffer.append(" @ ").append(bObject);
                } else if (bObject == BBoolean.TRUE) {
                    stringBuffer.append(' ').append(string);
                } else {
                    stringBuffer.append(' ').append(string).append('=').append(bObject);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.bits);
        dataOutput.writeUTF(this.facets.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BStatus.make(dataInput.readInt(), (BFacets)BFacets.NULL.decodeFromString(dataInput.readUTF()));
    }

    public final String encodeToString() throws IOException {
        String string = Integer.toHexString(this.bits);
        if (this.facets.isNull()) {
            return string;
        }
        return string + ';' + this.facets.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = string.indexOf(59);
            if (n < 0) {
                return BStatus.make(Integer.parseInt(string, 16));
            }
            int n2 = Integer.parseInt(string.substring(0, n), 16);
            BFacets bFacets = (BFacets)BFacets.NULL.decodeFromString(string.substring(n + 1));
            return BStatus.make(n2, bFacets);
        }
        catch (Exception exception) {
            throw new IOException("Invalid bits: " + string);
        }
    }

    public final BSimple getForegroundColor(BSimple bSimple) {
        if (this.isDisabled()) {
            return disabledFg;
        }
        if (this.isFault()) {
            return faultFg;
        }
        if (this.isDown()) {
            return downFg;
        }
        if (this.isAlarm()) {
            return alarmFg;
        }
        if (this.isStale()) {
            return staleFg;
        }
        if (this.isOverridden()) {
            return overriddenFg;
        }
        return bSimple;
    }

    public final BSimple getBackgroundColor(BSimple bSimple) {
        if (this.isDisabled()) {
            return disabledBg;
        }
        if (this.isFault()) {
            return faultBg;
        }
        if (this.isDown()) {
            return downBg;
        }
        if (this.isAlarm()) {
            return alarmBg;
        }
        if (this.isStale()) {
            return staleBg;
        }
        if (this.isOverridden()) {
            return overriddenBg;
        }
        return bSimple;
    }

    static final BSimple color(Lexicon lexicon, BSimple bSimple, String string) throws IOException {
        String string2 = lexicon.get(string, null);
        if (string2 == null) {
            return null;
        }
        return (BSimple)bSimple.decodeFromString(string2);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BStatus(int n, BFacets bFacets) {
        this.this();
        this.bits = n;
        this.facets = bFacets != null ? bFacets : BFacets.NULL;
    }

    static {
        try {
            Lexicon lexicon = Lexicon.make("baja");
            BSimple bSimple = (BSimple)Sys.getType("gx:Color").getInstance();
            disabledFg = BStatus.color(lexicon, bSimple, "Status.disabled.fg");
            disabledBg = BStatus.color(lexicon, bSimple, "Status.disabled.bg");
            faultFg = BStatus.color(lexicon, bSimple, "Status.fault.fg");
            faultBg = BStatus.color(lexicon, bSimple, "Status.fault.bg");
            downFg = BStatus.color(lexicon, bSimple, "Status.down.fg");
            downBg = BStatus.color(lexicon, bSimple, "Status.down.bg");
            alarmFg = BStatus.color(lexicon, bSimple, "Status.alarm.fg");
            alarmBg = BStatus.color(lexicon, bSimple, "Status.alarm.bg");
            staleFg = BStatus.color(lexicon, bSimple, "Status.stale.fg");
            staleBg = BStatus.color(lexicon, bSimple, "Status.stale.bg");
            overriddenFg = BStatus.color(lexicon, bSimple, "Status.overridden.fg");
            overriddenBg = BStatus.color(lexicon, bSimple, "Status.overridden.bg");
        }
        catch (TypeNotFoundException typeNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        nullLookupTable = new BStatus[256];
        ok = BStatus.make(0, BFacets.NULL);
        disabled = BStatus.make(1, BFacets.NULL);
        fault = BStatus.make(2, BFacets.NULL);
        down = BStatus.make(4, BFacets.NULL);
        alarm = BStatus.make(8, BFacets.NULL);
        stale = BStatus.make(16, BFacets.NULL);
        overridden = BStatus.make(32, BFacets.NULL);
        nullStatus = BStatus.make(64, BFacets.NULL);
        unackedAlarm = BStatus.make(128, BFacets.NULL);
        DEFAULT = ok;
        support = new BBitString.Support(DEFAULT);
        support.add(1, "disabled");
        support.add(2, "fault");
        support.add(4, "down");
        support.add(8, "alarm");
        support.add(16, "stale");
        support.add(32, "overridden");
        support.add(64, "null");
        support.add(128, "unackedAlarm");
        Class clazz = class$javax$baja$status$BStatus;
        if (clazz == null) {
            clazz = class$javax$baja$status$BStatus = BStatus.class("[Ljavax.baja.status.BStatus;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

