/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import com.tridium.sys.transfer.TransferStrategy;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class Mark {
    private static Mark current;
    private BObject[] values;
    private String[] names;
    private boolean pendingMove;

    public static Mark getCurrent() {
        return current;
    }

    public static void setCurrent(Mark mark) {
        if (current != null) {
            current.setPendingMove(false);
        }
        current = mark;
    }

    public BObject getValue(int n) {
        return this.values[n];
    }

    public BObject[] getValues() {
        return (BObject[])this.values.clone();
    }

    public Object[] getValues(Object[] objectArray) {
        if (objectArray.length < this.values.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.values.length);
        }
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        return objectArray;
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public int size() {
        return this.values.length;
    }

    public boolean areAllValuesComponents() {
        int n = 0;
        while (n < this.values.length) {
            if (!(this.values[n] instanceof BComponent)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toStringFormat() {
        try {
            Object object;
            BObject bObject = this.values[0];
            if (bObject instanceof BComponent && (object = ((BComponent)bObject).getSlotPath()) != null) {
                return "station:|" + object;
            }
            if (bObject instanceof BISpaceNode && (object = ((BISpaceNode)((Object)bObject)).getOrdInSession()) != null) {
                return ((BObject)object).toString();
            }
            return bObject.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    public boolean isPendingMove() {
        return this.pendingMove;
    }

    public void setPendingMove(boolean bl) {
        if (this.pendingMove == bl) {
            return;
        }
        this.pendingMove = bl;
        int n = 0;
        while (n < this.values.length) {
            ((BISpaceNode)((Object)this.values[n])).setPendingMove(bl);
            ++n;
        }
    }

    public void copyTo(BObject bObject, Context context) throws Exception {
        TransferStrategy.make(16, this, bObject, null, context).transfer();
    }

    public void moveTo(BObject bObject, Context context) throws Exception {
        TransferStrategy.make(32, this, bObject, null, context).transfer();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Mark [" + this.values.length + "] " + Integer.toString(this.hashCode(), 36));
        int n = 0;
        while (n < this.values.length) {
            printWriter.println("  " + this.names[n] + " = " + this.values[n].toDebugString());
            ++n;
        }
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public static String makeName(BObject bObject) {
        String string = null;
        if (bObject instanceof BINavNode) {
            string = ((BINavNode)((Object)bObject)).getNavName();
        }
        if (string == null) {
            string = bObject.getType().getTypeName();
        }
        return string;
    }

    public static String[] makeNames(BObject[] bObjectArray) {
        String[] stringArray = new String[bObjectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = Mark.makeName(bObjectArray[n]);
            ++n;
        }
        return stringArray;
    }

    public Mark(BObject[] bObjectArray, String[] stringArray) {
        if (bObjectArray.length != stringArray.length) {
            throw new IllegalArgumentException("values.length != names.length");
        }
        int n = 0;
        while (n < bObjectArray.length) {
            if (bObjectArray[n] == null || stringArray[n] == null) {
                throw new NullPointerException();
            }
            ++n;
        }
        this.values = (BObject[])bObjectArray.clone();
        this.names = (String[])stringArray.clone();
    }

    public Mark(BObject bObject, String string) {
        this(new BObject[]{bObject}, new String[]{string});
    }

    public Mark(BObject bObject) {
        this(new BObject[]{bObject}, new String[]{Mark.makeName(bObject)});
    }

    public Mark(BObject[] bObjectArray) {
        this(bObjectArray, Mark.makeNames(bObjectArray));
    }
}

