/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.kerberos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class BKerberosCredentials
extends BStruct
implements BIUserCredentials {
    public static final Type TYPE = Sys.loadType(class$javax$baja$security$kerberos$BKerberosCredentials == null ? (class$javax$baja$security$kerberos$BKerberosCredentials = BKerberosCredentials.class$("javax.baja.security.kerberos.BKerberosCredentials")) : class$javax$baja$security$kerberos$BKerberosCredentials);
    GSSCredential credentials;
    private String username = null;
    static /* synthetic */ Class class$javax$baja$security$kerberos$BKerberosCredentials;

    public Type getType() {
        return TYPE;
    }

    public BKerberosCredentials() {
        this.credentials = null;
    }

    public BKerberosCredentials(GSSCredential gSSCredential) {
        this.credentials = gSSCredential;
    }

    public GSSCredential getCredential() {
        return this.credentials;
    }

    public String getUsername() {
        if (this.credentials == null) {
            return null;
        }
        if (this.username == null) {
            try {
                String string = this.credentials.getName().toString();
                int n = string.indexOf("@");
                if (n > -1) {
                    string = string.substring(0, n);
                }
                this.username = string;
            }
            catch (GSSException gSSException) {
                throw new AuthenticationException("Could not extract username from credentials");
            }
        }
        return this.username;
    }

    public String getRealm() {
        if (this.credentials == null) {
            return null;
        }
        try {
            String string = this.credentials.getName().toString();
            int n = string.indexOf("@");
            if (n > -1) {
                return string.substring(n + 1);
            }
            return null;
        }
        catch (GSSException gSSException) {
            throw new AuthenticationException("Could not extract realm name from credentials");
        }
    }

    public boolean isExpired() {
        if (this.credentials == null) {
            return false;
        }
        try {
            return this.credentials.getRemainingLifetime() == 0;
        }
        catch (GSSException gSSException) {
            throw new AuthenticationException("Could not extract remaining lifetime from credentials");
        }
    }

    public void destroyTicket() {
        try {
            this.credentials.dispose();
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }

    public BICredentials decodeCredentials(byte[] byArray) throws IOException {
        BKerberosCredentials bKerberosCredentials = (BKerberosCredentials)this.newCopy();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            bKerberosCredentials.credentials = (GSSCredential)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return bKerberosCredentials;
    }

    public byte[] encodeCredentials() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.credentials);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

