/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.crypto;

import com.tridium.sys.Nre;
import java.lang.reflect.Method;
import javax.baja.log.Log;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.ICryptoManagerEx;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class CertManagerFactory {
    private static Log log = Log.getLog("crypto");
    private static ICryptoManagerEx instance = null;
    private static Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isCertManagerActive() {
        try {
            CertManagerFactory.getInstanceEx();
            Object object = mutex;
            // MONITORENTER : object
            if (instance != null) {
                // MONITOREXIT : object
                return true;
            }
            // MONITOREXIT : object
            return false;
        }
        catch (Exception exception) {}
        return false;
    }

    public static ICryptoManager getInstance() throws Exception {
        return CertManagerFactory.getInstanceEx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ICryptoManagerEx getInstanceEx() throws Exception {
        Object object = mutex;
        synchronized (object) {
            block9: {
                block10: {
                    if (instance != null) break block9;
                    if (Nre.stationHome == null) break block10;
                    if (Sys.getStation() == null) {
                        throw new NotRunningException("station hasn't finished loading services, can't retrieve ICryptoManagerEx instance");
                    }
                    if (Sys.getStation().isRunning() && (instance = (ICryptoManagerEx)((Object)Sys.getService(Sys.getType("platCrypto:CertManagerService")))) == null) {
                        throw new ServiceNotFoundException("unable to find CertManagerService");
                    }
                    break block9;
                }
                if (Nre.bootEnv.isRemote()) {
                    Type type = Sys.getType("platCrypto:WbAppletCertManager");
                    instance = CertManagerFactory.make(type.getTypeClass());
                    if (instance == null) {
                        throw new ServiceNotFoundException("unable to find WbAppletCertManager instance");
                    }
                } else {
                    Type type = Sys.getType("platCrypto:WbCertManager");
                    instance = CertManagerFactory.make(type.getTypeClass());
                    if (instance == null) {
                        throw new ServiceNotFoundException("unable to find WbCertManager instance");
                    }
                }
            }
            return instance;
        }
    }

    private static final ICryptoManagerEx make(Class clazz) {
        try {
            Method method = clazz.getMethod("make", null);
            ICryptoManagerEx iCryptoManagerEx = (ICryptoManagerEx)method.invoke((Object)clazz, null);
            return iCryptoManagerEx;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (log.isTraceOn()) {
                log.error("unable to call make on " + clazz.getName(), exception);
            }
            return null;
        }
    }
}

