/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryMode;
import javax.baja.category.BCategoryService;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPermissionsMap
extends BSimple {
    public static final BPermissionsMap SUPER_USER = new BPermissionsMap(new BPermissions[0], "super");
    public static final BPermissionsMap DEFAULT = new BPermissionsMap(new BPermissions[0], "");
    public static final Type TYPE;
    private BPermissions[] permissions;
    private int size;
    private String string;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$security$BPermissionsMap;

    public static final BPermissionsMap make(BPermissions[] bPermissionsArray) {
        if (bPermissionsArray.length <= 1) {
            return DEFAULT;
        }
        bPermissionsArray = (BPermissions[])bPermissionsArray.clone();
        return (BPermissionsMap)new BPermissionsMap(bPermissionsArray, null).intern();
    }

    public final BPermissionsMap or(BPermissionsMap bPermissionsMap) {
        if (this.isSuperUser() || bPermissionsMap.isSuperUser()) {
            return SUPER_USER;
        }
        BPermissions[] bPermissionsArray = new BPermissions[Math.max(this.permissions.length, bPermissionsMap.permissions.length)];
        int n = 0;
        while (n < bPermissionsArray.length) {
            BPermissions bPermissions;
            BPermissions bPermissions2 = n < this.permissions.length ? this.permissions[n] : BPermissions.none;
            BPermissions bPermissions3 = bPermissions = n < bPermissionsMap.permissions.length ? bPermissionsMap.permissions[n] : BPermissions.none;
            if (bPermissions2 == null) {
                bPermissions2 = BPermissions.none;
            }
            if (bPermissions == null) {
                bPermissions = BPermissions.none;
            }
            bPermissionsArray[n] = bPermissions2.or(bPermissions);
            ++n;
        }
        return BPermissionsMap.make(bPermissionsArray);
    }

    public final BPermissionsMap and(BPermissionsMap bPermissionsMap) {
        if (this.isSuperUser() && bPermissionsMap.isSuperUser()) {
            return SUPER_USER;
        }
        BPermissions[] bPermissionsArray = new BPermissions[Math.max(this.permissions.length, bPermissionsMap.permissions.length)];
        int n = 0;
        while (n < bPermissionsArray.length) {
            BPermissions bPermissions;
            BPermissions bPermissions2 = n < this.permissions.length ? this.permissions[n] : BPermissions.none;
            BPermissions bPermissions3 = bPermissions = n < bPermissionsMap.permissions.length ? bPermissionsMap.permissions[n] : BPermissions.none;
            if (this.isSuperUser()) {
                bPermissions2 = BPermissions.all;
            }
            if (bPermissionsMap.isSuperUser()) {
                bPermissions = BPermissions.all;
            }
            if (bPermissions2 == null) {
                bPermissions2 = BPermissions.none;
            }
            if (bPermissions == null) {
                bPermissions = BPermissions.none;
            }
            bPermissionsArray[n] = bPermissions2.and(bPermissions);
            ++n;
        }
        return BPermissionsMap.make(bPermissionsArray);
    }

    public final boolean isSuperUser() {
        boolean bl = false;
        if (this == SUPER_USER) {
            bl = true;
        }
        return bl;
    }

    public final int size() {
        if (this.size < 0) {
            int n = this.permissions.length - 1;
            while (n > 0) {
                BPermissions bPermissions = this.permissions[n];
                if (bPermissions != null && bPermissions.getMask() != 0) break;
                --n;
            }
            this.size = n + 1;
        }
        return this.size;
    }

    public final BPermissions getPermissions(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Category index < 1");
        }
        if (this == SUPER_USER) {
            return BPermissions.all;
        }
        if (n >= this.permissions.length) {
            return BPermissions.none;
        }
        BPermissions bPermissions = this.permissions[n];
        if (bPermissions == null) {
            return BPermissions.none;
        }
        return bPermissions;
    }

    public final BPermissions getPermissions(BCategoryMask bCategoryMask) {
        if (this == SUPER_USER) {
            return BPermissions.all;
        }
        BCategoryService bCategoryService = null;
        try {
            bCategoryService = (BCategoryService)Sys.getService(BCategoryService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
        }
        catch (NotRunningException notRunningException) {}
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = this.permissions.length;
        int n4 = 1;
        while (n4 < n3) {
            if (bCategoryMask.get(n4)) {
                BValue bValue;
                BCategoryMode bCategoryMode = null;
                if (bCategoryService != null) {
                    bValue = null;
                    try {
                        bValue = bCategoryService.getCategory(n4);
                    }
                    catch (NotRunningException notRunningException) {}
                    if (bValue != null) {
                        bCategoryMode = ((BCategory)bValue).getMode();
                    }
                }
                bValue = this.permissions[n4];
                if (bCategoryMode == null || bCategoryMode == BCategoryMode.union) {
                    if (bValue != null) {
                        bl2 = true;
                        n |= ((BPermissions)bValue).getMask();
                    }
                } else {
                    if (bValue == null) {
                        return BPermissions.none;
                    }
                    bl = true;
                    n2 &= ((BPermissions)bValue).getMask();
                }
            }
            ++n4;
        }
        if (bl) {
            if (bl2) {
                return BPermissions.make(n & n2);
            }
            return BPermissions.make(n2);
        }
        return BPermissions.make(n);
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BPermissionsMap) {
            BPermissionsMap bPermissionsMap = (BPermissionsMap)object;
            if (this.isSuperUser()) {
                return bPermissionsMap.isSuperUser();
            }
            if (bPermissionsMap.isSuperUser()) {
                return this.isSuperUser();
            }
            int n = Math.max(this.permissions.length, bPermissionsMap.permissions.length);
            int n2 = 1;
            while (n2 < n) {
                if (!this.getPermissions(n2).equals(bPermissionsMap.getPermissions(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            while (n < this.permissions.length) {
                BPermissions bPermissions = this.permissions[n];
                if (bPermissions != null && bPermissions.getMask() != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(';');
                    }
                    stringBuffer.append(n).append('=').append(bPermissions.encodeToString());
                }
                ++n;
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.equals("super")) {
            return SUPER_USER;
        }
        if (string.equals("")) {
            return DEFAULT;
        }
        BPermissions[] bPermissionsArray = new BPermissions[8];
        String[] stringArray = TextUtil.split((String)string, (char)';');
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(61);
            int n3 = Integer.parseInt(string2.substring(0, n2));
            BPermissions bPermissions = BPermissions.make(string2.substring(n2 + 1));
            if (n3 >= bPermissionsArray.length) {
                BPermissions[] bPermissionsArray2 = new BPermissions[Math.max(n3 + 4, bPermissionsArray.length * 2)];
                System.arraycopy(bPermissionsArray, 0, bPermissionsArray2, 0, bPermissionsArray.length);
                bPermissionsArray = bPermissionsArray2;
            }
            bPermissionsArray[n3] = bPermissions;
            ++n;
        }
        return (BPermissionsMap)new BPermissionsMap(bPermissionsArray, string).intern();
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.size = -1;
        this.hashCode = -1;
    }

    private BPermissionsMap(BPermissions[] bPermissionsArray, String string) {
        this.this();
        this.permissions = bPermissionsArray;
        this.string = string;
    }

    static {
        Class clazz = class$javax$baja$security$BPermissionsMap;
        if (clazz == null) {
            clazz = class$javax$baja$security$BPermissionsMap = BPermissionsMap.class("[Ljavax.baja.security.BPermissionsMap;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

