/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPermissions
extends BSimple {
    static IntHashMap cache = new IntHashMap();
    public static final int OPERATOR_READ = 1;
    public static final int OPERATOR_WRITE = 2;
    public static final int OPERATOR_INVOKE = 4;
    public static final int ADMIN_READ = 16;
    public static final int ADMIN_WRITE = 32;
    public static final int ADMIN_INVOKE = 64;
    public static final BPermissions operatorRead = BPermissions.make(1);
    public static final BPermissions operatorWrite = BPermissions.make(2);
    public static final BPermissions operatorInvoke = BPermissions.make(4);
    public static final BPermissions adminRead = BPermissions.make(16);
    public static final BPermissions adminWrite = BPermissions.make(32);
    public static final BPermissions adminInvoke = BPermissions.make(64);
    public static final BPermissions all = BPermissions.make(119);
    public static final BPermissions none;
    public static final BPermissions DEFAULT;
    public static final Type TYPE;
    private int mask;
    private String string;
    static /* synthetic */ Class class$javax$baja$security$BPermissions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BPermissions make(int n) {
        if ((n & 2) != 0) {
            n |= 1;
        }
        if ((n & 0x10) != 0) {
            n |= 1;
        }
        if ((n & 0x20) != 0) {
            n |= 0x13;
        }
        if ((n & 0x40) != 0) {
            n |= 4;
        }
        IntHashMap intHashMap = cache;
        synchronized (intHashMap) {
            BPermissions bPermissions = (BPermissions)cache.get(n);
            if (bPermissions == null) {
                bPermissions = new BPermissions(n);
                cache.put(n, (Object)bPermissions);
            }
            return bPermissions;
        }
    }

    public final BPermissions or(BPermissions bPermissions) {
        return BPermissions.make(this.mask | bPermissions.mask);
    }

    public final BPermissions and(BPermissions bPermissions) {
        return BPermissions.make(this.mask & bPermissions.mask);
    }

    public static final BPermissions make(String string) throws IOException {
        return (BPermissions)DEFAULT.decodeFromString(string);
    }

    public final int getMask() {
        return this.mask;
    }

    public final boolean has(int n) {
        boolean bl = false;
        if ((this.mask & n) == n) {
            bl = true;
        }
        return bl;
    }

    public final boolean has(BPermissions bPermissions) {
        boolean bl = false;
        if ((this.mask & bPermissions.mask) == bPermissions.mask) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasOperatorRead() {
        boolean bl = false;
        if ((this.mask & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasOperatorWrite() {
        boolean bl = false;
        if ((this.mask & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasOperatorInvoke() {
        boolean bl = false;
        if ((this.mask & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasAdminRead() {
        boolean bl = false;
        if ((this.mask & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasAdminWrite() {
        boolean bl = false;
        if ((this.mask & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasAdminInvoke() {
        boolean bl = false;
        if ((this.mask & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object == this) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.hasOperatorRead()) {
                stringBuffer.append('r');
            }
            if (this.hasOperatorWrite()) {
                stringBuffer.append('w');
            }
            if (this.hasOperatorInvoke()) {
                stringBuffer.append('i');
            }
            if (this.hasAdminRead()) {
                stringBuffer.append('R');
            }
            if (this.hasAdminWrite()) {
                stringBuffer.append('W');
            }
            if (this.hasAdminInvoke()) {
                stringBuffer.append('I');
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                switch (string.charAt(n2)) {
                    case 'i': {
                        n |= 4;
                        break;
                    }
                    case 'r': {
                        n |= 1;
                        break;
                    }
                    case 'w': {
                        n |= 2;
                        break;
                    }
                    case 'I': {
                        n |= 0x40;
                        break;
                    }
                    case 'R': {
                        n |= 0x10;
                        break;
                    }
                    case 'W': {
                        n |= 0x20;
                        break;
                    }
                }
                ++n2;
            }
            return BPermissions.make(n);
        }
        catch (IllegalNameException illegalNameException) {
            throw illegalNameException;
        }
        catch (Exception exception) {
            throw new IOException("Invalid BPermissions: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BPermissions(int n) {
        this.mask = n;
    }

    static {
        DEFAULT = none = BPermissions.make(0);
        Class clazz = class$javax$baja$security$BPermissions;
        if (clazz == null) {
            clazz = class$javax$baja$security$BPermissions = BPermissions.class("[Ljavax.baja.security.BPermissions;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

