/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.auth.Pbkdf2HmacSha256;
import com.tridium.nre.auth.SecurityUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.baja.agent.BIAgent;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPbkdf2HmacSha256PasswordEncoder
extends BAbstractPasswordEncoder
implements BIAgent {
    public static final Type TYPE;
    public static final String ENCODING_TYPE = "pbkdf2hmacsha256/text";
    private static final int DK_LEN = 32;
    private static final int ITERATION_COUNT = 4096;
    private String salt;
    private String key;
    private int iterationCount;
    static /* synthetic */ Class class$javax$baja$security$BPbkdf2HmacSha256PasswordEncoder;

    public final Type getType() {
        return TYPE;
    }

    public final void encode(String string) throws Exception {
        byte[] byArray = new byte[16];
        new SecureRandom().nextBytes(byArray);
        this.salt = ByteArrayUtil.toHexString((byte[])byArray);
        this.iterationCount = 4096;
        byte[] byArray2 = Pbkdf2HmacSha256.deriveKey((byte[])byArray, (long)this.iterationCount, (String)string, (int)32);
        this.key = TextUtil.bytesToHexString((byte[])byArray2);
    }

    public final void encode(String string, String string2, int n) throws Exception {
        this.salt = string2;
        this.iterationCount = n;
        byte[] byArray = ByteArrayUtil.hexStringToBytes((String)string2);
        byte[] byArray2 = Pbkdf2HmacSha256.deriveKey((byte[])byArray, (long)n, (String)string, (int)32);
        this.key = TextUtil.bytesToHexString((byte[])byArray2);
    }

    public final void parse(String string) throws IllegalArgumentException {
        try {
            int n = string.indexOf(":");
            int n2 = string.indexOf(":", n + 1);
            this.salt = string.substring(0, n);
            this.iterationCount = Integer.parseInt(string.substring(n + 1, n2));
            this.key = string.substring(n2 + 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("error parsing key");
        }
    }

    public final String getValue() {
        String string = this.salt + ':' + this.iterationCount + ':' + this.key;
        return string;
    }

    public final String getEncodingType() {
        return ENCODING_TYPE;
    }

    public final boolean isReversible() {
        return false;
    }

    public final boolean validate(String string) {
        try {
            byte[] byArray = Pbkdf2HmacSha256.deriveKey((byte[])ByteArrayUtil.hexStringToBytes((String)this.salt), (long)this.iterationCount, (String)string, (int)32);
            String string2 = TextUtil.bytesToHexString((byte[])byArray);
            return SecurityUtil.equals((String)string2, (String)this.key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public final String getEncodedValue() {
        return this.getValue();
    }

    public final String getSalt() {
        return this.salt;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public static final BPbkdf2HmacSha256PasswordEncoder makeFake(String string) {
        byte[] byArray = new byte[32];
        new SecureRandom().nextBytes(byArray);
        BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = new BPbkdf2HmacSha256PasswordEncoder();
        bPbkdf2HmacSha256PasswordEncoder.key = TextUtil.bytesToHexString((byte[])byArray);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("Sha-256");
            byte[] byArray2 = messageDigest.digest(string.getBytes());
            bPbkdf2HmacSha256PasswordEncoder.salt = TextUtil.bytesToHexString((byte[])byArray2);
            bPbkdf2HmacSha256PasswordEncoder.iterationCount = 4096;
            return bPbkdf2HmacSha256PasswordEncoder;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException(noSuchAlgorithmException.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$security$BPbkdf2HmacSha256PasswordEncoder;
        if (clazz == null) {
            clazz = class$javax$baja$security$BPbkdf2HmacSha256PasswordEncoder = BPbkdf2HmacSha256PasswordEncoder.class("[Ljavax.baja.security.BPbkdf2HmacSha256PasswordEncoder;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

