/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.util.LegacyStorageUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.SecureRandom;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.BITypeEncodable;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPassword
extends BSimple
implements BIComparable,
BIContextEncodable,
BITypeEncodable {
    public static final BPassword DEFAULT = new BPassword("");
    public static final Type TYPE;
    private BAbstractPasswordEncoder encoder;
    static /* synthetic */ Class class$javax$baja$security$BPassword;

    public static final BPassword make(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new BPassword(string);
    }

    public static final BPassword make(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        String string = new String(cArray);
        return BPassword.make(string);
    }

    public static final BPassword make(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        return new BPassword(string, string2);
    }

    public static final BPassword make(char[] cArray, String string) {
        if (cArray == null || string == null) {
            throw new NullPointerException();
        }
        String string2 = new String(cArray);
        return BPassword.make(string2, string);
    }

    public static final BPassword make(BAbstractPasswordEncoder bAbstractPasswordEncoder) {
        return new BPassword(bAbstractPasswordEncoder);
    }

    private final String stripEncodingType(String string) {
        int n = string.indexOf("encoded[");
        int n2 = string.indexOf("]=");
        if (n == 0 && n2 > 0) {
            return string.substring(n2 + 2);
        }
        return string;
    }

    private final String extractEncodingType(String string) {
        if (string.startsWith("encoded[")) {
            String[] stringArray = TextUtil.split((String)string.substring(8), (char)']');
            if (stringArray.length == 0) {
                throw new BajaRuntimeException("unrecognized encoding type");
            }
            return stringArray[0];
        }
        return null;
    }

    public final String getString() {
        return this.getValue();
    }

    public final String getValue() throws SecurityException {
        try {
            if (this.encoder.isReversible()) {
                return this.encoder.getValue();
            }
            byte[] byArray = new byte[16];
            new SecureRandom().nextBytes(byArray);
            return Base64.encode((byte[])byArray);
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    public final int hashCode() {
        return this.encoder.getEncodedValue().hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BPassword) {
            return this.encoder.getEncodedValue().equals(((BPassword)object).encoder.getEncodedValue());
        }
        return false;
    }

    public final int compareTo(Object object) {
        return 0;
    }

    public final boolean validate(String string) {
        try {
            return this.encoder.validate(string);
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    public final String toString(Context context) {
        return "--password--";
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final void encode(DataOutput dataOutput, Context context) throws IOException {
        dataOutput.writeUTF(this.encodeToString(context));
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        if (string.equals("")) {
            return DEFAULT;
        }
        return this.decodeFromString(string);
    }

    public final BObject decode(DataInput dataInput, Context context) throws IOException {
        String string = dataInput.readUTF();
        if (string.equals("")) {
            return DEFAULT;
        }
        return this.decodeFromString(string, context);
    }

    public final String encodeToString() throws IOException {
        try {
            return LegacyStorageUtil.encode((String)this.getPasswordEncoder().getPortableEncoding());
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public final String encodeToString(Context context) throws IOException {
        BString bString = null;
        BFacets bFacets = null;
        if (context != null) {
            bFacets = context.getFacets();
        }
        if (bFacets != null) {
            bString = (BString)bFacets.getFacet("encodingMode");
        }
        if (!this.getPasswordEncoder().isReversible() || bString != null && bString.equals(BString.make("encrypt"))) {
            return LegacyStorageUtil.encode((String)("encoded[" + this.encoder.getEncodingType() + "]=" + this.encoder.getEncodedValue()));
        }
        return this.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        return this.decodeFromString(string, null);
    }

    public final BObject decodeFromString(String string, Context context) throws IOException {
        if (string.equals("")) {
            return DEFAULT;
        }
        return BPassword.make(LegacyStorageUtil.decode((String)string));
    }

    public final String getEncodingType() {
        return this.encoder.getEncodingType();
    }

    public final BAbstractPasswordEncoder getPasswordEncoder() {
        return this.encoder;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BPassword(String string) {
        boolean bl = true;
        String string2 = this.extractEncodingType(string);
        if (string2 == null) {
            bl = false;
            string2 = "aes256/text";
        }
        try {
            this.encoder = BAbstractPasswordEncoder.make(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unrecognized encoding type: " + string2);
        }
        try {
            if (bl) {
                this.encoder.parse(this.stripEncodingType(string));
            } else {
                this.encoder.encode(string);
            }
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    private BPassword(String string, String string2) {
        try {
            this.encoder = BAbstractPasswordEncoder.make(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unrecognized encoding type: " + string2);
        }
        try {
            this.encoder.encode(string);
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    private BPassword(BAbstractPasswordEncoder bAbstractPasswordEncoder) {
        this.encoder = bAbstractPasswordEncoder;
    }

    static {
        Class clazz = class$javax$baja$security$BPassword;
        if (clazz == null) {
            clazz = class$javax$baja$security$BPassword = BPassword.class("[Ljavax.baja.security.BPassword;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

