/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class NavFileDecoder
extends XParser {
    static HashMap cache = new HashMap();
    BOrd baseOrd;

    public static BNavFileSpace load(BOrd bOrd) throws Exception {
        BObject bObject = bOrd.get();
        if (bObject instanceof BIFile) {
            return NavFileDecoder.load((BIFile)((Object)bObject));
        }
        throw new ClassCastException("Not IFile: " + bOrd + " -> " + bObject.getType());
    }

    public static BNavFileSpace load(BIFile bIFile) throws Exception {
        String string = bIFile.getAbsoluteOrd().toString();
        CacheItem cacheItem = (CacheItem)cache.get(string);
        if (cacheItem == null || cacheItem.isOutOfDate()) {
            cacheItem = new CacheItem();
            cacheItem.file = bIFile;
            cacheItem.lastModified = bIFile.getLastModified().getMillis();
            cacheItem.space = new NavFileDecoder(bIFile).decodeDocument();
            cache.put(string, cacheItem);
        }
        return cacheItem.space;
    }

    public BNavFileSpace decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNavFileSpace decodeDocument(boolean bl) throws Exception {
        BNavFileSpace bNavFileSpace;
        block5: {
            try {
                XElem xElem = this.parse();
                if (!xElem.name().equals("nav")) {
                    throw this.err("Root element must be \"nav\"", xElem);
                }
                String string = xElem.get("version");
                if (!string.equals("1.0")) {
                    throw this.err("Only version 1.0 is supported", xElem);
                }
                XElem xElem2 = xElem.elem("node");
                if (xElem2 == null) {
                    throw this.err("Missing root <node>", xElem);
                }
                bNavFileSpace = new BNavFileSpace(this.decodeNode(xElem2));
                Object var3_6 = null;
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_7 = null;
                    if (!bl) break block6;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return bNavFileSpace;
    }

    private final BNavFileNode decodeNode(XElem xElem) throws Exception {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        Object object3 = null;
        int n = 0;
        while (n < xElem.attrSize()) {
            object2 = xElem.attrName(n);
            object = xElem.attrValue(n);
            if (((String)object2).equals("name")) {
                string = object;
            } else if (((String)object2).equals("ord")) {
                string2 = object;
            } else if (((String)object2).equals("icon")) {
                object3 = object;
            }
            ++n;
        }
        BOrd bOrd = BOrd.make(this.baseOrd, string2);
        bOrd = bOrd.normalize();
        object2 = null;
        if (object3 != null) {
            object2 = ((String)object3).startsWith("module:") ? BIcon.make((String)object3) : BIcon.make(BOrd.make(this.baseOrd, (String)object3).normalize());
        }
        object = new BNavFileNode(string, bOrd, (BIcon)object2);
        XElem[] xElemArray = xElem.elems("node");
        int n2 = 0;
        while (n2 < xElemArray.length) {
            ((BNavContainer)object).addNavChild(this.decodeNode(xElemArray[n2]));
            ++n2;
        }
        return object;
    }

    XException err(String string, XElem xElem, Throwable throwable) {
        return new XException(string, xElem, throwable);
    }

    XException err(String string, XElem xElem) {
        return new XException(string, xElem);
    }

    public NavFileDecoder(BIFile bIFile) throws Exception {
        this(bIFile.getSession().getAbsoluteOrd(), new BufferedInputStream(bIFile.getInputStream()));
    }

    public NavFileDecoder(BOrd bOrd, InputStream inputStream) throws Exception {
        super(inputStream);
        this.baseOrd = bOrd;
    }

    static class CacheItem {
        BIFile file;
        long lastModified;
        BNavFileSpace space;

        boolean isOutOfDate() {
            boolean bl = false;
            if (this.lastModified != this.file.getLastModified().getMillis()) {
                bl = true;
            }
            return bl;
        }

        CacheItem() {
        }
    }
}

