/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.Path;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class NavEvent {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int RENAMED = 3;
    public static final int REORDERED = 4;
    public static final int REPLACED = 5;
    public static final int RECATEGORIZED = 6;
    private static String[] ID_STRINGS = new String[]{"-", "added", "removed", "renamed", "reordered", "replaced", "recategorized"};
    private int id;
    private BINavNode parent;
    private BOrd parentOrd;
    private String oldChildName;
    private String newChildName;
    private BOrd oldChildOrd;
    private BOrd newChildOrd;
    private String[] newOrder;
    private Context context;

    public static NavEvent makeAdded(BOrd bOrd, String string, Context context) {
        NavEvent navEvent = new NavEvent(1);
        navEvent.parentOrd = bOrd;
        navEvent.newChildName = string;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeAdded(BINavNode bINavNode, String string, Context context) {
        NavEvent navEvent = NavEvent.makeAdded(bINavNode.getNavOrd(), string, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent makeRemoved(BOrd bOrd, String string, Context context) {
        NavEvent navEvent = new NavEvent(2);
        navEvent.parentOrd = bOrd;
        navEvent.oldChildName = string;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeRemoved(BINavNode bINavNode, String string, Context context) {
        NavEvent navEvent = NavEvent.makeRemoved(bINavNode.getNavOrd(), string, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent makeRenamed(BOrd bOrd, String string, String string2, Context context) {
        NavEvent navEvent = new NavEvent(3);
        navEvent.parentOrd = bOrd;
        navEvent.oldChildName = string;
        navEvent.newChildName = string2;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeRenamed(BINavNode bINavNode, String string, String string2, Context context) {
        NavEvent navEvent = NavEvent.makeRenamed(bINavNode.getNavOrd(), string, string2, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent makeReordered(BOrd bOrd, String[] stringArray, Context context) {
        NavEvent navEvent = new NavEvent(4);
        navEvent.parentOrd = bOrd;
        navEvent.newOrder = stringArray;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeReordered(BINavNode bINavNode, String[] stringArray, Context context) {
        NavEvent navEvent = NavEvent.makeReordered(bINavNode.getNavOrd(), stringArray, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent makeReplaced(BOrd bOrd, String string, Context context) {
        NavEvent navEvent = new NavEvent(5);
        navEvent.parentOrd = bOrd;
        navEvent.oldChildName = string;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeReplaced(BINavNode bINavNode, String string, Context context) {
        NavEvent navEvent = NavEvent.makeReplaced(bINavNode.getNavOrd(), string, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent makeRecategorized(BOrd bOrd, String string, String string2, Context context) {
        NavEvent navEvent = new NavEvent(6);
        navEvent.parentOrd = bOrd;
        navEvent.oldChildName = string;
        navEvent.newChildName = string2;
        navEvent.context = context;
        return navEvent;
    }

    public static NavEvent makeRecategorized(BOrd bOrd, BCategoryMask bCategoryMask, BCategoryMask bCategoryMask2, Context context) {
        return NavEvent.makeRecategorized(bOrd, bCategoryMask.encodeToString(), bCategoryMask2.encodeToString(), context);
    }

    public static NavEvent makeRecategorized(BINavNode bINavNode, BCategoryMask bCategoryMask, BCategoryMask bCategoryMask2, Context context) {
        NavEvent navEvent = NavEvent.makeRecategorized(bINavNode.getNavOrd(), bCategoryMask, bCategoryMask2, context);
        navEvent.parent = bINavNode;
        return navEvent;
    }

    public static NavEvent make(NavEvent navEvent, BOrd bOrd) {
        NavEvent navEvent2 = new NavEvent(navEvent.id);
        navEvent2.parentOrd = bOrd;
        navEvent2.oldChildName = navEvent.oldChildName;
        navEvent2.newChildName = navEvent.newChildName;
        navEvent2.newOrder = navEvent.newOrder;
        navEvent2.context = navEvent.context;
        return navEvent2;
    }

    public int getId() {
        return this.id;
    }

    public BOrd getParentOrd() {
        return this.parentOrd;
    }

    public BINavNode getParent() {
        return this.parent;
    }

    public String getOldChildName() {
        return this.oldChildName;
    }

    public String getNewChildName() {
        return this.newChildName;
    }

    public BOrd getOldChildOrd() {
        if (this.oldChildOrd == null) {
            this.oldChildOrd = this.toChildOrd(this.oldChildName);
        }
        return this.oldChildOrd;
    }

    public BOrd getNewChildOrd() {
        if (this.newChildOrd == null) {
            this.newChildOrd = this.toChildOrd(this.newChildName);
        }
        return this.newChildOrd;
    }

    public String[] getNewOrder() {
        return this.newOrder;
    }

    public Context getContext() {
        return this.context;
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return BFacets.make(this.context.getFacets());
        }
        return BFacets.NULL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NavEvent[");
        stringBuffer.append(ID_STRINGS[this.id]).append(" p=").append(this.parentOrd);
        if (this.oldChildName != null) {
            stringBuffer.append("  old=").append(this.oldChildName);
        }
        if (this.newChildName != null) {
            stringBuffer.append("  new=").append(this.newChildName);
        }
        if (this.newOrder != null) {
            stringBuffer.append("  order.len=").append(this.newOrder.length);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private final BOrd toChildOrd(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.parentOrd.toString();
        OrdQuery[] ordQueryArray = this.parentOrd.parse();
        OrdQuery ordQuery = ordQueryArray[ordQueryArray.length - 1];
        if (ordQuery instanceof Path) {
            Path path = (Path)((Object)ordQuery);
            if (path.depth() == 0) {
                return BOrd.make(string2 + string);
            }
            return BOrd.make(string2 + '/' + string);
        }
        return BOrd.make(string2 + '|' + string + ':');
    }

    private NavEvent(int n) {
        this.id = n;
    }
}

