/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.util.HashMap;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;

public class ViewQuery
implements OrdQuery {
    private static final String[] NO_NAMES = new String[0];
    private String scheme;
    private String body;
    private String viewId;
    private HashMap parameters;

    public String getViewId() {
        return this.viewId;
    }

    public String[] getParameterNames() {
        if (this.parameters == null) {
            return NO_NAMES;
        }
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String getParameter(String string) {
        String string2 = this.getParameter(string, null);
        if (string2 == null) {
            throw new IllegalArgumentException("Missing parameter \"" + string + '\"');
        }
        return string2;
    }

    public String getParameter(String string, String string2) {
        String string3;
        if (this.parameters != null && (string3 = (String)this.parameters.get(string)) != null) {
            return string3;
        }
        return string2;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
        if (ordQueryList.isSameScheme(n, n + 1)) {
            ViewQuery viewQuery = (ViewQuery)ordQueryList.get(n + 1);
            ordQueryList.merge(n, this.merge(viewQuery));
        } else if (n < ordQueryList.size() - 1) {
            ordQueryList.remove(n);
        }
    }

    public ViewQuery merge(ViewQuery viewQuery) {
        String[] stringArray;
        String string = null;
        if (this.viewId != null && viewQuery.viewId == null) {
            string = this.viewId;
        }
        if (viewQuery.viewId != null) {
            string = viewQuery.viewId;
        }
        HashMap hashMap = null;
        if (this.parameters != null || viewQuery.parameters != null) {
            HashMap hashMap2 = hashMap = this.parameters != null ? this.parameters : new HashMap();
            if (viewQuery.parameters != null) {
                stringArray = viewQuery.getParameterNames();
                int n = 0;
                while (n < stringArray.length) {
                    hashMap.put(stringArray[n], viewQuery.getParameter(stringArray[n]));
                    ++n;
                }
            }
        }
        stringArray = new StringBuffer();
        if (string != null) {
            stringArray.append(string);
        }
        if (hashMap != null) {
            stringArray.append('?');
            String[] stringArray2 = hashMap.keySet().toArray(new String[hashMap.size()]);
            int n = 0;
            while (n < stringArray2.length) {
                stringArray.append(stringArray2[n]).append('=').append(hashMap.get(stringArray2[n])).append(';');
                ++n;
            }
        }
        return new ViewQuery(this.scheme, stringArray.toString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            String string = this.body;
            int n = string.length();
            if (n == 0) {
                throw new SyntaxException("no body");
            }
            int n2 = string.indexOf(63);
            if (n2 < 0) {
                this.viewId = string;
            } else {
                this.viewId = string.substring(0, n2).trim();
                this.parseParams(n2);
            }
            int n3 = this.viewId.length();
            if (n3 == 0) {
                this.viewId = null;
            } else {
                int n4 = 0;
                while (n4 < n3) {
                    char c = this.viewId.charAt(n4);
                    if (c == '|' || c == ';' || c == '=') {
                        throw new SyntaxException("invalid view id char '" + (char)c + '\'');
                    }
                    ++n4;
                }
            }
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Throwable throwable) {
            throw new SyntaxException(throwable);
        }
    }

    private final void parseParams(int n) {
        String string = this.body;
        int n2 = string.length();
        int n3 = -1;
        int n4 = n;
        int n5 = n + 1;
        while (n5 < n2) {
            char c = string.charAt(n5);
            if (c == ';') {
                this.addParam(n4, n3, n5);
                n3 = -1;
                n4 = n5;
            } else if (c == '=') {
                n3 = n5;
            } else if (c == '%' || c == '|' || c == '?') {
                throw new SyntaxException("invalid param char '" + (char)c + '\'');
            }
            ++n5;
        }
        if (n4 < n2 - 1) {
            this.addParam(n4, n3, n2);
        }
    }

    private final void addParam(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new SyntaxException("invalid param, missing =");
        }
        String string = this.body.substring(n + 1, n2).trim();
        String string2 = this.body.substring(n2 + 1, n3).trim();
        if (string.length() == 0) {
            throw new SyntaxException("missing name");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(string, string2);
    }

    public ViewQuery(String string, String string2) throws SyntaxException {
        this.scheme = TextUtil.toLowerCase((String)string).trim();
        this.body = string2.trim();
        this.parse();
    }

    public ViewQuery(String string) throws SyntaxException {
        this.scheme = "view";
        this.body = string.trim();
        this.parse();
    }
}

