/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.util.EscUtil;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.IllegalNameException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SlotPath
implements OrdQuery,
Path {
    private static final String[] NO_NAMES = new String[0];
    private String scheme;
    private String body;
    private boolean abs;
    private int backupDepth;
    private String[] names;

    protected SlotPath makeSlotPath(String string, String string2) {
        return new SlotPath(string, string2);
    }

    public boolean isAbsolute() {
        return this.abs;
    }

    public boolean isRelative() {
        return this.abs ^ true;
    }

    public int getBackupDepth() {
        return this.backupDepth;
    }

    public Path getParentPath() {
        return this.getParent();
    }

    public SlotPath getParent() {
        int n;
        if (this.names.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAbsolute()) {
            stringBuffer.append('/');
        } else {
            n = this.getBackupDepth();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("../");
                ++n2;
            }
        }
        n = 0;
        while (n < this.names.length - 1) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.names[n]);
            ++n;
        }
        return this.makeSlotPath(this.scheme, stringBuffer.toString());
    }

    public int depth() {
        return this.names.length;
    }

    public String nameAt(int n) {
        return this.names[n];
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    protected boolean isValidPathName(String string) {
        return SlotPath.isValidName(string);
    }

    public static boolean isValidName(String string) {
        return EscUtil.slot.isValid(string);
    }

    public static void verifyValidName(String string) {
        if (!SlotPath.isValidName(string)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{string});
        }
    }

    public static String escape(String string) {
        return EscUtil.slot.escape(string);
    }

    public static String unescape(String string) {
        return EscUtil.slot.unescape(string);
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBody() {
        return this.body;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
        if (ordQueryList.isSameScheme(n, n + 1)) {
            SlotPath slotPath = (SlotPath)ordQueryList.get(n + 1);
            ordQueryList.merge(n, this.merge(slotPath));
        }
    }

    public SlotPath merge(SlotPath slotPath) {
        int n;
        int n2;
        if (slotPath.isAbsolute()) {
            return slotPath;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.abs) {
            stringBuffer.append('/');
        }
        if (slotPath.getBackupDepth() > 0 && slotPath.getBackupDepth() > this.depth()) {
            if (this.abs) {
                throw new SyntaxException("Invalid merge " + this + " + " + slotPath);
            }
            n2 = slotPath.getBackupDepth() - this.depth() + this.getBackupDepth();
            n = 0;
            while (n < n2) {
                stringBuffer.append("../");
                ++n;
            }
        }
        n2 = 0;
        n = 0;
        while (n < this.depth() - slotPath.getBackupDepth()) {
            if (n2 != 0) {
                stringBuffer.append('/');
            } else {
                n2 = 1;
            }
            stringBuffer.append(this.nameAt(n));
            ++n;
        }
        n = 0;
        while (n < slotPath.depth()) {
            if (n2 != 0) {
                stringBuffer.append('/');
            } else {
                n2 = 1;
            }
            stringBuffer.append(slotPath.nameAt(n));
            ++n;
        }
        return this.makeSlotPath(this.scheme, stringBuffer.toString());
    }

    public String toDisplayString() {
        return SlotPath.unescape(this.body);
    }

    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            if (this.body.length() == 0) {
                return;
            }
            int n = 0;
            char c = this.body.charAt(0);
            if (c == '/') {
                this.abs = true;
                n = 1;
            } else if (c == '.') {
                n = this.parseBackup();
            }
            this.parseNames(n);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Throwable throwable) {
            throw new SyntaxException(throwable);
        }
    }

    void parseNames(int n) {
        String string = this.body;
        int n2 = string.length();
        if (n >= n2) {
            return;
        }
        if (string.charAt(n2 - 1) == '/') {
            throw new SyntaxException("Trailing slash");
        }
        String[] stringArray = new String[64];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '/') {
                if (n4 == n) {
                    throw new SyntaxException("Illegal double slashes");
                }
                String string2 = string.substring(n, n4);
                if (!this.isValidPathName(string2)) {
                    throw new SyntaxException("Invalid name in path");
                }
                stringArray[n3++] = string2;
                n = n4 + 1;
            }
            ++n4;
        }
        String string3 = string.substring(n, n2);
        if (!this.isValidPathName(string3)) {
            throw new SyntaxException("Invalid name in path");
        }
        stringArray[n3++] = string3;
        this.names = new String[n3];
        System.arraycopy(stringArray, 0, this.names, 0, n3);
    }

    int parseBackup() {
        String string = this.body;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string.charAt(n2);
            int n4 = n2 + 1 < n ? (int)string.charAt(n2 + 1) : -1;
            int n5 = n3 = n2 + 2 < n ? (int)string.charAt(n2 + 2) : 47;
            if (c != '.') {
                return n2;
            }
            if (n4 != 46 || n3 != 47) {
                if (this.isValidPathName(String.valueOf((int)c))) {
                    return n2;
                }
                throw new SyntaxException("Expecting ../ backup");
            }
            ++this.backupDepth;
            n2 += 3;
        }
        return n;
    }

    private final /* synthetic */ void this() {
        this.names = NO_NAMES;
    }

    public SlotPath(String string, String string2) throws SyntaxException {
        this.this();
        this.scheme = TextUtil.toLowerCase((String)string).trim();
        this.body = string2.trim();
        this.parse();
    }

    public SlotPath(String string, String[] stringArray) throws SyntaxException {
        this.this();
        this.scheme = TextUtil.toLowerCase((String)string).trim();
        this.abs = true;
        this.backupDepth = 0;
        this.names = stringArray;
        if (stringArray.length == 0) {
            this.body = "/";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append('/').append(stringArray[n]);
                ++n;
            }
            this.body = stringBuffer.toString();
        }
    }

    public SlotPath(String string) throws SyntaxException {
        this.this();
        this.scheme = "slot";
        this.body = string.trim();
        this.parse();
    }
}

