/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.io.net.BasicClientSocketFactory;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.util.IFoxSession;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import javax.baja.io.net.IClientSocketFactory;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIpHost
extends BHost {
    public static final Type TYPE;
    static final int CONNECTION_TIMEOUT;
    BOrd ord;
    InetAddress inetAddress;
    String navDisplayName;
    boolean isNumericAddr;
    static /* synthetic */ Class class$javax$baja$naming$BIpHost;

    public boolean isNumericAddress() {
        return this.isNumericAddr;
    }

    public String getNumericAddress(boolean bl) throws IOException {
        if (this.isNumericAddr) {
            return this.hostname;
        }
        if (this.inetAddress != null) {
            return this.inetAddress.getHostAddress();
        }
        if (!bl) {
            return null;
        }
        return this.getInetAddress().getHostAddress();
    }

    public InetAddress getInetAddress() throws IOException {
        if (this.inetAddress == null) {
            this.inetAddress = InetAddress.getByName(this.getHostname());
        }
        return this.inetAddress;
    }

    public BOrd getAbsoluteOrd() {
        return this.ord;
    }

    public Socket openSocket(int n) throws IOException {
        if (!this.isNumericAddr) {
            this.inetAddress = null;
            this.navDisplayName = null;
        }
        IClientSocketFactory iClientSocketFactory = BasicClientSocketFactory.getInstance();
        return iClientSocketFactory.createSocket(this.getInetAddress(), n);
    }

    public Socket openSocket(int n, int n2) throws IOException {
        if (!this.isNumericAddr) {
            this.inetAddress = null;
            this.navDisplayName = null;
        }
        IClientSocketFactory iClientSocketFactory = BasicClientSocketFactory.getInstance();
        return iClientSocketFactory.createSocket(this.getInetAddress(), n, n2);
    }

    public Socket openSocket(int n, IClientSocketFactory iClientSocketFactory) throws IOException {
        return iClientSocketFactory.createSocket(this.getInetAddress(), n);
    }

    public Socket openSocket(int n, IClientSocketFactory iClientSocketFactory, int n2) throws IOException {
        return iClientSocketFactory.createSocket(this.getInetAddress(), n, n2);
    }

    public DatagramSocket openDatagramSocket(int n) throws IOException {
        return new DatagramSocket(n, this.getInetAddress());
    }

    public String getNavDisplayName(Context context) {
        if (this.navDisplayName != null) {
            return this.appendStationName(this.navDisplayName);
        }
        if (this.inetAddress == null) {
            return this.appendStationName(this.hostname);
        }
        try {
            String string;
            String string2;
            this.navDisplayName = this.isNumericAddr ? this.hostname : ((string2 = this.inetAddress.getHostName()).equals(string = this.inetAddress.getHostAddress()) ? string2 : string2 + " : " + string);
        }
        catch (Exception exception) {
            this.navDisplayName = this.hostname;
        }
        return this.appendStationName(this.navDisplayName);
    }

    String appendStationName(String string) {
        try {
            BINavNode[] bINavNodeArray = this.getNavChildren();
            int n = 0;
            while (n < bINavNodeArray.length) {
                String string2;
                if (bINavNodeArray[n] instanceof IFoxSession && (string2 = ((IFoxSession)((Object)bINavNodeArray[n])).getStationName()) != null) {
                    return string + " (" + string2 + ')';
                }
                ++n;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Testing socket times");
        long l = Clock.ticks();
        try {
            new BIpHost(stringArray[0]).openSocket(1911);
        }
        catch (Exception exception) {}
        long l2 = Clock.ticks();
        System.out.println("Opened: " + (l2 - l) + "ms");
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BIpHost(String string) {
        super(string);
        this.ord = BOrd.make("ip:" + string);
        this.isNumericAddr = IPAddressUtil.isNumericAddr((String)string);
    }

    static {
        Class clazz = class$javax$baja$naming$BIpHost;
        if (clazz == null) {
            clazz = class$javax$baja$naming$BIpHost = BIpHost.class("[Ljavax.baja.naming.BIpHost;", false);
        }
        TYPE = Sys.loadType(clazz);
        CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("ipHost.connectionTimeout", "15000"));
    }
}

