/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.io.net.IClientSocketFactory;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHost
extends BNavContainer {
    static final BIcon iconConnected = BIcon.std("host.png");
    static final BIcon iconDisconnected = BIcon.std("hostDisconnected.png");
    public static final Type TYPE;
    static final HashMap cache;
    static int cachedLocalHostCount;
    String hostname;
    static /* synthetic */ Class class$javax$baja$naming$BHost;

    public static BHost getHost(String string) {
        if (string.length() == 0) {
            return BLocalHost.INSTANCE;
        }
        String string2 = TextUtil.toLowerCase((String)string);
        return (BHost)cache.get(string2);
    }

    public static BHost[] getAllHosts() {
        BHost[] bHostArray = BHost.getRemoteHosts();
        BHost[] bHostArray2 = new BHost[bHostArray.length + 1];
        bHostArray2[0] = BLocalHost.INSTANCE;
        System.arraycopy(bHostArray, 0, bHostArray2, 1, bHostArray.length);
        return bHostArray2;
    }

    public static BHost[] getRemoteHosts() {
        Object[] objectArray = new BHost[cache.size() - cachedLocalHostCount];
        Object[] objectArray2 = new String[objectArray.length];
        Iterator iterator = cache.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            BHost bHost = (BHost)iterator.next();
            if (bHost == BLocalHost.INSTANCE) continue;
            objectArray[n] = bHost;
            objectArray2[n] = bHost.hostname;
            ++n;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
        return objectArray;
    }

    public static void mount(BHost bHost) {
        String string = TextUtil.toLowerCase((String)bHost.getHostname());
        if (cache.get(string) != null) {
            throw new IllegalArgumentException("Already mounted " + string);
        }
        cache.put(string, bHost);
        BNavRoot.INSTANCE.addNavChild(bHost);
    }

    public static void unmount(BHost bHost) {
        String string = TextUtil.toLowerCase((String)bHost.getHostname());
        cache.remove(string);
        BNavRoot.INSTANCE.removeNavChild(bHost);
    }

    public String getHostname() {
        return this.hostname;
    }

    public BISession[] getChildSessions() {
        ArrayList<BINavNode> arrayList = new ArrayList<BINavNode>();
        BINavNode[] bINavNodeArray = this.getNavChildren();
        int n = 0;
        while (n < bINavNodeArray.length) {
            if (bINavNodeArray[n] instanceof BISession) {
                arrayList.add(bINavNodeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new BISession[arrayList.size()]);
    }

    public abstract Socket openSocket(int var1) throws IOException;

    public Socket openSocket(int n, int n2) throws IOException {
        return this.openSocket(n);
    }

    public abstract Socket openSocket(int var1, IClientSocketFactory var2) throws IOException;

    public abstract Socket openSocket(int var1, IClientSocketFactory var2, int var3) throws IOException;

    public abstract DatagramSocket openDatagramSocket(int var1) throws IOException;

    public String toString(Context context) {
        return this.hostname;
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.getConnectedSessionCount() > 0) {
            bl = true;
        }
        return bl;
    }

    public int getConnectedSessionCount() {
        int n = 0;
        BINavNode[] bINavNodeArray = this.getNavChildren();
        int n2 = 0;
        while (n2 < bINavNodeArray.length) {
            if (bINavNodeArray[n2] instanceof BISession && ((BISession)bINavNodeArray[n2]).isConnected()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public final void disconnect() {
        this.disconnectAllSessions();
        this.doDisconnect();
    }

    protected void doDisconnect() {
    }

    public void disconnectAllSessions() {
        BISession[] bISessionArray = this.getChildSessions();
        int n = 0;
        while (n < bISessionArray.length) {
            bISessionArray[n].disconnect();
            ++n;
        }
    }

    public final void close() {
        this.closeAllSessions();
        this.doClose();
        BHost.unmount(this);
    }

    protected void doClose() {
    }

    public void closeAllSessions() {
        BISession[] bISessionArray = this.getChildSessions();
        int n = 0;
        while (n < bISessionArray.length) {
            bISessionArray[n].close();
            ++n;
        }
    }

    public abstract BOrd getAbsoluteOrd();

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public void addNavChild(BINavNode bINavNode) {
        super.addNavChild(bINavNode);
        this.sortNavChildren();
    }

    public void removeNavChild(BINavNode bINavNode) {
        super.removeNavChild(bINavNode);
        this.sortNavChildren();
    }

    void sortNavChildren() {
        Object[] objectArray = this.getNavChildren();
        Object[] objectArray2 = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            objectArray2[n] = object instanceof BISession ? object.getType().getTypeName() : "";
            ++n;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
        this.reorderNavChildren((BINavNode[])objectArray);
    }

    public BIcon getIcon() {
        return this.isConnected() ? iconConnected : iconDisconnected;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHost(String string) {
        super(string);
        this.hostname = string;
    }

    static {
        Class clazz = class$javax$baja$naming$BHost;
        if (clazz == null) {
            clazz = class$javax$baja$naming$BHost = BHost.class("[Ljavax.baja.naming.BHost;", false);
        }
        TYPE = Sys.loadType(clazz);
        cache = new HashMap();
        cachedLocalHostCount = 0;
    }
}

