/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.log;

import com.tridium.util.ThrowableUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.log.LogHandler;
import javax.baja.log.LogRecord;
import javax.baja.nre.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConsoleLogHandler
implements LogHandler {
    private DateFormat format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(LogRecord logRecord) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.write(System.out, logRecord);
            return;
        }
    }

    public void write(PrintStream printStream, LogRecord logRecord) {
        switch (logRecord.severity) {
            case 3: {
                printStream.print("ERROR [");
                break;
            }
            case 2: {
                printStream.print("WARNING [");
                break;
            }
            case 1: {
                printStream.print("MESSAGE [");
                break;
            }
            case 0: {
                printStream.print("TRACE [");
                break;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(this.format.format(new Date(logRecord.timestamp)));
        stringBuffer.append("][").append(logRecord.logName);
        stringBuffer.append("] ");
        if (logRecord.message != null && logRecord.message.length() > 0) {
            printStream.print(stringBuffer.toString());
            printStream.println(logRecord.message);
        }
        if (logRecord.buffer != null && logRecord.buffer.length > 0) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ByteArrayUtil.hexDump((String)stringBuffer.toString(), (PrintWriter)printWriter, (byte[])logRecord.buffer, (int)0, (int)logRecord.buffer.length);
        }
        ThrowableUtil.dump(printStream, logRecord.exception);
    }

    private final /* synthetic */ void this() {
        this.format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    }

    public ConsoleLogHandler() {
        this.this();
    }
}

