/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.SimpleFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueDocDecoder {
    private static final Map typeSwapMap = new HashMap();
    private static final boolean decodeTypeSwap;
    private SimpleFactory simpleFactory;
    protected final IDecoderPlugin plugin;
    private Context context;

    public static final BValue unmarshal(String string) throws Exception {
        return BogDecoderPlugin.unmarshal(string);
    }

    public static final BValue unmarshal(String string, ITypeResolver iTypeResolver) throws Exception {
        return BogDecoderPlugin.unmarshal(string, iTypeResolver);
    }

    public final ITypeResolver getTypeResolver() {
        return this.plugin.getTypeResolver();
    }

    public final void setTypeResolver(ITypeResolver iTypeResolver) {
        this.plugin.setTypeResolver(iTypeResolver);
    }

    public BValue decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BValue decodeDocument(boolean bl) throws Exception {
        try {
            BValue bValue = this.plugin.decodeDocument(this);
            Object var3_3 = null;
            if (bl) {
                this.plugin.close();
            }
            return bValue;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_4 = null;
                if (!bl) break block3;
                this.plugin.close();
            }
            throw throwable;
        }
    }

    public BValue decode() throws Exception {
        return this.parseSlot(null, true);
    }

    public final IDecoderPlugin getPlugin() {
        return this.plugin;
    }

    public final IElement elem() {
        return this.plugin.elem();
    }

    public final int next() throws Exception {
        return this.plugin.next();
    }

    public final void skip() throws Exception {
        this.plugin.skip();
    }

    public final void skip(int n) throws Exception {
        this.plugin.skip(n);
    }

    public final int type() {
        return this.plugin.type();
    }

    public final int line() {
        return this.plugin.line();
    }

    public final int column() {
        return this.plugin.column();
    }

    public final void close() {
        this.plugin.close();
    }

    public final int depth() {
        return this.plugin.depth();
    }

    public final String getEncoding() throws IOException {
        return this.plugin.getEncoding();
    }

    public final boolean isZipped() throws IOException {
        return this.plugin.isZipped();
    }

    public final IElement parse() throws Exception {
        return this.plugin.parse();
    }

    public IElement parse(boolean bl) throws Exception {
        return this.plugin.parse(bl);
    }

    public final IElement parseCurrent() throws Exception {
        return this.plugin.parseCurrent();
    }

    public final IElement parseCurrent(boolean bl) throws Exception {
        return this.plugin.parseCurrent(bl);
    }

    public final RuntimeException err(String string, Throwable throwable) {
        return this.plugin.err(string, throwable);
    }

    public final RuntimeException err(String string) {
        return this.plugin.err(string);
    }

    public final void warningAndSkip(String string) throws RuntimeException {
        this.plugin.warningAndSkip(string);
    }

    public final void warning(String string) {
        this.plugin.warning(string);
    }

    public final Log getLog() {
        return this.plugin.getLog();
    }

    public final void setLog(Log log) {
        this.plugin.setLog(log);
    }

    public final int getWarningCount() {
        return this.plugin.getWarningCount();
    }

    protected void decodingComponent(BComponent bComponent) throws Exception {
        this.plugin.warningAndSkip("Unknown element <" + this.plugin.elem().name() + "> for decodingComponent");
    }

    private final void parseSlots(BObject bObject) throws Exception {
        while (true) {
            int n;
            if ((n = this.next()) == -1) {
                throw new EOFException();
            }
            if (n == 2) {
                return;
            }
            if (n != 1) {
                throw this.err("Expected element start");
            }
            this.parseSlot((BComplex)bObject, false);
        }
    }

    private final BValue parseSlot(BComplex bComplex, boolean bl) throws Exception {
        Object object;
        Object object2;
        if (this.type() != 1) {
            throw this.err("Expected element start (" + this.type() + ')');
        }
        IElement iElement = this.plugin.elem();
        String string = iElement.name().intern();
        if (string != "p" && string != "a" && string != "t") {
            if (bComplex instanceof BComponent) {
                this.decodingComponent((BComponent)bComplex);
            } else {
                this.plugin.warningAndSkip("Unknown element <" + string + '>');
            }
            if (bl) {
                throw this.err("Unknown element <" + string + '>');
            }
            return null;
        }
        String string2 = null;
        String string3 = null;
        Object object3 = null;
        Object object4 = null;
        String string4 = null;
        Object object5 = null;
        BFacets bFacets = BFacets.NULL;
        Object object6 = null;
        boolean bl2 = false;
        int n = iElement.attrSize();
        int n2 = 0;
        while (n2 < n) {
            object2 = iElement.attrName(n2);
            object = iElement.attrValue(n2);
            if (object2 == "n") {
                string2 = object;
            } else if (object2 == "h") {
                string3 = object;
            } else if (object2 == "v") {
                string4 = object;
            } else if (object2 == "t") {
                object4 = object;
            } else if (object2 == "m") {
                object3 = object;
            } else if (object2 == "f") {
                object5 = object;
            } else if (object2 == "x") {
                bFacets = this.decodeFacets((String)object);
            } else if (object2 == "c") {
                object6 = object;
            } else if (((String)object2).equals("stub")) {
                bl2 = ((String)object).equals("true");
            }
            ++n2;
        }
        n2 = this.decodeFlags((String)object5);
        if (object3 != null && this.plugin.getTypeResolver().loadModule(this, bComplex, string2, (String)object3, (String)object4) == null) {
            try {
                this.plugin.skip();
            }
            catch (RuntimeException runtimeException) {
                this.plugin.warning("Missing module " + (String)(((String)object3).indexOf(61) != -1 ? ((String)object3).substring(((String)object3).indexOf(61) + 1) : object3));
                throw runtimeException;
            }
            catch (Exception exception) {
                this.plugin.warning("Missing module " + (String)object3);
                throw this.plugin.err("Missing module " + (String)(((String)object3).indexOf(61) != -1 ? ((String)object3).substring(((String)object3).indexOf(61) + 1) : object3));
            }
            if (bl) {
                throw this.plugin.err("Missing module " + (String)(((String)object3).indexOf(61) != -1 ? ((String)object3).substring(((String)object3).indexOf(61) + 1) : object3));
            }
            if (this.plugin.getLog().isTraceOn()) {
                this.plugin.getLog().trace("Missing module: " + (String)object3);
            }
        }
        object2 = null;
        if (bComplex != null) {
            if (string2 == null) {
                throw this.plugin.err("Missing \"n\" name attribute");
            }
            object2 = bComplex.getSlot(string2);
        }
        if (object2 != null) {
            if (object5 != null) {
                bComplex.setFlags((Slot)object2, n2, Context.decoding);
            }
            if (!object2.isProperty()) {
                this.plugin.skip();
                return null;
            }
        } else {
            if (string == "a") {
                this.plugin.warningAndSkip("Missing frozen action: " + string2);
                return null;
            }
            if (string == "t") {
                this.plugin.warningAndSkip("Missing frozen topic: " + string2);
                return null;
            }
        }
        if (this.decodePrimitive(bComplex, (Property)(object = (Property)object2), string4)) {
            if (bl) {
                throw this.err("Incountered unexpected primitive");
            }
            return null;
        }
        BValue bValue = this.plugin.getTypeResolver().newInstance(this, bComplex, string2, (Property)object, (String)object4);
        if (bValue == null) {
            if (bl) {
                throw this.err("Unable to instantiate " + (String)(((String)object4).indexOf(58) != -1 ? ((String)object4).substring(((String)object4).indexOf(58) + 1) : object4));
            }
            return null;
        }
        if (bValue.isSimple() && string4 != null) {
            if (this.isTypeBlackListed(bValue.getType())) {
                throw this.err("Cannot decode blacklisted Simple Type: " + bValue.getType());
            }
            bValue = this.decodeSimple(bValue, string4);
        }
        if (bValue.isComponent()) {
            ((ComponentSlotMap)bValue.fw(1)).setHandle(string3);
            if (!bl2) {
                ((ComponentSlotMap)bValue.fw(1)).setBrokerPropsLoaded(true);
            }
            if (object6 != null) {
                ((BComponent)bValue).setCategoryMask(BCategoryMask.make((String)object6), Context.decoding);
            }
        }
        if (bComplex != null) {
            if (object != null) {
                if (!object.isFrozen()) {
                    throw this.plugin.err("Duplicate slot " + bComplex.getType().getTypeName() + '.' + string2);
                }
                try {
                    bComplex.set((Property)object, bValue, Context.decoding);
                }
                catch (Exception exception) {
                    this.plugin.warningAndSkip("Cannot set property " + bComplex.getType().getTypeName() + '.' + string2 + ": " + exception);
                }
            } else if (bComplex.isComponent()) {
                bComplex.asComponent().add(string2, bValue, n2, bFacets, Context.decoding);
            } else {
                this.plugin.warningAndSkip("Missing slot " + bComplex.getType().getTypeName() + '.' + string2);
            }
        }
        this.parseSlots(bValue);
        return bValue;
    }

    private final boolean decodePrimitive(BComplex bComplex, Property property, String string) throws Exception {
        if (property == null || string == null) {
            return false;
        }
        if (property.getTypeAccess() == 7) {
            return false;
        }
        switch (property.getTypeAccess()) {
            case 0: {
                bComplex.setBoolean(property, BBoolean.decode(string), Context.decoding);
                break;
            }
            case 2: {
                bComplex.setInt(property, BInteger.decode(string), Context.decoding);
                break;
            }
            case 3: {
                bComplex.setLong(property, BLong.decode(string), Context.decoding);
                break;
            }
            case 4: {
                bComplex.setFloat(property, BFloat.decode(string), Context.decoding);
                break;
            }
            case 5: {
                bComplex.setDouble(property, BDouble.decode(string), Context.decoding);
                break;
            }
            case 6: {
                bComplex.setString(property, string, Context.decoding);
                break;
            }
            default: {
                throw new IllegalStateException("" + property.getTypeAccess());
            }
        }
        int n = this.next();
        if (n != 2) {
            throw this.err("Expecting end of p element for simple property " + property.getName());
        }
        return true;
    }

    protected BSimple decodeSimple(BObject bObject, String string) {
        try {
            return this.simpleFactory.make(bObject.getType(), string, this.context);
        }
        catch (Exception exception) {
            throw this.plugin.err("Invalid " + bObject.getType().getTypeName() + ": '" + string + '\'', exception);
        }
    }

    private final int decodeFlags(String string) {
        if (string == null) {
            return 0;
        }
        return Flags.decodeFromString(string);
    }

    private final BFacets decodeFacets(String string) {
        try {
            if (string == null) {
                return BFacets.NULL;
            }
            return (BFacets)this.simpleFactory.make(BFacets.TYPE, string, this.context);
        }
        catch (Exception exception) {
            throw this.plugin.err("Invalid facets " + string, exception);
        }
    }

    public boolean isTypeBlackListed(Type type) {
        return false;
    }

    static final BValue typeResolverNewInstance(NModule nModule, String string) {
        Type type;
        try {
            type = nModule.getType(string);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            if (decodeTypeSwap) {
                String string2 = (String)typeSwapMap.get(nModule.getModuleName() + ':' + string);
                if (string2 != null) {
                    type = Sys.getType(string2);
                }
                throw typeNotFoundException;
            }
            throw typeNotFoundException;
        }
        return (BValue)type.getInstance();
    }

    private final /* synthetic */ void this() {
        this.simpleFactory = new SimpleFactory();
        this.context = null;
    }

    public ValueDocDecoder(IDecoderPlugin iDecoderPlugin) throws Exception {
        this.this();
        this.plugin = iDecoderPlugin;
    }

    public ValueDocDecoder(BOrd bOrd) throws Exception {
        this(new BogDecoderPlugin(bOrd));
    }

    public ValueDocDecoder(BIFile bIFile) throws Exception {
        this(new BogDecoderPlugin(bIFile));
    }

    public ValueDocDecoder(File file) throws Exception {
        this(new BogDecoderPlugin(file));
    }

    public ValueDocDecoder(InputStream inputStream) throws Exception {
        this(new BogDecoderPlugin(inputStream));
    }

    static {
        typeSwapMap.put("niagaraDriver:NiagaraVirtualGateway", "niagaraDriver:NiagaraVirtualDeviceExt");
        decodeTypeSwap = System.getProperty("niagara.decodeTypeSwap", "true").equals("true");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BogDecoderPlugin
    implements IDecoderPlugin {
        public static final ITypeResolver defaultTypeResolver = new BogTypeResolver();
        private static final Log defaultLog = Log.getLog("sys.xml");
        private final XParser parser;
        private HashMap modules;
        private ITypeResolver typeResolver;
        private Log log;
        private int warningCount;

        public final BValue decodeDocument(ValueDocDecoder valueDocDecoder) throws Exception {
            this.next();
            IElement iElement = this.elem();
            if (!iElement.name().equals("bajaObjectGraph")) {
                throw this.err("Root element must be \"bajaObjectGraph\"");
            }
            String string = iElement.get("version");
            if (!string.equals("1.0") && !string.equals("1.1")) {
                throw this.err("Only versions 1.0 and 1.1 are supported");
            }
            this.next();
            BValue bValue = valueDocDecoder.decode();
            this.next();
            if (this.type() != 2 || !this.elem().name().equals("bajaObjectGraph")) {
                throw this.err("Expected end tag for \"bajaObjectGraph\"");
            }
            return bValue;
        }

        public final int next() throws Exception {
            return this.parser.next();
        }

        public final IElement elem() {
            return BogElement.make(this.parser.elem());
        }

        public final void skip() throws Exception {
            this.parser.skip();
        }

        public final void skip(int n) throws Exception {
            this.parser.skip(n);
        }

        public final int type() {
            return this.parser.type();
        }

        public final int line() {
            return this.parser.line();
        }

        public final int column() {
            return this.parser.column();
        }

        public final void close() {
            this.parser.close();
        }

        public final int depth() {
            return this.parser.depth();
        }

        public final String getEncoding() throws IOException {
            return this.parser.getEncoding();
        }

        public final boolean isZipped() throws IOException {
            return this.parser.isZipped();
        }

        public final IElement parse() throws Exception {
            return BogElement.make(this.parser.parse());
        }

        public final IElement parse(boolean bl) throws Exception {
            return BogElement.make(this.parser.parse(bl));
        }

        public final IElement parseCurrent() throws Exception {
            return BogElement.make(this.parser.parseCurrent());
        }

        public final IElement parseCurrent(boolean bl) throws Exception {
            return BogElement.make(this.parser.parseCurrent(bl));
        }

        public final ITypeResolver getTypeResolver() {
            return this.typeResolver;
        }

        public final void setTypeResolver(ITypeResolver iTypeResolver) {
            this.typeResolver = iTypeResolver == null ? defaultTypeResolver : iTypeResolver;
        }

        public final RuntimeException err(String string, Throwable throwable) {
            return new XException(string, this.parser.line(), this.parser.column(), throwable);
        }

        public final RuntimeException err(String string) {
            return new XException(string, this.parser.line(), this.parser.column());
        }

        public final void warningAndSkip(String string) throws RuntimeException {
            this.warning(string);
            try {
                this.skip();
            }
            catch (XException xException) {
                throw xException;
            }
            catch (Exception exception) {
                throw new XException((Throwable)exception);
            }
        }

        public final void warning(String string) throws RuntimeException {
            this.log.warning(string + " [" + this.parser.line() + ':' + this.parser.column() + ']');
            ++this.warningCount;
        }

        public final Log getLog() {
            return this.log;
        }

        public final void setLog(Log log) {
            this.log = log;
        }

        public final int getWarningCount() {
            return this.warningCount;
        }

        public final XParser getXmlParser() {
            return this.parser;
        }

        public static final BValue unmarshal(String string) throws Exception {
            BogDecoderPlugin bogDecoderPlugin = new BogDecoderPlugin(new ByteArrayInputStream(string.getBytes()));
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder(bogDecoderPlugin);
            valueDocDecoder.plugin.next();
            return valueDocDecoder.decode();
        }

        public static final BValue unmarshal(String string, ITypeResolver iTypeResolver) throws Exception {
            BogDecoderPlugin bogDecoderPlugin = new BogDecoderPlugin(new ByteArrayInputStream(string.getBytes()));
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder(bogDecoderPlugin);
            valueDocDecoder.plugin.setTypeResolver(iTypeResolver);
            valueDocDecoder.plugin.next();
            return valueDocDecoder.decode();
        }

        private final /* synthetic */ void this() {
            this.modules = new HashMap();
            this.typeResolver = new BogTypeResolver();
            this.log = defaultLog;
        }

        public BogDecoderPlugin(InputStream inputStream) throws Exception {
            this.this();
            this.parser = XParser.make((InputStream)inputStream);
        }

        public BogDecoderPlugin(BOrd bOrd) throws Exception {
            this((BIFile)((Object)bOrd.resolve().get()));
        }

        public BogDecoderPlugin(BIFile bIFile) throws Exception {
            this(new BufferedInputStream(bIFile.getInputStream()));
        }

        public BogDecoderPlugin(File file) throws Exception {
            this(new BufferedInputStream(new FileInputStream(file)));
        }
    }

    public static interface IDecoderPlugin {
        public BValue decodeDocument(ValueDocDecoder var1) throws Exception;

        public int next() throws Exception;

        public IElement elem();

        public void skip() throws Exception;

        public void skip(int var1) throws Exception;

        public int type();

        public int line();

        public int column();

        public void close();

        public int depth();

        public String getEncoding() throws IOException;

        public boolean isZipped() throws IOException;

        public IElement parse() throws Exception;

        public IElement parse(boolean var1) throws Exception;

        public IElement parseCurrent() throws Exception;

        public IElement parseCurrent(boolean var1) throws Exception;

        public ITypeResolver getTypeResolver();

        public void setTypeResolver(ITypeResolver var1);

        public RuntimeException err(String var1, Throwable var2);

        public RuntimeException err(String var1);

        public void warningAndSkip(String var1) throws RuntimeException;

        public void warning(String var1);

        public Log getLog();

        public void setLog(Log var1);

        public int getWarningCount();
    }

    public static interface IElement {
        public String name();

        public String get(String var1);

        public String get(String var1, String var2);

        public int geti(String var1);

        public int geti(String var1, int var2);

        public double getd(String var1);

        public double getd(String var1, double var2);

        public float getf(String var1);

        public float getf(String var1, float var2);

        public long getl(String var1);

        public long getl(String var1, long var2);

        public int attrSize();

        public String attrName(int var1);

        public String attrValue(int var1);

        public IElement copy();
    }

    public static interface ITypeResolver {
        public BModule loadModule(ValueDocDecoder var1, BComplex var2, String var3, String var4, String var5);

        public BValue newInstance(ValueDocDecoder var1, BComplex var2, String var3, Property var4, String var5);
    }

    public static class BogTypeResolver
    implements ITypeResolver {
        public BModule loadModule(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, String string2, String string3) {
            try {
                int n = string2.indexOf(61);
                String string4 = string2.substring(0, n).trim();
                String string5 = string2.substring(n + 1).trim();
                NModule nModule = Nre.moduleManager.loadModule(string5);
                this.getModuleMap(valueDocDecoder).put(string4, nModule);
                return nModule.bmodule();
            }
            catch (ModuleException moduleException) {
                throw valueDocDecoder.plugin.err("Cannot load module '" + string2 + '\'', moduleException);
            }
            catch (Exception exception) {
                throw valueDocDecoder.plugin.err("Invalid module attribute '" + string2 + '\'');
            }
        }

        public BValue newInstance(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, Property property, String string2) {
            if (string2 == null) {
                if (property != null) {
                    return property.getDefaultValue();
                }
                valueDocDecoder.plugin.warningAndSkip("Missing frozen property: " + string);
                return null;
            }
            try {
                int n = string2.indexOf(58);
                if (n <= 0) {
                    throw valueDocDecoder.plugin.err("Invalid typespec '" + string2 + '\'');
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                NModule nModule = (NModule)this.getModuleMap(valueDocDecoder).get(string3);
                if (nModule == null) {
                    throw valueDocDecoder.plugin.err("Undeclared module symbol: " + string3, new ModuleNotFoundException(string3));
                }
                return ValueDocDecoder.typeResolverNewInstance(nModule, string4);
            }
            catch (XException xException) {
                throw xException;
            }
            catch (TypeNotFoundException typeNotFoundException) {
                valueDocDecoder.plugin.warningAndSkip("Type \"" + typeNotFoundException.getMessage() + "\" not found: " + string);
                return null;
            }
            catch (Throwable throwable) {
                throw valueDocDecoder.plugin.err("Cannot instantiate type '" + string2 + '\'', throwable);
            }
        }

        public Map getModuleMap(ValueDocDecoder valueDocDecoder) {
            return ((BogDecoderPlugin)valueDocDecoder.plugin).modules;
        }
    }

    public static final class BogElement
    implements IElement {
        private XElem elem;

        public static final BogElement make(XElem xElem) {
            return xElem == null ? null : new BogElement(xElem);
        }

        public final String name() {
            return this.elem.name();
        }

        public final String get(String string) {
            return this.elem.get(string);
        }

        public final String get(String string, String string2) {
            return this.elem.get(string, string2);
        }

        public final int geti(String string) {
            return this.elem.geti(string);
        }

        public final int geti(String string, int n) {
            return this.elem.geti(string, n);
        }

        public final double getd(String string) {
            return this.elem.getd(string);
        }

        public final double getd(String string, double d) {
            return this.elem.getd(string, d);
        }

        public final float getf(String string) {
            return this.elem.getf(string);
        }

        public final float getf(String string, float f) {
            return this.elem.getf(string, f);
        }

        public final long getl(String string) {
            return this.elem.getl(string);
        }

        public final long getl(String string, long l) {
            return this.elem.getl(string, l);
        }

        public final int attrSize() {
            return this.elem.attrSize();
        }

        public final String attrName(int n) {
            return this.elem.attrName(n);
        }

        public final String attrValue(int n) {
            return this.elem.attrValue(n);
        }

        public final IElement copy() {
            return BogElement.make(this.elem.copy());
        }

        public final String toString() {
            return this.elem.toString();
        }

        public final XElem getXmlElement() {
            return this.elem;
        }

        private BogElement(XElem xElem) {
            this.elem = xElem;
        }
    }
}

