/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XException;
import javax.baja.xml.XWriter;

public class HtmlWriter
extends PrintWriter {
    public void println(String string) {
        this.print(string);
        this.print('\n');
        this.flush();
    }

    public HtmlWriter w(Object object) {
        this.print(object);
        return this;
    }

    public final HtmlWriter w(boolean bl) {
        this.print(bl);
        return this;
    }

    public final HtmlWriter w(char c) {
        this.print(c);
        return this;
    }

    public final HtmlWriter w(int n) {
        this.print(n);
        return this;
    }

    public final HtmlWriter w(long l) {
        this.print(l);
        return this;
    }

    public final HtmlWriter w(float f) {
        this.print(f);
        return this;
    }

    public final HtmlWriter w(double d) {
        this.print(d);
        return this;
    }

    public final HtmlWriter nbsp() {
        this.print("&nbsp;");
        return this;
    }

    public final HtmlWriter nl() {
        this.print('\n');
        return this;
    }

    public final HtmlWriter indent(int n) {
        return this.w(TextUtil.getSpaces((int)n));
    }

    public final HtmlWriter attr(String string, String string2) {
        return this.w(string).w('=').w('\'').safe(string2).w('\'');
    }

    public final HtmlWriter attr(String string, int n) {
        return this.attr(string, Integer.toString(n));
    }

    public final HtmlWriter attr(String string, float f) {
        return this.attr(string, Float.toString(f));
    }

    public final HtmlWriter attr(String string, double d) {
        return this.attr(string, Double.toString(d));
    }

    public final HtmlWriter attr(String string, Object object) {
        return this.attr(string, String.valueOf(object));
    }

    public final HtmlWriter safe(String string, boolean bl) {
        try {
            XWriter.safe((Writer)this, (String)string, (boolean)bl);
            return this;
        }
        catch (IOException iOException) {
            throw new XException(iOException.toString(), (Throwable)iOException);
        }
    }

    public final HtmlWriter safe(String string) {
        try {
            XWriter.safe((Writer)this, (String)string, (boolean)true);
            return this;
        }
        catch (IOException iOException) {
            throw new XException(iOException.toString(), (Throwable)iOException);
        }
    }

    public final HtmlWriter safe(int n, boolean bl) {
        try {
            XWriter.safe((Writer)this, (int)n, (boolean)bl);
            return this;
        }
        catch (IOException iOException) {
            throw new XException(iOException.toString(), (Throwable)iOException);
        }
    }

    public String href(String string) {
        return string;
    }

    public HtmlWriter a(String string, String string2) {
        return this.w("<a href='").w(this.href(string)).w("'>").safe(string2).w("</a>");
    }

    public HtmlWriter a(String string) {
        return this.a(string, string);
    }

    public HtmlWriter startTable(boolean bl) {
        this.w("<table");
        if (bl) {
            this.w(" border='1' cellspacing='0'");
        }
        this.w(">\n");
        return this;
    }

    public HtmlWriter trTitle(Object object, int n) {
        this.w("<tr><th nowrap='true' colspan='").w(n).w("' bgcolor='#d0d0d0'>").w(object).w("</th></tr>\n");
        return this;
    }

    public HtmlWriter thTitle(Object object) {
        this.w("<th align='left' nowrap='true' bgcolor='#d0d0d0'>").w(object).w("</th>\n");
        return this;
    }

    public HtmlWriter endTable() {
        this.w("</table>\n");
        return this;
    }

    public HtmlWriter tr(Object object) {
        return this.w("<tr>").td(object).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2) {
        return this.w("<tr>").td(object).td(object2).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2, Object object3) {
        return this.w("<tr>").td(object).td(object2).td(object3).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2, Object object3, Object object4) {
        return this.w("<tr>").td(object).td(object2).td(object3).td(object4).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.w("<tr>").td(object).td(object2).td(object3).td(object4).td(object5).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.w("<tr>").td(object).td(object2).td(object3).td(object4).td(object5).td(object6).w("</tr>\n");
    }

    public HtmlWriter tr(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.w("<tr>").td(object).td(object2).td(object3).td(object4).td(object5).td(object6).td(object7).w("</tr>\n");
    }

    public HtmlWriter th(Object object) {
        return this.w("<th align='left' nowrap='true'>").w(object).w("</th>");
    }

    public HtmlWriter td(Object object) {
        return this.w("<td align='left' nowrap='true'>").w(object).w("</td>");
    }

    public HtmlWriter(Writer writer) {
        super(writer);
    }

    public HtmlWriter(OutputStream outputStream) {
        super(outputStream);
    }
}

