/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.SimpleFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BogDecoder
extends XParser {
    static final Log defaultLog = Log.getLog("sys.xml");
    public static final TypeResolver defaultTypeResolver = new TypeResolver();
    HashMap modules;
    Log log;
    int warningCount;
    TypeResolver typeResolver;
    SimpleFactory simpleFactory;
    private Context context;

    public static BValue unmarshal(String string) throws Exception {
        BogDecoder bogDecoder = new BogDecoder(new ByteArrayInputStream(string.getBytes()));
        bogDecoder.next();
        return bogDecoder.decode();
    }

    public static BValue unmarshal(String string, TypeResolver typeResolver) throws Exception {
        BogDecoder bogDecoder = new BogDecoder(new ByteArrayInputStream(string.getBytes()));
        bogDecoder.setTypeResolver(typeResolver);
        bogDecoder.next();
        return bogDecoder.decode();
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver == null ? defaultTypeResolver : typeResolver;
    }

    public BValue decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BValue decodeDocument(boolean bl) throws Exception {
        BValue bValue;
        block5: {
            try {
                this.next();
                XElem xElem = this.elem();
                if (!xElem.name().equals("bajaObjectGraph")) {
                    throw this.err("Root element must be \"bajaObjectGraph\"");
                }
                String string = xElem.get("version");
                if (!string.equals("1.0")) {
                    throw this.err("Only version 1.0 is supported");
                }
                this.next();
                BValue bValue2 = this.decode();
                this.next();
                if (this.type() != 2 || this.elem() != xElem) {
                    throw this.err("Expected end tag for \"bajaObjectGraph\"");
                }
                bValue = bValue2;
                Object var3_6 = null;
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_7 = null;
                    if (!bl) break block6;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return bValue;
    }

    public BValue decode() throws Exception {
        BValue bValue = this.parseSlot(null);
        if (bValue == null) {
            throw this.err("Error parsing value");
        }
        return bValue;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new NullPointerException();
        }
        this.log = log;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    protected void decodingComponent(BComponent bComponent) throws Exception {
        this.warning("Unknown element <" + this.elem().name() + "> for decodingComponent");
    }

    void parseSlots(BObject bObject) throws Exception {
        while (true) {
            int n;
            if ((n = this.next()) == -1) {
                throw new EOFException();
            }
            if (n == 2) {
                return;
            }
            if (n != 1) {
                throw this.err("Expected element start");
            }
            this.parseSlot((BComplex)bObject);
        }
    }

    BValue parseSlot(BComplex bComplex) throws Exception {
        Object object;
        Object object2;
        if (this.type() != 1) {
            throw this.err("Expected element start (" + this.type() + ')');
        }
        XElem xElem = this.elem();
        String string = xElem.name().intern();
        if (string != "p" && string != "a" && string != "t") {
            if (bComplex instanceof BComponent) {
                this.decodingComponent((BComponent)bComplex);
            } else {
                this.warning("Unknown element <" + string + '>');
            }
            return null;
        }
        String string2 = null;
        String string3 = null;
        Object object3 = null;
        Object object4 = null;
        String string4 = null;
        Object object5 = null;
        BFacets bFacets = BFacets.NULL;
        Object object6 = null;
        boolean bl = false;
        int n = xElem.attrSize();
        int n2 = 0;
        while (n2 < n) {
            object2 = xElem.attrName(n2);
            object = xElem.attrValue(n2);
            if (object2 == "n") {
                string2 = object;
            } else if (object2 == "h") {
                string3 = object;
            } else if (object2 == "v") {
                string4 = object;
            } else if (object2 == "t") {
                object4 = object;
            } else if (object2 == "m") {
                object3 = object;
            } else if (object2 == "f") {
                object5 = object;
            } else if (object2 == "x") {
                bFacets = this.decodeFacets((String)object);
            } else if (object2 == "c") {
                object6 = object;
            } else if (((String)object2).equals("stub")) {
                bl = ((String)object).equals("true");
            }
            ++n2;
        }
        n2 = this.decodeFlags((String)object5);
        if (object3 != null && !this.getTypeResolver().loadModule(this, bComplex, string2, (String)object3, (String)object4)) {
            int n3 = this.line();
            int n4 = this.column();
            try {
                this.skip();
            }
            catch (XException xException) {
                this.log.warning("Missing module: " + (String)object3 + " [" + n3 + ':' + n4 + ']');
                throw xException;
            }
            catch (Exception exception) {
                this.log.warning("Missing module: " + (String)object3 + " [" + n3 + ':' + n4 + ']');
                throw new XException((Throwable)exception);
            }
            if (this.log.isTraceOn()) {
                this.log.trace("Missing module: " + (String)object3 + " [" + n3 + ':' + n4 + ']');
            }
            return null;
        }
        object2 = null;
        if (bComplex != null) {
            if (string2 == null) {
                throw this.err("Missing \"n\" name attribute");
            }
            object2 = bComplex.getSlot(string2);
        }
        if (object2 != null) {
            if (object5 != null) {
                bComplex.setFlags((Slot)object2, n2, Context.decoding);
            }
            if (!object2.isProperty()) {
                this.skip();
                return null;
            }
        } else {
            if (string == "a") {
                this.warning("Missing frozen action: " + string2);
                return null;
            }
            if (string == "t") {
                this.warning("Missing frozen topic: " + string2);
                return null;
            }
        }
        if (this.decodePrimitive(bComplex, (Property)(object = (Property)object2), string4)) {
            return null;
        }
        BValue bValue = this.getTypeResolver().newInstance(this, bComplex, string2, (Property)object, (String)object4);
        if (bValue == null) {
            return null;
        }
        if (bValue.isSimple() && string4 != null) {
            bValue = this.decodeSimple(bValue, string4);
        }
        if (bValue.isComponent()) {
            ((ComponentSlotMap)bValue.fw(1)).setHandle(string3);
            if (!bl) {
                ((ComponentSlotMap)bValue.fw(1)).setBrokerPropsLoaded(true);
            }
            if (object6 != null) {
                ((BComponent)bValue).setCategoryMask(BCategoryMask.make((String)object6), Context.decoding);
            }
        }
        if (bComplex != null) {
            if (object != null) {
                if (!object.isFrozen()) {
                    throw this.err("Duplicate slot " + bComplex.getType().getTypeName() + '.' + string2);
                }
                try {
                    bComplex.set((Property)object, bValue, Context.decoding);
                }
                catch (Exception exception) {
                    this.warning("Cannot set property " + bComplex.getType().getTypeName() + '.' + string2 + ": " + exception);
                }
            } else if (bComplex.isComponent()) {
                bComplex.asComponent().add(string2, bValue, n2, bFacets, Context.decoding);
            } else {
                this.warning("Missing slot " + bComplex.getType().getTypeName() + '.' + string2);
            }
        }
        this.parseSlots(bValue);
        return bValue;
    }

    boolean decodePrimitive(BComplex bComplex, Property property, String string) throws Exception {
        if (property == null || string == null) {
            return false;
        }
        if (property.getTypeAccess() == 7) {
            return false;
        }
        switch (property.getTypeAccess()) {
            case 0: {
                bComplex.setBoolean(property, BBoolean.decode(string), Context.decoding);
                break;
            }
            case 2: {
                bComplex.setInt(property, BInteger.decode(string), Context.decoding);
                break;
            }
            case 3: {
                bComplex.setLong(property, BLong.decode(string), Context.decoding);
                break;
            }
            case 4: {
                bComplex.setFloat(property, BFloat.decode(string), Context.decoding);
                break;
            }
            case 5: {
                bComplex.setDouble(property, BDouble.decode(string), Context.decoding);
                break;
            }
            case 6: {
                bComplex.setString(property, string, Context.decoding);
                break;
            }
            default: {
                throw new IllegalStateException("" + property.getTypeAccess());
            }
        }
        int n = this.next();
        if (n != 2) {
            throw this.err("Expecting end of p element for simple property " + property.getName());
        }
        return true;
    }

    BSimple decodeSimple(BObject bObject, String string) {
        try {
            return this.simpleFactory.make(bObject.getType(), string, this.context);
        }
        catch (Exception exception) {
            throw this.err("Invalid " + bObject.getType().getTypeName() + ": '" + string + '\'', exception);
        }
    }

    int decodeFlags(String string) {
        if (string == null) {
            return 0;
        }
        return Flags.decodeFromString(string);
    }

    BFacets decodeFacets(String string) {
        try {
            if (string == null) {
                return BFacets.NULL;
            }
            return (BFacets)this.simpleFactory.make(BFacets.TYPE, string, this.context);
        }
        catch (Exception exception) {
            throw this.err("Invalid facets " + string, exception);
        }
    }

    XException err(String string, Throwable throwable) {
        return new XException(string, (XParser)this, throwable);
    }

    XException err(String string) {
        return new XException(string, (XParser)this);
    }

    void warning(String string) throws XException {
        this.log.warning(string + " [" + this.line() + ':' + this.column() + ']');
        ++this.warningCount;
        try {
            this.skip();
        }
        catch (XException xException) {
            throw xException;
        }
        catch (Exception exception) {
            throw new XException((Throwable)exception);
        }
    }

    private final /* synthetic */ void this() {
        this.modules = new HashMap();
        this.log = defaultLog;
        this.typeResolver = defaultTypeResolver;
        this.simpleFactory = new SimpleFactory();
        this.context = null;
    }

    public BogDecoder(BOrd bOrd) throws Exception {
        this((BIFile)((Object)bOrd.resolve().get()));
    }

    public BogDecoder(BIFile bIFile) throws Exception {
        this(new BufferedInputStream(bIFile.getInputStream()));
    }

    public BogDecoder(File file) throws Exception {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public BogDecoder(InputStream inputStream) throws Exception {
        super(inputStream);
        this.this();
    }

    public static class TypeResolver {
        public boolean loadModule(BogDecoder bogDecoder, BComplex bComplex, String string, String string2, String string3) {
            try {
                int n = string2.indexOf(61);
                String string4 = string2.substring(0, n).trim();
                String string5 = string2.substring(n + 1).trim();
                NModule nModule = Nre.moduleManager.loadModule(string5);
                this.getModuleMap(bogDecoder).put(string4, nModule);
            }
            catch (ModuleException moduleException) {
                throw bogDecoder.err("Cannot load module '" + string2 + '\'', moduleException);
            }
            catch (Exception exception) {
                throw bogDecoder.err("Invalid module attribute '" + string2 + '\'');
            }
            return true;
        }

        public BValue newInstance(BogDecoder bogDecoder, BComplex bComplex, String string, Property property, String string2) {
            if (string2 == null) {
                if (property != null) {
                    return property.getDefaultValue();
                }
                bogDecoder.warning("Missing frozen property: " + string);
                return null;
            }
            try {
                int n = string2.indexOf(58);
                if (n <= 0) {
                    throw bogDecoder.err("Invalid typespec '" + string2 + '\'');
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                NModule nModule = (NModule)this.getModuleMap(bogDecoder).get(string3);
                if (nModule == null) {
                    throw bogDecoder.err("Undeclared module symbol: " + string3, new ModuleNotFoundException(string3));
                }
                return ValueDocDecoder.typeResolverNewInstance(nModule, string4);
            }
            catch (XException xException) {
                throw xException;
            }
            catch (TypeNotFoundException typeNotFoundException) {
                bogDecoder.warning("Type \"" + typeNotFoundException.getMessage() + "\" not found: " + string);
                return null;
            }
            catch (Throwable throwable) {
                throw bogDecoder.err("Cannot instantiate type '" + string2 + '\'', throwable);
            }
        }

        protected Map getModuleMap(BogDecoder bogDecoder) {
            return bogDecoder.modules;
        }
    }
}

