/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipFileDirectory;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.file.zip.ZipPath;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZipSpace
extends BFileSpace
implements BIDirectory {
    public static final Type TYPE;
    static final Log log;
    BSpace parentSpace;
    BOrd ordInSession;
    private ZipFile zip;
    BZipFile bZipFile;
    BDirectory roots;
    boolean isModule;
    static /* synthetic */ Class class$javax$baja$file$zip$BZipSpace;

    public Type getType() {
        return TYPE;
    }

    ZipFile getZip() {
        if (this.zip == null && this.bZipFile != null) {
            this.zip = BZipSpace.open(this.bZipFile.getStore());
        }
        return this.zip;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        try {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.zip = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.zip = null;
            return;
        }
    }

    static ZipFile open(BIFileStore bIFileStore) {
        try {
            if (bIFileStore instanceof BLocalFileStore) {
                File file = ((BLocalFileStore)bIFileStore).getLocalFile();
                return new ZipFile(file);
            }
            throw new IllegalStateException("Only BLocalFileStore supported");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException(iOException);
        }
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    public BIFile[] listFiles() {
        return this.getChildren(this.roots());
    }

    public BIFile findFile(FilePath filePath) {
        BIFile bIFile = this.roots();
        int n = 0;
        while (n < filePath.depth()) {
            if ((bIFile = this.getChild(bIFile, filePath.nameAt(n))) == null) {
                return null;
            }
            ++n;
        }
        return bIFile;
    }

    public BIFileStore findStore(FilePath filePath) {
        BIFile bIFile = this.findFile(filePath);
        if (bIFile == null) {
            return null;
        }
        return bIFile.getStore();
    }

    public BIFile getChild(BIFile bIFile, String string) {
        BIFileStore bIFileStore = bIFile.getStore();
        if (bIFileStore instanceof BZipFileDirectory) {
            BZipFileDirectory bZipFileDirectory = (BZipFileDirectory)bIFileStore;
            return bZipFileDirectory.get(string);
        }
        return null;
    }

    public BIFile[] getChildren(BIFile bIFile) {
        BIFileStore bIFileStore = bIFile.getStore();
        if (bIFileStore instanceof BZipFileDirectory) {
            BZipFileDirectory bZipFileDirectory = (BZipFileDirectory)bIFileStore;
            return bZipFileDirectory.list();
        }
        return new BIFile[0];
    }

    protected BOrd appendFilePathToOrd(BOrd bOrd, FilePath filePath) {
        if (bOrd == null) {
            return null;
        }
        if (bOrd.toString().length() == 0) {
            return BOrd.make(filePath);
        }
        return BOrd.make(bOrd, filePath);
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        return this.getChild(this.roots(), string);
    }

    public BINavNode[] getNavChildren() {
        return this.listFiles();
    }

    private final synchronized BDirectory roots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = new BDirectory(new BZipFileDirectory(this, (FilePath)new ZipPath("/")));
        try {
            Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String string = zipEntry.getName().replace('\\', '/');
                if (this.isModule && (string.endsWith(".class") || string.endsWith(".properties") || string.startsWith("META-INF/") || string.startsWith("meta-inf/"))) continue;
                ZipPath zipPath = new ZipPath("/" + string);
                BZipFileEntry bZipFileEntry = new BZipFileEntry(this, zipPath, zipEntry);
                BIFile bIFile = this.makeFile(bZipFileEntry);
                BDirectory bDirectory = this.mapToDirectory(zipPath);
                BZipFileDirectory bZipFileDirectory = (BZipFileDirectory)bDirectory.getStore();
                bZipFileDirectory.add(bIFile);
            }
        }
        catch (Exception exception) {
            log.error("Loading zip: " + this.zip, exception);
        }
        return this.roots;
    }

    public BHost getHost() {
        return this.parentSpace == null ? null : this.parentSpace.getHost();
    }

    public BISession getSession() {
        return this.parentSpace == null ? null : this.parentSpace.getSession();
    }

    private final BDirectory mapToDirectory(FilePath filePath) {
        BDirectory bDirectory = this.roots;
        int n = 0;
        while (n < filePath.depth() - 1) {
            BZipFileDirectory bZipFileDirectory = (BZipFileDirectory)bDirectory.getStore();
            bDirectory = bZipFileDirectory.getOrMakeDir(filePath.nameAt(n));
            ++n;
        }
        return bDirectory;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BZipSpace(BZipFile bZipFile) {
        super("zip");
        this.parentSpace = bZipFile.getSpace();
        this.ordInSession = bZipFile.getOrdInSession();
        this.bZipFile = bZipFile;
        this.zip = BZipSpace.open(bZipFile.getStore());
    }

    public BZipSpace(BOrd bOrd, ZipFile zipFile) {
        super("zip");
        this.ordInSession = bOrd;
        this.zip = zipFile;
        boolean bl = false;
        if (bOrd.toString().indexOf("module:") >= 0) {
            bl = true;
        }
        this.isModule = bl;
    }

    static {
        Class clazz = class$javax$baja$file$zip$BZipSpace;
        if (clazz == null) {
            clazz = class$javax$baja$file$zip$BZipSpace = BZipSpace.class("[Ljavax.baja.file.zip.BZipSpace;", false);
        }
        TYPE = Sys.loadType(clazz);
        log = Log.getLog("file");
    }
}

