/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.IllegalNameException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FilePath
implements OrdQuery,
Path,
Comparable {
    public static final int RELATIVE = 0;
    public static final int AUTHORITY_ABSOLUTE = 1;
    public static final int LOCAL_ABSOLUTE = 2;
    public static final int SYS_HOME_ABSOLUTE = 3;
    public static final int STATION_HOME_ABSOLUTE = 4;
    private static final String[] NO_NAMES = new String[0];
    private String scheme;
    private String body;
    private int absMode;
    private String authority;
    private int backupDepth;
    private String[] names;
    private String fragment;

    protected FilePath newInstance(String string) {
        return new FilePath(this.getScheme(), string);
    }

    public boolean isAbsolute() {
        boolean bl = false;
        if (this.absMode != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isRelative() {
        boolean bl = false;
        if (this.absMode == 0) {
            bl = true;
        }
        return bl;
    }

    public int getAbsoluteMode() {
        return this.absMode;
    }

    public boolean isAuthorityAbsolute() {
        boolean bl = false;
        if (this.absMode == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isLocalAbsolute() {
        boolean bl = false;
        if (this.absMode == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isSysHomeAbsolute() {
        boolean bl = false;
        if (this.absMode == 3) {
            bl = true;
        }
        return bl;
    }

    public boolean isStationHomeAbsolute() {
        boolean bl = false;
        if (this.absMode == 4) {
            bl = true;
        }
        return bl;
    }

    public String getAbsoluteBase() {
        switch (this.absMode) {
            case 0: {
                return "";
            }
            case 1: {
                return "//" + this.authority + '/';
            }
            case 2: {
                return "/";
            }
            case 3: {
                return "!";
            }
            case 4: {
                return "^";
            }
        }
        throw new IllegalStateException();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getName() {
        if (this.names.length == 0) {
            return this.getAbsoluteBase();
        }
        return this.names[this.names.length - 1];
    }

    public int getBackupDepth() {
        return this.backupDepth;
    }

    public int depth() {
        return this.names.length;
    }

    public String nameAt(int n) {
        return this.names[n];
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public Path getParentPath() {
        return this.getParent();
    }

    public FilePath getParent() {
        int n;
        if (this.names.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAbsolute()) {
            stringBuffer.append(this.getAbsoluteBase());
        } else {
            n = this.getBackupDepth();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("../");
                ++n2;
            }
        }
        n = 0;
        while (n < this.names.length - 1) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.names[n]);
            ++n;
        }
        return this.newInstance(stringBuffer.toString());
    }

    public static boolean isValidName(String string) {
        try {
            int n = string.length();
            if (n == 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!FilePath.isName(c) || c == ':') {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void verifyValidName(String string) {
        if (!FilePath.isValidName(string)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{string});
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
        if (ordQueryList.isSameScheme(n, n + 1)) {
            FilePath filePath = (FilePath)ordQueryList.get(n + 1);
            ordQueryList.merge(n, this.merge(filePath));
        }
        ordQueryList.shiftToSession(n);
    }

    public FilePath merge(String string) {
        return this.merge(this.newInstance(string));
    }

    public FilePath merge(FilePath filePath) {
        if (filePath.isAbsolute()) {
            if (this.isAuthorityAbsolute() && !filePath.isAuthorityAbsolute()) {
                return this.newInstance("//" + this.authority + filePath.body);
            }
            return filePath;
        }
        if (this.isAbsolute() || filePath.getBackupDepth() < this.depth()) {
            StringBuffer stringBuffer = new StringBuffer(this.getAbsoluteBase());
            boolean bl = false;
            int n = 0;
            while (n < this.depth() - filePath.getBackupDepth()) {
                if (bl) {
                    stringBuffer.append('/');
                } else {
                    bl = true;
                }
                stringBuffer.append(this.nameAt(n));
                ++n;
            }
            n = 0;
            while (n < filePath.depth()) {
                if (bl) {
                    stringBuffer.append('/');
                } else {
                    bl = true;
                }
                stringBuffer.append(filePath.nameAt(n));
                ++n;
            }
            if (filePath.fragment != null) {
                stringBuffer.append('#').append(filePath.fragment);
            }
            return this.newInstance(stringBuffer.toString());
        }
        throw new SyntaxException("Invalid merge " + this + " + " + filePath);
    }

    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            if (this.body.length() == 0) {
                return;
            }
            String string = this.body;
            int n = this.body.indexOf(35);
            if (n >= 0) {
                this.fragment = this.body.substring(n + 1);
                this.body = this.body.substring(0, n);
            }
            int n2 = this.parsePrefix();
            this.parseNames(n2);
            this.body = string;
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Throwable throwable) {
            throw new SyntaxException(this.body, throwable);
        }
    }

    int parsePrefix() {
        String string = this.body;
        int n = string.length();
        int n2 = -1;
        if (n > 0) {
            n2 = string.charAt(0);
        }
        int n3 = -1;
        if (n > 1) {
            n3 = string.charAt(1);
        }
        if (n2 == 47) {
            if (n3 == 47) {
                this.absMode = 1;
                int n4 = string.indexOf(47, 3);
                if (n4 < 0) {
                    this.authority = string.substring(2, n);
                    this.checkAuthority(this.authority);
                    return n;
                }
                this.authority = string.substring(2, n4);
                this.checkAuthority(this.authority);
                return n4 + 1;
            }
            this.absMode = 2;
            return this.skipSlash(string, 1);
        }
        if (n2 == 33) {
            this.absMode = 3;
            return 1;
        }
        if (n2 == 94) {
            this.absMode = 4;
            return 1;
        }
        if (n2 == 46) {
            this.absMode = 0;
            return this.parseBackup();
        }
        this.absMode = 0;
        return 0;
    }

    int parseBackup() {
        String string = this.body;
        int n = string.length();
        if (n == 1) {
            throw new SyntaxException("Dot not supported: " + string);
        }
        char c = string.charAt(1);
        if (c != '.') {
            if (c == '/') {
                throw new SyntaxException("Dot/ not supported: " + string);
            }
            return 0;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c2 = string.charAt(n2);
            int n4 = n2 + 1 < n ? (int)string.charAt(n2 + 1) : -1;
            int n5 = n3 = n2 + 2 < n ? (int)string.charAt(n2 + 2) : 47;
            if (c2 != '.') {
                return n2;
            }
            if (n4 != 46) {
                if (n4 == 47) {
                    throw new SyntaxException("Single dot unsupported: " + string);
                }
                return n2;
            }
            if (n3 != 47) {
                throw new SyntaxException("Expecting ../ backup: " + string);
            }
            ++this.backupDepth;
            n2 += 3;
        }
        return n;
    }

    void parseNames(int n) {
        String string;
        String string2 = this.body;
        int n2 = string2.length();
        if (n >= n2) {
            return;
        }
        if (string2.charAt(n2 - 1) == '/') {
            throw new SyntaxException("Trailing slash: " + string2);
        }
        String[] stringArray = new String[64];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = string2.charAt(n4);
            if (c == '/') {
                if (n4 == n) {
                    throw new SyntaxException("Illegal double slashes: " + string2);
                }
                string = string2.substring(n, n4);
                if (string.startsWith("..")) {
                    throw new SyntaxException("Illegal backup in path: " + string2);
                }
                stringArray[n3++] = string;
                n = n4 + 1;
            } else if (!FilePath.isName(c)) {
                throw new SyntaxException("Illegal char '" + (char)c + "' in body: " + string2);
            }
            ++n4;
        }
        string = string2.substring(n, n2);
        if (string.startsWith("..")) {
            throw new SyntaxException("Illegal backup in path: " + string2);
        }
        stringArray[n3++] = string;
        this.names = new String[n3];
        System.arraycopy(stringArray, 0, this.names, 0, n3);
    }

    int skipSlash(String string, int n) {
        if (n >= string.length()) {
            return n;
        }
        if (string.charAt(n) == '/') {
            return n + 1;
        }
        return n;
    }

    void checkAuthority(String string) {
        if (string.length() == 0) {
            throw new SyntaxException("Missing authority name: " + this.body);
        }
        int n = 0;
        while (n < string.length()) {
            if (!FilePath.isAuthority(string.charAt(n))) {
                throw new SyntaxException("Illegal char '" + string.charAt(n) + "' in authority: " + this.body);
            }
            ++n;
        }
    }

    public int hashCode() {
        return (this.scheme + ':' + this.body).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilePath)) {
            return false;
        }
        if (!this.body.equals(((FilePath)object).body)) {
            return false;
        }
        return this.scheme.equals(((FilePath)object).scheme);
    }

    public int compareTo(Object object) {
        if (!(object instanceof FilePath)) {
            return 0;
        }
        if (!this.scheme.equals(((FilePath)object).scheme)) {
            return this.scheme.compareTo(((FilePath)object).scheme);
        }
        return this.body.compareTo(((FilePath)object).body);
    }

    static boolean isName(int n) {
        boolean bl = false;
        if (n <= 31 || n == 127 || n == 34 || n == 92 || n == 60 || n == 62 || n == 63 || n == 42 || n == 47 || n == 124) {
            bl = true;
        }
        return bl ^ true;
    }

    static boolean isAuthority(int n) {
        boolean bl = false;
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 46 || n == 45) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.names = NO_NAMES;
    }

    public FilePath(String string, String string2) throws SyntaxException {
        this.this();
        this.scheme = TextUtil.toLowerCase((String)string).trim();
        this.body = string2.trim();
        this.parse();
    }

    public FilePath(String string) throws SyntaxException {
        this.this();
        this.scheme = "file";
        this.body = string.trim();
        this.parse();
    }
}

