/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import com.tridium.sys.Nre;
import com.tridium.util.BRestrictedFileSpace;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BScopedFileSpace
extends BFileSpace {
    public static final Type TYPE;
    public static final BScopedFileSpace SYS_HOME;
    public static final BScopedFileSpace STATION_HOME;
    static final String FILE_OUT_OF_SCOPE_ERROR = "File path is out of scope: ";
    private BOrd ordInHost;
    private BOrd ordInSession;
    private BIFile[] roots;
    private boolean includeSysHome;
    private boolean includeStationHome;
    private BDirectory root;
    private FilePath scope;
    static /* synthetic */ Class class$javax$baja$file$BScopedFileSpace;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public Type getType() {
        return TYPE;
    }

    private final void init() {
        if (this.root == null) {
            BIFile bIFile = BFileSystem.INSTANCE.resolveFile(this.scope);
            if (!bIFile.isDirectory()) {
                throw new IllegalStateException("Illegal scope, not a directory: " + this.scope.getBody());
            }
            BDirectory bDirectory = (BDirectory)bIFile;
            this.ordInHost = this.ordInSession = BOrd.make(this.scope);
            ArrayList<BIFile> arrayList = new ArrayList<BIFile>();
            this.includeSysHome = this.inDirectory(bDirectory, new FilePath("!"));
            boolean bl = false;
            if (this.includeSysHome || this.inDirectory(bDirectory, new FilePath("^"))) {
                bl = this.includeStationHome = true;
            }
            if (this.includeSysHome) {
                arrayList.add(BFileSystem.INSTANCE.getSysHome());
            }
            if (this.includeStationHome) {
                arrayList.add(BFileSystem.INSTANCE.getStationHome());
            }
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                if (!this.isBlacklisted(bIFileArray[n])) {
                    arrayList.add(bIFileArray[n]);
                }
                ++n;
            }
            this.roots = arrayList.toArray(new BIFile[arrayList.size()]);
            this.root = bDirectory;
        }
    }

    private final boolean inDirectory(BDirectory bDirectory, FilePath filePath) {
        FilePath filePath2 = filePath;
        BDirectory bDirectory2 = BFileSystem.INSTANCE.getSysHome();
        BDirectory bDirectory3 = BFileSystem.INSTANCE.getStationHome();
        boolean bl = false;
        if (this.includeSysHome && bDirectory2 != null) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (this.includeStationHome && bDirectory3 != null) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        while (filePath2 != null) {
            BIFile bIFile = null;
            try {
                bIFile = BFileSystem.INSTANCE.resolveFile(filePath2);
            }
            catch (Exception exception) {
                bIFile = null;
            }
            if (bIFile != null) {
                if (this.isBlacklisted(bIFile)) {
                    return false;
                }
                if (bDirectory.equals(bIFile) || bl2 && bDirectory2.equals(bIFile) || bl4 && bDirectory3.equals(bIFile)) {
                    return true;
                }
                filePath2 = bIFile.getFilePath().getParent();
                continue;
            }
            filePath2 = filePath2.getParent();
        }
        return false;
    }

    public boolean inScope(FilePath filePath) {
        this.init();
        return this.inDirectory(this.root, filePath);
    }

    public boolean isBlacklisted(BIFile bIFile) {
        return false;
    }

    protected FilePath scopedPathToAbsPath(FilePath filePath) {
        switch (filePath.getAbsoluteMode()) {
            case 0: {
                return this.scope.merge(filePath);
            }
            case 2: {
                return this.scope.merge(new FilePath(filePath.getScheme(), filePath.getBody().substring(1)));
            }
            case 3: 
            case 4: {
                if (!this.inScope(filePath)) break;
                return filePath;
            }
        }
        return null;
    }

    public FilePath getScope() {
        return this.scope;
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        FilePath filePath2 = this.scopedPathToAbsPath(filePath);
        if (filePath2 == null || !this.inScope(filePath2)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + filePath.getBody());
        }
        return BFileSystem.INSTANCE.makeDir(filePath2, context);
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        FilePath filePath2 = this.scopedPathToAbsPath(filePath);
        if (filePath2 == null || !this.inScope(filePath2)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + filePath.getBody());
        }
        return BFileSystem.INSTANCE.makeFile(filePath2, context);
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        FilePath filePath3 = this.scopedPathToAbsPath(filePath);
        if (filePath3 == null || !this.inScope(filePath3)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + filePath.getBody());
        }
        FilePath filePath4 = null;
        if (filePath2.getBody().indexOf(47) < 0 || filePath2.isRelative()) {
            filePath4 = filePath2;
        } else {
            filePath4 = this.scopedPathToAbsPath(filePath2);
            if (filePath4 == null || !this.inScope(filePath4)) {
                throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + filePath2.getBody());
            }
        }
        BFileSystem.INSTANCE.move(filePath3, filePath4, context);
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        FilePath filePath2 = this.scopedPathToAbsPath(filePath);
        if (filePath2 == null || !this.inScope(filePath2)) {
            return;
        }
        BFileSystem.INSTANCE.delete(filePath2, context);
    }

    public BIFile[] listFiles() {
        this.init();
        return (BIFile[])this.roots.clone();
    }

    public BIFile findFile(FilePath filePath) {
        FilePath filePath2 = this.scopedPathToAbsPath(filePath);
        if (filePath2 == null || !this.inScope(filePath2)) {
            return null;
        }
        return BFileSystem.INSTANCE.findFile(filePath2);
    }

    public BIFileStore findStore(FilePath filePath) {
        FilePath filePath2 = this.scopedPathToAbsPath(filePath);
        if (filePath2 == null || !this.inScope(filePath2)) {
            return null;
        }
        return BFileSystem.INSTANCE.findStore(filePath2);
    }

    public BIFile getChild(BIFile bIFile, String string) {
        FilePath filePath;
        BIFile bIFile2 = BFileSystem.INSTANCE.getChild(bIFile, string);
        if (bIFile2 != null && !this.inScope(filePath = bIFile2.getFilePath())) {
            return null;
        }
        return bIFile2;
    }

    public BIFile[] getChildren(BIFile bIFile) {
        int n;
        FilePath filePath = bIFile.getFilePath();
        if (!this.inScope(filePath)) {
            return NO_FILES;
        }
        BIFile[] bIFileArray = BFileSystem.INSTANCE.getChildren(bIFile);
        int n2 = 0;
        if (bIFileArray != null) {
            n2 = bIFileArray.length;
        }
        if ((n = n2) < 1) {
            return bIFileArray;
        }
        Class clazz = class$javax$baja$file$BIFile;
        if (clazz == null) {
            clazz = class$javax$baja$file$BIFile = BScopedFileSpace.class("[Ljavax.baja.file.BIFile;", false);
        }
        Array array = new Array(clazz, n);
        int n3 = 0;
        while (n3 < n) {
            if (!this.isBlacklisted(bIFileArray[n3])) {
                array.add((Object)bIFileArray[n3]);
            }
            ++n3;
        }
        return (BIFile[])array.trim();
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        this.init();
        int n = 0;
        while (n < this.roots.length) {
            if (this.roots[n].getFileName().equals(string)) {
                return this.roots[n];
            }
            ++n;
        }
        return null;
    }

    public BINavNode[] getNavChildren() {
        this.init();
        if (this == BRestrictedFileSpace.INSTANCE) {
            try {
                Context context = (Context)BFileSystem.threadLocalContext.get();
                if (context != null && (context.getUser() != null || context.getFacet("username") instanceof BString)) {
                    return new BINavNode[]{BFileSystem.INSTANCE.getSysHome(), BFileSystem.INSTANCE.getStationHome()};
                }
            }
            catch (Throwable throwable) {}
        }
        return (BINavNode[])this.roots.clone();
    }

    public BOrd getOrdInHost() {
        this.init();
        return this.ordInHost;
    }

    public BOrd getOrdInSession() {
        this.init();
        return this.ordInSession;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        BDirectory bDirectory;
        super.spy(spyWriter);
        this.init();
        spyWriter.startProps("ScopedFileSpace");
        spyWriter.prop((Object)"scopeHome", ((BLocalFileStore)this.root.getStore()).getLocalFile());
        if (this.includeSysHome) {
            bDirectory = BFileSystem.INSTANCE.getSysHome();
            spyWriter.prop((Object)"sysHome", bDirectory == null ? "null" : "" + ((BLocalFileStore)bDirectory.getStore()).getLocalFile());
        }
        if (this.includeStationHome) {
            bDirectory = BFileSystem.INSTANCE.getStationHome();
            spyWriter.prop((Object)"stationHome", bDirectory == null ? "null" : "" + ((BLocalFileStore)bDirectory.getStore()).getLocalFile());
        }
        spyWriter.prop((Object)"isFlash", Nre.getPlatform().isFlashFileSystem());
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.includeSysHome = false;
        this.includeStationHome = false;
        this.root = null;
    }

    public BScopedFileSpace(FilePath filePath, String string, LexiconText lexiconText) {
        super(string, lexiconText);
        this.this();
        this.scope = filePath;
        try {
            this.init();
        }
        catch (Exception exception) {}
    }

    static {
        Class clazz = class$javax$baja$file$BScopedFileSpace;
        if (clazz == null) {
            clazz = class$javax$baja$file$BScopedFileSpace = BScopedFileSpace.class("[Ljavax.baja.file.BScopedFileSpace;", false);
        }
        TYPE = Sys.loadType(clazz);
        SYS_HOME = new BScopedFileSpace(new FilePath("!"), "sysFileSpace", LexiconText.make("baja", "nav.sysHome"));
        STATION_HOME = new BScopedFileSpace(new FilePath("^"), "stationFileSpace", LexiconText.make("baja", "nav.stationHome"));
    }
}

