/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLocalFileStore
extends BAbstractFileStore {
    public static final Type TYPE;
    File file;
    boolean initialized;
    boolean isDirectory;
    boolean isReadonly;
    boolean isRemovable;
    int hashCode;
    static /* synthetic */ Class class$javax$baja$file$BLocalFileStore;

    public File getLocalFile() {
        return this.file;
    }

    public boolean isDirectory() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isDirectory;
    }

    public boolean isReadonly() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isReadonly;
    }

    public long getSize() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isDirectory) {
            return -1;
        }
        return this.file.length();
    }

    public BAbsTime getLastModified() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isRemovable) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make(this.file.lastModified());
    }

    protected boolean doSetLastModified(BAbsTime bAbsTime) throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.file.setLastModified(bAbsTime.getMillis());
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public void delete() throws IOException {
        try {
            FileUtil.delete(this.file);
        }
        catch (Exception exception) {
            throw new IOException("Cannot delete: " + this.file);
        }
    }

    public long getCrc() throws IOException {
        if (this.isDirectory()) {
            return -1;
        }
        return FileUtil.getCrc(this.getInputStream());
    }

    public int hashCode() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof BLocalFileStore) {
            BLocalFileStore bLocalFileStore = (BLocalFileStore)object;
            return this.file.equals(bLocalFileStore.file);
        }
        return false;
    }

    private final void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.isRemovable = this.file.getPath().equals("A:\\");
            if (this.isRemovable) {
                this.isDirectory = true;
                this.isReadonly = false;
            } else {
                this.isDirectory = this.file.isDirectory();
                this.isReadonly = this.file.canWrite() ^ true;
            }
            this.hashCode = this.file.hashCode();
        }
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BLocalFileStore(BFileSpace bFileSpace, FilePath filePath, File file) {
        super(bFileSpace, filePath);
        this.file = file;
    }

    static {
        Class clazz = class$javax$baja$file$BLocalFileStore;
        if (clazz == null) {
            clazz = class$javax$baja$file$BLocalFileStore = BLocalFileStore.class("[Ljavax.baja.file.BLocalFileStore;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

