/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.File;
import java.io.IOException;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BFileSpace
extends BSpace
implements BIDirectory,
BICategorizable,
BIProtected {
    public static final Type TYPE;
    private static final BIcon icon;
    static final BIFile[] NO_FILES;
    static /* synthetic */ Class class$javax$baja$file$BFileSpace;

    public Type getType() {
        return TYPE;
    }

    public abstract BDirectory makeDir(FilePath var1, Context var2) throws IOException;

    public final BDirectory makeDir(FilePath filePath) throws IOException {
        return this.makeDir(filePath, null);
    }

    public abstract BIFile makeFile(FilePath var1, Context var2) throws IOException;

    public final BIFile makeFile(FilePath filePath) throws IOException {
        return this.makeFile(filePath, null);
    }

    public abstract void move(FilePath var1, FilePath var2, Context var3) throws IOException;

    public final void move(FilePath filePath, FilePath filePath2) throws IOException {
        this.move(filePath, filePath2, null);
    }

    public abstract void delete(FilePath var1, Context var2) throws IOException;

    public final void delete(FilePath filePath) throws IOException {
        this.delete(filePath, null);
    }

    public BOrd getAbsoluteOrd(FilePath filePath) {
        return this.appendFilePathToOrd(this.getAbsoluteOrd(), filePath);
    }

    public BOrd getOrdInHost(FilePath filePath) {
        return this.appendFilePathToOrd(this.getOrdInHost(), filePath);
    }

    public BOrd getOrdInSession(FilePath filePath) {
        return this.appendFilePathToOrd(this.getOrdInSession(), filePath);
    }

    protected BOrd appendFilePathToOrd(BOrd bOrd, FilePath filePath) {
        if (bOrd == null) {
            return null;
        }
        if (bOrd.toString().length() == 0) {
            return BOrd.make(filePath);
        }
        return BOrd.make(bOrd.toString() + filePath.getBody());
    }

    public BIFile findFile(FilePath filePath) {
        BIFileStore bIFileStore = this.findStore(filePath);
        if (bIFileStore != null) {
            return this.makeFile(bIFileStore);
        }
        return null;
    }

    public abstract BIFileStore findStore(FilePath var1);

    public BIFile resolveFile(FilePath filePath) {
        BIFile bIFile = this.findFile(filePath);
        if (bIFile == null) {
            throw new UnresolvedException("" + filePath);
        }
        return bIFile;
    }

    public abstract BIFile getChild(BIFile var1, String var2);

    public abstract BIFile[] getChildren(BIFile var1);

    public BIFile makeFile(BIFileStore bIFileStore) {
        if (bIFileStore.isDirectory()) {
            return new BDirectory(bIFileStore);
        }
        String string = bIFileStore.getExtension();
        if (string != null && string.length() > 0) {
            TypeInfo typeInfo = Sys.getRegistry().getFileTypeForExtension(string);
            try {
                BIFile bIFile = (BIFile)((Object)typeInfo.getInstance());
                bIFile.setStore(bIFileStore);
                return bIFile;
            }
            catch (Throwable throwable) {
                FileUtil.log.error("Cannot create file " + typeInfo + " for ext " + string, throwable);
            }
        }
        return new BDataFile(bIFileStore);
    }

    public BPermissions getPermissionsFor(FilePath filePath, Context context) {
        BPermissions bPermissions = BPermissions.all;
        if (context == null || context.getUser() == null) {
            return bPermissions;
        }
        try {
            BLocalFileStore bLocalFileStore = new BLocalFileStore(this, filePath, new File("dummy"));
            BDataFile bDataFile = new BDataFile(bLocalFileStore);
            return context.getUser().getPermissionsFor(bDataFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bPermissions;
        }
    }

    public void checkReadPermission(FilePath filePath, Context context) {
        if (!this.getPermissionsFor(filePath, context).hasOperatorRead()) {
            throw new PermissionException("Missing operator read");
        }
    }

    public void checkWritePermission(FilePath filePath, Context context) {
        if (!this.getPermissionsFor(filePath, context).hasOperatorWrite()) {
            throw new PermissionException("Missing operator write");
        }
    }

    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getNavOrd());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(this.getNavOrd());
    }

    public BPermissions getPermissions(Context context) {
        if (context != null && context.getUser() != null) {
            return context.getUser().getPermissionsFor(this);
        }
        return BPermissions.all;
    }

    public boolean canRead(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().hasOperatorWrite();
    }

    public boolean canInvoke(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().hasOperatorInvoke();
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("workbench:DirectoryList");
        agentList.toTop("hx:HxDirectoryView");
        agentList.toBottom("web:FileUploadView");
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BFileSpace(String string, LexiconText lexiconText) {
        super(string, lexiconText);
    }

    public BFileSpace(String string) {
        super(string);
    }

    static {
        Class clazz = class$javax$baja$file$BFileSpace;
        if (clazz == null) {
            clazz = class$javax$baja$file$BFileSpace = BFileSpace.class("[Ljavax.baja.file.BFileSpace;", false);
        }
        TYPE = Sys.loadType(clazz);
        icon = BIcon.std("drive.png");
        NO_FILES = new BIFile[0];
    }
}

