/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractFile
extends BObject
implements BIFile {
    private static final BIcon icon = BIcon.std("file.png");
    public static final Type TYPE;
    private BIFileStore store;
    private boolean pendingMove;
    static /* synthetic */ Class class$javax$baja$file$BAbstractFile;

    public BIFileStore getStore() {
        return this.store;
    }

    public void setStore(BIFileStore bIFileStore) {
        if (bIFileStore == null) {
            throw new NullPointerException("null store");
        }
        this.store = bIFileStore;
    }

    public BFileSpace getFileSpace() {
        return this.getStore().getFileSpace();
    }

    public FilePath getFilePath() {
        return this.getStore().getFilePath();
    }

    public String getFileName() {
        return this.getStore().getFileName();
    }

    public String getExtension() {
        return this.getStore().getExtension();
    }

    public boolean isDirectory() {
        return this.getStore().isDirectory();
    }

    public long getSize() {
        return this.getStore().getSize();
    }

    public BAbsTime getLastModified() {
        return this.getStore().getLastModified();
    }

    public boolean setLastModified(BAbsTime bAbsTime) throws IOException {
        if (this.getStore() instanceof BAbstractFileStore) {
            return ((BAbstractFileStore)this.getStore()).setLastModified(bAbsTime);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReadonly() {
        return this.getStore().isReadonly();
    }

    public InputStream getInputStream() throws IOException {
        return this.getStore().getInputStream();
    }

    public byte[] read() throws IOException {
        return this.getStore().read();
    }

    public void delete() throws IOException {
        this.getFileSpace().delete(this.getFilePath());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getStore().getOutputStream();
    }

    public void write(byte[] byArray) throws IOException {
        this.getStore().write(byArray);
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public long getCrc() throws IOException {
        if (this.getStore() instanceof BAbstractFileStore) {
            return ((BAbstractFileStore)this.getStore()).getCrc();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isMounted() {
        BFileSpace bFileSpace = this.getFileSpace();
        boolean bl = false;
        if (bFileSpace != null && bFileSpace.isMounted()) {
            bl = true;
        }
        return bl;
    }

    public BHost getHost() {
        BFileSpace bFileSpace = this.getFileSpace();
        if (bFileSpace == null) {
            return null;
        }
        return bFileSpace.getHost();
    }

    public BISession getSession() {
        BFileSpace bFileSpace = this.getFileSpace();
        if (bFileSpace == null) {
            return null;
        }
        return bFileSpace.getSession();
    }

    public BSpace getSpace() {
        return this.getFileSpace();
    }

    public BOrd getAbsoluteOrd() {
        BFileSpace bFileSpace = this.getFileSpace();
        if (bFileSpace == null) {
            return null;
        }
        return bFileSpace.getAbsoluteOrd(this.getFilePath());
    }

    public BOrd getOrdInHost() {
        BFileSpace bFileSpace = this.getFileSpace();
        if (bFileSpace == null) {
            return null;
        }
        return bFileSpace.getOrdInHost(this.getFilePath());
    }

    public BOrd getOrdInSession() {
        BFileSpace bFileSpace = this.getFileSpace();
        if (bFileSpace == null) {
            return null;
        }
        return bFileSpace.getOrdInSession(this.getFilePath());
    }

    public BOrd getOrdInSpace() {
        return this.getOrdInSession();
    }

    public boolean isPendingMove() {
        return this.pendingMove;
    }

    public void setPendingMove(boolean bl) {
        this.pendingMove = bl;
    }

    public String getNavName() {
        return this.getFileName();
    }

    public String getNavDisplayName(Context context) {
        return this.getNavName();
    }

    public BINavNode getNavParent() {
        FilePath filePath = this.getFilePath().getParent();
        if (filePath != null) {
            return this.getFileSpace().findFile(filePath);
        }
        return this.getFileSpace();
    }

    public BINavNode resolveNavChild(String string) {
        BINavNode bINavNode = this.getNavChild(string);
        if (bINavNode == null) {
            throw new UnresolvedException(string);
        }
        return bINavNode;
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getNavOrd());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(this.getNavOrd());
    }

    public BPermissions getPermissions(Context context) {
        return this.getStore().getPermissions(this, context);
    }

    public boolean canRead(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().has(1);
    }

    public boolean canWrite(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().has(2);
    }

    public boolean canInvoke(OrdTarget ordTarget) {
        return ordTarget.getPermissionsForTarget().has(4);
    }

    public String toPathString() {
        BOrd bOrd = this.getOrdInSession();
        if (bOrd != null) {
            return bOrd.toString();
        }
        return "?" + this.getType() + '?';
    }

    public int compareTo(Object object) {
        BIFile bIFile = (BIFile)object;
        if (this.isDirectory()) {
            if (!bIFile.isDirectory()) {
                return -1;
            }
            return this.getFileName().compareToIgnoreCase(bIFile.getFileName());
        }
        if (bIFile.isDirectory()) {
            return 1;
        }
        return this.getFileName().compareToIgnoreCase(bIFile.getFileName());
    }

    public String toString(Context context) {
        if (this.getStore() == null) {
            return super.toString(context);
        }
        return this.getStore().toString(context);
    }

    public int hashCode() {
        return this.getStore().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof BIFile) {
            BIFile bIFile = (BIFile)object;
            return this.getStore().equals(bIFile.getStore());
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        try {
            BFileSystem.threadLocalContext.set(spyWriter.getContext());
            super.spy(spyWriter);
            spyWriter.startProps();
            spyWriter.trTitle("File", 2);
            spyWriter.prop((Object)"fileName", this.getFileName());
            spyWriter.prop((Object)"store.type", this.getStore().getType());
            spyWriter.prop((Object)"store.toString", this.getStore().toString());
            spyWriter.prop((Object)"isDirectory", this.isDirectory());
            spyWriter.prop((Object)"readonly", this.isReadonly());
            spyWriter.prop((Object)"size", "" + this.getSize());
            spyWriter.prop((Object)"lastModified", this.getLastModified());
            spyWriter.trTitle("SpaceNode", 2);
            spyWriter.prop((Object)"isMounted", this.isMounted());
            spyWriter.prop((Object)"host", this.getHost());
            spyWriter.prop((Object)"session", this.getSession());
            spyWriter.prop((Object)"space", this.getSpace());
            spyWriter.prop((Object)"absoluteOrd", this.getAbsoluteOrd());
            spyWriter.prop((Object)"ordInHost", this.getOrdInHost());
            spyWriter.prop((Object)"ordInSession", this.getOrdInSession());
            spyWriter.prop((Object)"ordInSpace", this.getOrdInSpace());
            spyWriter.prop((Object)"navOrd", this.getNavOrd());
            spyWriter.prop((Object)"permissions", this.getPermissions(null));
            if (this.getStore() instanceof BAbstractFileStore) {
                spyWriter.prop((Object)"crc", String.valueOf(this.getCrc()));
            }
            spyWriter.endProps();
            BINavNode[] bINavNodeArray = this.getNavChildren();
            if (bINavNodeArray != null && bINavNodeArray.length > 0) {
                spyWriter.startTable(false);
                spyWriter.trTitle("Children", 1);
                int n = 0;
                while (n < bINavNodeArray.length) {
                    spyWriter.tr("<a href='" + bINavNodeArray[n].getNavName() + "'>" + bINavNodeArray[n].toString() + "</a>");
                    ++n;
                }
                spyWriter.endTable();
            }
            Object var3_6 = null;
            BFileSystem.threadLocalContext.set(null);
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            BFileSystem.threadLocalContext.set(null);
            throw throwable;
        }
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAbstractFile(BIFileStore bIFileStore) {
        this.setStore(bIFileStore);
    }

    public BAbstractFile() {
    }

    static {
        Class clazz = class$javax$baja$file$BAbstractFile;
        if (clazz == null) {
            clazz = class$javax$baja$file$BAbstractFile = BAbstractFile.class("[Ljavax.baja.file.BAbstractFile;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

