/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.IOException;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ByteBuffer;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualComponentSpace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueByteBuffer
extends ByteBuffer {
    static final int VERSION = 1;
    protected static final int PROPERTY_SLOT = 1;
    protected static final int ACTION_SLOT = 2;
    protected static final int TOPIC_SLOT = 3;
    private boolean encodeTransients;
    private Context encodeContext;

    public static ValueByteBuffer make(byte[] byArray, int n) {
        return new ValueByteBuffer(byArray, n);
    }

    public static ValueByteBuffer make(byte[] byArray) {
        return new ValueByteBuffer(byArray);
    }

    public static ValueByteBuffer make(int n) {
        return new ValueByteBuffer(n);
    }

    public static ValueByteBuffer make() {
        return new ValueByteBuffer();
    }

    public static byte[] marshal(BObject bObject) throws IOException {
        ValueByteBuffer valueByteBuffer = new ValueByteBuffer();
        valueByteBuffer.encode(bObject);
        return valueByteBuffer.toByteArray();
    }

    public static BObject unmarshal(byte[] byArray) throws Exception {
        ValueByteBuffer valueByteBuffer = new ValueByteBuffer(byArray);
        return valueByteBuffer.decode();
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean bl) {
        boolean bl2 = this.encodeTransients;
        this.encodeTransients = bl;
        return bl2;
    }

    public void setEncodeContext(Context context) {
        this.encodeContext = context;
    }

    public void encode(BObject bObject) throws IOException {
        this.encode(null, bObject, Integer.MAX_VALUE);
    }

    public void encode(String string, BObject bObject, int n) throws IOException {
        this.writeByte(1);
        this.writeBoolean(true);
        this.writeByte(1);
        this.wname(string);
        this.wflags(-1);
        this.wfacets(null);
        this.wtype(bObject);
        if (bObject.isComponent()) {
            BComponent bComponent = (BComponent)bObject;
            Object object = bComponent.getHandle();
            this.whandle(object);
            BCategoryMask bCategoryMask = bComponent.getCategoryMask();
            this.wcategories(bCategoryMask);
            this.writeBoolean(false);
        }
        this.encodeValue(bObject, n);
    }

    public BObject decode() throws Exception {
        byte by = this.readByte();
        if (by != 1) {
            throw new IllegalStateException("Version mismatch " + by + " != 1");
        }
        BObject bObject = this.parseSlot(null);
        if (bObject == null) {
            throw new IllegalStateException("Error parsing value");
        }
        return bObject;
    }

    protected void encodeValueSpecial(BObject bObject) throws IOException {
    }

    protected void decodeValueSpecial(BObject bObject) throws Exception {
    }

    private final void encodeSlot(BObject bObject, Slot slot, boolean bl, int n) throws IOException {
        if (slot == null) {
            this.writeBoolean(false);
            return;
        }
        int n2 = this.getSlotFlags(bObject, slot);
        boolean bl2 = slot.isProperty();
        Property property = bl2 ? (Property)slot : null;
        BValue bValue = bl2 ? this.getPropertyValue(bObject, property) : null;
        boolean bl3 = false;
        if (!this.encodeTransients && (n2 & 2) != 0) {
            if (bValue != null && slot.isFrozen() && bValue.isComponent()) {
                bl3 = false;
            } else if (bl2 && slot.isFrozen() && n2 != slot.getDefaultFlags()) {
                bl3 = true;
            } else {
                this.writeBoolean(false);
                return;
            }
        }
        boolean bl4 = false;
        if (bl2 && !bl3) {
            boolean bl5 = false;
            if (slot.isFrozen() && !bValue.isComponent() && property.isEquivalentToDefaultValue(bValue)) {
                bl5 = true;
            }
            bl4 = bl5;
        } else {
            bl4 = true;
        }
        if (n2 == slot.getDefaultFlags() && bl4) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        boolean bl6 = false;
        if (slot.isProperty()) {
            this.writeByte(1);
        } else if (slot.isAction()) {
            bl6 = true;
            this.writeByte(2);
        } else if (slot.isTopic()) {
            bl6 = true;
            this.writeByte(3);
        } else {
            throw new IllegalStateException("Slot is not a property, action, or topic");
        }
        this.wname(slot.getName());
        this.wflags(n2);
        if (bl6) {
            return;
        }
        BFacets bFacets = slot.getFacets();
        this.wfacets(bFacets);
        this.wtype(bValue);
        if (bValue instanceof BComponent) {
            BComponent bComponent = (BComponent)bValue;
            Object object = bComponent.getHandle();
            this.whandle(object);
            BCategoryMask bCategoryMask = bComponent.getCategoryMask();
            this.wcategories(bCategoryMask);
            boolean bl7 = false;
            if (n == 0 || bComponent.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                bl7 = true;
            }
            this.writeBoolean(bl7);
        }
        if (property != null && !bl4) {
            this.encodeValue(bValue, n - 1);
        } else {
            this.writeBoolean(false);
        }
    }

    private final void encodeValue(BObject bObject, int n) throws IOException {
        this.encodeValueSpecial(bObject);
        if (bObject.isSimple()) {
            this.writeBoolean(true);
            this.wvalue((BSimple)bObject);
        } else if (!bObject.getType().is(BStatusValue.TYPE) || !this.encodeStatusValue(bObject)) {
            if (bObject.isComponent() && n >= 0 || (bObject.isComplex() || bObject instanceof BIPropertyContainer) && !bObject.isComponent()) {
                SlotCursor slotCursor = bObject.isComplex() ? ((BComplex)bObject).getSlots() : ((BIPropertyContainer)((Object)bObject)).getSlots();
                while (slotCursor.next()) {
                    this.writeBoolean(true);
                    this.encodeSlot(bObject, slotCursor.slot(), false, n);
                }
                this.writeBoolean(false);
            } else {
                this.writeBoolean(false);
            }
        }
    }

    private final int getSlotFlags(BObject bObject, Slot slot) {
        if (bObject instanceof BIPropertyContainer) {
            return ((BIPropertyContainer)((Object)bObject)).getFlags(slot);
        }
        if (bObject instanceof BComplex) {
            return ((BComplex)bObject).getFlags(slot);
        }
        return -1;
    }

    private final BValue getPropertyValue(BObject bObject, Property property) {
        if (bObject instanceof BIPropertyContainer) {
            return ((BIPropertyContainer)((Object)bObject)).get(property);
        }
        if (bObject instanceof BComplex) {
            return ((BComplex)bObject).get(property);
        }
        return null;
    }

    void parseSlots(BObject bObject) throws Exception {
        while (this.readBoolean()) {
            this.parseSlot(bObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BObject parseSlot(BObject bObject) throws Exception {
        boolean bl;
        BObject bObject2;
        block32: {
            Property property;
            if (!this.readBoolean()) {
                return null;
            }
            byte by = this.readByte();
            if (by != 1 && by != 2 && by != 3) {
                throw new IllegalStateException("Unknown element <" + by + '>');
            }
            String string = this.rname();
            int n = this.rflags();
            BFacets bFacets = null;
            BTypeSpec bTypeSpec = null;
            Object object = null;
            BCategoryMask bCategoryMask = null;
            boolean bl2 = false;
            if (by == 1) {
                bFacets = this.rfacets();
                bTypeSpec = this.rtype();
                if (bTypeSpec != null && bTypeSpec.getResolvedType().is(BComponent.TYPE)) {
                    object = this.rhandle();
                    bCategoryMask = this.rcategories();
                    bl2 = this.readBoolean();
                }
            }
            Slot slot = null;
            if (bObject != null) {
                if (string == null) {
                    throw new IllegalStateException("Missing name attribute");
                }
                Slot slot2 = slot = bObject.isComplex() ? ((BComplex)bObject).getSlot(string) : ((BIPropertyContainer)((Object)bObject)).getSlot(string);
            }
            if (slot != null) {
                if (n >= 0) {
                    try {
                        if (bObject.isComplex()) {
                            ((BComplex)bObject).setFlags(slot, n, Context.decoding);
                        } else {
                            ((BIPropertyContainer)((Object)bObject)).setFlags(slot, n, Context.decoding);
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
                if (!slot.isProperty()) {
                    return null;
                }
            } else {
                if (by == 2) {
                    System.out.println("Missing frozen action: " + bObject.getType() + ' ' + string);
                    return null;
                }
                if (by == 3) {
                    System.out.println("Missing frozen topic: " + string);
                    return null;
                }
            }
            if ((bObject2 = this.newInstance(string, property = (Property)slot, bTypeSpec)) == null) {
                return null;
            }
            this.decodeValueSpecial(bObject2);
            bl = false;
            if (bObject2.isSimple()) {
                if (!this.readBoolean()) return null;
                bObject2 = this.rvalue((BSimple)bObject2);
            } else if (bObject2.getType() == BStatusNumeric.TYPE || bObject2.getType() == BStatusBoolean.TYPE || bObject2.getType() == BStatusEnum.TYPE || bObject2.getType() == BStatusString.TYPE) {
                bl = true;
                if (!this.readBoolean()) return null;
                bObject2 = this.decodeStatusValue(bObject2);
            }
            if (bObject2.isComponent()) {
                ((ComponentSlotMap)bObject2.fw(1)).setHandle(object);
                if (!bl2) {
                    ((ComponentSlotMap)bObject2.fw(1)).setBrokerPropsLoaded(true);
                }
                if (bCategoryMask != null) {
                    ((BComponent)bObject2).setCategoryMask(bCategoryMask, Context.decoding);
                }
            }
            if (bObject != null) {
                if (property != null) {
                    if (!property.isFrozen()) {
                        throw new IllegalStateException("Duplicate slot " + bObject.getType().getTypeName() + '.' + string);
                    }
                    try {
                        if (bObject.isComplex()) {
                            ((BComplex)bObject).set(property, (BValue)bObject2, Context.decoding);
                            break block32;
                        }
                        ((BIPropertyContainer)((Object)bObject)).set(property, (BValue)bObject2, Context.decoding);
                    }
                    catch (Exception exception) {
                        System.out.println("Cannot set property " + bObject.getType().getTypeName() + '.' + string + ": " + exception);
                    }
                } else if (bObject instanceof BIPropertyContainer) {
                    ((BIPropertyContainer)((Object)bObject)).add(string, (BValue)bObject2, n, bFacets, Context.decoding);
                } else {
                    System.out.println("Missing slot " + bObject.getType().getTypeName() + '.' + string);
                }
            }
        }
        if (!bObject2.isComplex() && !(bObject2 instanceof BIPropertyContainer) || bl) return bObject2;
        this.parseSlots(bObject2);
        return bObject2;
    }

    private final BObject newInstance(String string, Property property, BTypeSpec bTypeSpec) {
        if (bTypeSpec == null || bTypeSpec.isNull()) {
            if (property != null) {
                return property.getDefaultValue();
            }
            System.out.println("Missing frozen property: " + string);
            return null;
        }
        try {
            return bTypeSpec.getInstance();
        }
        catch (TypeNotFoundException typeNotFoundException) {
            System.out.println("Type \"" + typeNotFoundException.getMessage() + "\" not found: " + string);
            return null;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Cannot instantiate type '" + bTypeSpec + '\'');
        }
    }

    private final boolean encodeStatusValue(BObject bObject) throws IOException {
        BStatusValue bStatusValue;
        BStatus bStatus = null;
        if (bObject.getType() == BStatusNumeric.TYPE) {
            this.writeBoolean(true);
            bStatusValue = (BStatusNumeric)bObject;
            this.writeDouble(((BStatusNumeric)bStatusValue).getValue());
            bStatus = bStatusValue.getStatus();
        } else if (bObject.getType() == BStatusBoolean.TYPE) {
            this.writeBoolean(true);
            bStatusValue = (BStatusBoolean)bObject;
            this.writeBoolean(((BStatusBoolean)bStatusValue).getValue());
            bStatus = bStatusValue.getStatus();
        } else if (bObject.getType() == BStatusEnum.TYPE) {
            this.writeBoolean(true);
            bStatusValue = (BStatusEnum)bObject;
            this.wtype(((BStatusEnum)bStatusValue).getValue());
            ((BStatusEnum)bStatusValue).getValue().encode(this);
            bStatus = bStatusValue.getStatus();
        } else if (bObject.getType() == BStatusString.TYPE) {
            this.writeBoolean(true);
            bStatusValue = (BStatusString)bObject;
            this.writeUTF(((BStatusString)bStatusValue).getValue());
            bStatus = bStatusValue.getStatus();
        } else {
            return false;
        }
        boolean bl = bStatus.equals(BStatus.DEFAULT) ^ true;
        this.writeBoolean(bl);
        if (bl) {
            bStatus.encode(this);
        }
        return true;
    }

    private final BObject decodeStatusValue(BObject bObject) throws IOException {
        if (bObject.getType() == BStatusNumeric.TYPE) {
            ((BStatusNumeric)bObject).setValue(this.readDouble());
        } else if (bObject.getType() == BStatusBoolean.TYPE) {
            ((BStatusBoolean)bObject).setValue(this.readBoolean());
        } else if (bObject.getType() == BStatusEnum.TYPE) {
            BTypeSpec bTypeSpec = this.rtype();
            BSimple bSimple = (BSimple)bTypeSpec.getInstance();
            ((BStatusEnum)bObject).setValue((BEnum)bSimple.decode(this));
        } else if (bObject.getType() == BStatusString.TYPE) {
            ((BStatusString)bObject).setValue(this.readUTF());
        } else {
            return bObject;
        }
        if (this.readBoolean()) {
            ((BStatusValue)bObject).setStatus((BStatus)BStatus.DEFAULT.decode(this));
        }
        return bObject;
    }

    private final ValueByteBuffer wname(String string) throws IOException {
        boolean bl = false;
        if (string != null) {
            bl = true;
        }
        this.writeBoolean(bl);
        if (string != null) {
            this.writeUTF(string);
        }
        return this;
    }

    private final String rname() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    private final ValueByteBuffer wtype(BObject bObject) throws IOException {
        boolean bl = false;
        if (bObject != null) {
            bl = true;
        }
        boolean bl2 = bl;
        this.writeBoolean(bl2);
        if (bl2) {
            bObject.getType().getTypeSpec().encode(this);
        }
        return this;
    }

    private final BTypeSpec rtype() throws IOException {
        if (this.readBoolean()) {
            return (BTypeSpec)BTypeSpec.DEFAULT.decode(this);
        }
        return null;
    }

    private final ValueByteBuffer wflags(int n) throws IOException {
        this.writeInt(n);
        return this;
    }

    private final int rflags() throws IOException {
        return this.readInt();
    }

    private final ValueByteBuffer whandle(Object object) throws IOException {
        boolean bl = false;
        if (object != null) {
            bl = true;
        }
        boolean bl2 = bl;
        this.writeBoolean(bl2);
        if (bl2) {
            this.writeUTF(String.valueOf(object));
        }
        return this;
    }

    private final Object rhandle() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    private final ValueByteBuffer wcategories(BCategoryMask bCategoryMask) throws IOException {
        boolean bl = false;
        if (bCategoryMask != null && !bCategoryMask.isNull()) {
            bl = true;
        }
        boolean bl2 = bl;
        this.writeBoolean(bl2);
        if (bl2) {
            bCategoryMask.encode(this);
        }
        return this;
    }

    private final BCategoryMask rcategories() throws IOException {
        if (this.readBoolean()) {
            return (BCategoryMask)BCategoryMask.DEFAULT.decode(this);
        }
        return BCategoryMask.NULL;
    }

    private final ValueByteBuffer wfacets(BFacets bFacets) throws IOException {
        boolean bl = false;
        if (bFacets != null && !bFacets.isNull()) {
            bl = true;
        }
        boolean bl2 = bl;
        this.writeBoolean(bl2);
        if (bl2) {
            bFacets.encode(this);
        }
        return this;
    }

    private final BFacets rfacets() throws IOException {
        if (this.readBoolean()) {
            return (BFacets)BFacets.DEFAULT.decode(this);
        }
        return BFacets.NULL;
    }

    private final ValueByteBuffer wvalue(BSimple bSimple) throws IOException {
        if (bSimple instanceof BIContextEncodable) {
            ((BIContextEncodable)((Object)bSimple)).encode(this, this.encodeContext);
        } else {
            bSimple.encode(this);
        }
        return this;
    }

    private final BSimple rvalue(BSimple bSimple) throws IOException {
        if (bSimple instanceof BIContextEncodable) {
            return (BSimple)((BIContextEncodable)((Object)bSimple)).decode(this, this.encodeContext);
        }
        return (BSimple)bSimple.decode(this);
    }

    private final /* synthetic */ void this() {
        this.encodeContext = null;
    }

    protected ValueByteBuffer(byte[] byArray, int n) {
        super(byArray, n);
        this.this();
    }

    protected ValueByteBuffer(byte[] byArray) {
        super(byArray);
        this.this();
    }

    protected ValueByteBuffer(int n) {
        super(n);
        this.this();
    }

    protected ValueByteBuffer() {
        this(64);
    }
}

