/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Calendar;
import java.util.HashMap;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class TimeFormat {
    static final int SHOW_DATE = 1;
    static final int SHOW_TIME = 2;
    static final int SHOW_SECONDS = 4;
    static final int SHOW_MILLIS = 8;
    static final int SHOW_ZONE = 16;
    static final int[] SHOW;
    public static final int YEAR_2 = 1;
    public static final int YEAR_4 = 2;
    public static final int MON_1 = 3;
    public static final int MON_2 = 4;
    public static final int MON_TAG = 5;
    public static final int MON = 18;
    public static final int DAY_1 = 6;
    public static final int DAY_2 = 7;
    public static final int HOUR_12_1 = 8;
    public static final int HOUR_12_2 = 9;
    public static final int HOUR_24_1 = 10;
    public static final int HOUR_24_2 = 11;
    public static final int MIN = 12;
    public static final int AM_PM = 13;
    public static final int SEC = 14;
    public static final int ZONE_TAG = 15;
    public static final int WEEK_1 = 16;
    public static final int WEEK_2 = 17;
    public static final int ZONE_OFFSET = 19;
    public static final int WEEK_YEAR = 20;
    private static String[] PATTERNS;
    static HashMap cache;
    static String defaultPattern;
    static final String fallbackPattern = "DD-MMM-YY h:mm:ss a z";
    public static final String TIME_FORMAT = "timeFormat";
    int[] pattern;

    public static String format(BAbsTime bAbsTime, String string, Context context) {
        context = BFacets.make(context.getFacets(), BFacets.make(TIME_FORMAT, BString.make(string)));
        return TimeFormat.format(bAbsTime, context);
    }

    public static String format(BAbsTime bAbsTime, String string) {
        BFacets bFacets = BFacets.make(TIME_FORMAT, BString.make(string));
        return TimeFormat.format(bAbsTime, (Context)bFacets);
    }

    public static String format(BAbsTime bAbsTime, Context context) {
        bAbsTime = TimeFormat.toTimeZone(bAbsTime, context);
        int n = TimeFormat.toShowMask(19, context);
        n = TimeFormat.normalizeShowMask(n);
        return TimeFormat.make(context).format(bAbsTime, n, context);
    }

    public static String formatTime(BAbsTime bAbsTime, Context context) {
        bAbsTime = TimeFormat.toTimeZone(bAbsTime, context);
        int n = TimeFormat.toShowMask(2, context);
        n |= 2;
        n &= 0xFFFFFFFE;
        n = TimeFormat.normalizeShowMask(n);
        return TimeFormat.make(context).format(bAbsTime, n, context);
    }

    public static String formatDate(BAbsTime bAbsTime, Context context) {
        bAbsTime = TimeFormat.toTimeZone(bAbsTime, context);
        int n = TimeFormat.toShowMask(1, context);
        n |= 1;
        n &= 0xFFFFFFFD;
        n = TimeFormat.normalizeShowMask(n);
        return TimeFormat.make(context).format(bAbsTime, n, context);
    }

    public static String format(BTime bTime, Context context) {
        int n = TimeFormat.toShowMask(2, context);
        n &= 0xFFFFFFFE;
        n &= 0xFFFFFFEF;
        n = TimeFormat.normalizeShowMask(n);
        return TimeFormat.make(context).format(bTime, n, context);
    }

    public static int[] pattern(Context context) {
        int n = TimeFormat.toShowMask(19, context);
        return TimeFormat.make(context).pattern(n);
    }

    public static void setDefaultPattern(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        defaultPattern = string;
    }

    private static final BAbsTime toTimeZone(BAbsTime bAbsTime, Context context) {
        BTimeZone bTimeZone;
        if (context != null && (bTimeZone = (BTimeZone)context.getFacet("TimeZone")) != null) {
            return BAbsTime.make(bAbsTime, bTimeZone);
        }
        return bAbsTime;
    }

    static TimeFormat make(Context context) {
        Object object;
        String string = null;
        if (context != null && (object = context.getFacet(TIME_FORMAT)) != null) {
            string = object.toString();
        }
        if (string == null || string.length() == 0) {
            string = defaultPattern;
        }
        if (string == null || string.length() == 0) {
            string = Lexicon.make(Sys.getBajaModule(), context).get(TIME_FORMAT);
        }
        if (string == null || string.length() == 0) {
            System.out.println("ERROR: Missing baja:timeFormat lexicon entry");
            string = fallbackPattern;
        }
        if ((object = (TimeFormat)cache.get(string)) == null) {
            object = new TimeFormat(string);
            cache.put(string, object);
        }
        return object;
    }

    int toCode(int n, int n2) {
        switch (n) {
            case 89: {
                int n3 = 0;
                if (n2 <= 2) {
                    n3 = 1;
                }
                return 2 - n3;
            }
            case 77: {
                switch (n2) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                }
                return 18;
            }
            case 68: {
                int n4 = 0;
                if (n2 == 1) {
                    n4 = 1;
                }
                return 7 - n4;
            }
            case 104: {
                int n5 = 0;
                if (n2 == 1) {
                    n5 = 1;
                }
                return 9 - n5;
            }
            case 72: {
                int n6 = 0;
                if (n2 == 1) {
                    n6 = 1;
                }
                return 11 - n6;
            }
            case 109: {
                return 12;
            }
            case 115: {
                return 14;
            }
            case 97: {
                return 13;
            }
            case 122: {
                return 15;
            }
            case 90: {
                return 19;
            }
            case 87: {
                int n7 = 0;
                if (n2 == 1) {
                    n7 = 1;
                }
                return 17 - n7;
            }
            case 119: {
                return 20;
            }
        }
        return n;
    }

    int[] pattern(int n) {
        int[] nArray = new int[this.pattern.length];
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.pattern.length) {
            int n6 = this.pattern[n5];
            if (n6 >= SHOW.length) {
                n3 = n6;
            } else if ((SHOW[n6] & n) == 0) {
                n3 = -1;
            } else {
                if (++n4 > 1 && n3 != -1) {
                    nArray[n2++] = n3;
                    n3 = -1;
                }
                ++n4;
                nArray[n2++] = n6;
            }
            ++n5;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    String format(BTime bTime, int n, Context context) {
        return this.format(null, 0, BMonth.january, 0, bTime.getHour(), bTime.getMinute(), bTime.getSecond(), bTime.getMillisecond(), BTimeZone.getLocal(), n, context);
    }

    String format(BAbsTime bAbsTime, int n, Context context) {
        return this.format(bAbsTime, bAbsTime.getYear(), bAbsTime.getMonth(), bAbsTime.getDay(), bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), bAbsTime.getMillisecond(), bAbsTime.getTimeZone(), n, context);
    }

    String format(BAbsTime bAbsTime, int n, BMonth bMonth, int n2, int n3, int n4, int n5, int n6, BTimeZone bTimeZone, int n7, Context context) {
        int n8 = bMonth.getOrdinal() + 1;
        int[] nArray = this.pattern;
        int n9 = nArray.length;
        StringBuffer stringBuffer = new StringBuffer(n9 * 4);
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n9) {
            int n14 = nArray[n13];
            if (n14 >= SHOW.length) {
                if (n10 == -1) {
                    n10 = n14;
                } else if (n11 == -1) {
                    n11 = n14;
                }
            } else if ((SHOW[n14] & n7) == 0) {
                n11 = -1;
                n10 = -1;
            } else {
                if (++n12 > 1 && n10 != -1) {
                    stringBuffer.append((char)n10);
                    if (n11 != -1) {
                        stringBuffer.append((char)n11);
                    }
                    n11 = -1;
                    n10 = -1;
                }
                ++n12;
                switch (n14) {
                    case 1: {
                        TimeFormat.pad(stringBuffer, n % 100);
                        break;
                    }
                    case 2: {
                        stringBuffer.append(n);
                        break;
                    }
                    case 3: {
                        stringBuffer.append(n8);
                        break;
                    }
                    case 4: {
                        TimeFormat.pad(stringBuffer, n8);
                        break;
                    }
                    case 5: {
                        stringBuffer.append(bMonth.getShortDisplayTag(context));
                        break;
                    }
                    case 18: {
                        stringBuffer.append(bMonth.toString(context));
                        break;
                    }
                    case 6: {
                        stringBuffer.append(n2);
                        break;
                    }
                    case 7: {
                        TimeFormat.pad(stringBuffer, n2);
                        break;
                    }
                    case 8: {
                        if (n3 == 0) {
                            stringBuffer.append("12");
                            break;
                        }
                        stringBuffer.append(n3 > 12 ? n3 - 12 : n3);
                        break;
                    }
                    case 9: {
                        if (n3 == 0) {
                            stringBuffer.append("12");
                            break;
                        }
                        TimeFormat.pad(stringBuffer, n3 > 12 ? n3 - 12 : n3);
                        break;
                    }
                    case 10: {
                        stringBuffer.append(n3);
                        break;
                    }
                    case 11: {
                        TimeFormat.pad(stringBuffer, n3);
                        break;
                    }
                    case 12: {
                        TimeFormat.pad(stringBuffer, n4);
                        break;
                    }
                    case 13: {
                        stringBuffer.append(n3 < 12 ? "AM" : "PM");
                        break;
                    }
                    case 14: {
                        TimeFormat.pad(stringBuffer, n5);
                        if ((n7 & 8) == 0) break;
                        stringBuffer.append('.');
                        if (n6 < 10) {
                            stringBuffer.append('0');
                        }
                        if (n6 < 100) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n6);
                        break;
                    }
                    case 15: {
                        stringBuffer.append(bTimeZone.getShortDisplayName(bAbsTime, context));
                        break;
                    }
                    case 19: {
                        int n15 = bAbsTime != null ? bAbsTime.getTimeZoneOffset() : bTimeZone.getUtcOffset(BAbsTime.now().getMillis());
                        if (n15 == 0) {
                            stringBuffer.append('Z');
                            break;
                        }
                        int n16 = Math.abs(n15 / 3600000);
                        int n17 = Math.abs(n15 % 3600000 / 60000);
                        if (n15 < 0) {
                            stringBuffer.append('-');
                        } else {
                            stringBuffer.append('+');
                        }
                        if (n16 < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n16);
                        stringBuffer.append(":");
                        if (n17 < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n17);
                        break;
                    }
                    case 16: {
                        stringBuffer.append(bAbsTime.getWeekday().getShortDisplayTag(context));
                        break;
                    }
                    case 17: {
                        stringBuffer.append(bAbsTime.getWeekday().getDisplayTag(context));
                        break;
                    }
                    case 20: {
                        Calendar calendar = BAbsTime.makeCalendar(n, bMonth, n2, n3, n4, n5, n6, bTimeZone, context);
                        stringBuffer.append(calendar.get(3));
                        break;
                    }
                }
                n11 = -1;
                n10 = -1;
            }
            ++n13;
        }
        return stringBuffer.toString();
    }

    static void pad(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    static int toShowMask(int n, Context context) {
        if (context != null) {
            BFacets bFacets = context.getFacets();
            n = TimeFormat.mask(n, bFacets, "showDate", 1);
            n = TimeFormat.mask(n, bFacets, "showTime", 2);
            n = TimeFormat.mask(n, bFacets, "showSeconds", 4);
            n = TimeFormat.mask(n, bFacets, "showMilliseconds", 8);
            n = TimeFormat.mask(n, bFacets, "showTimeZone", 16);
        }
        return n;
    }

    static int mask(int n, BFacets bFacets, String string, int n2) {
        BObject bObject = bFacets.getFacet(string);
        if (bObject instanceof BBoolean) {
            n = ((BBoolean)bObject).getBoolean() ? (n |= n2) : (n &= ~n2);
        }
        return n;
    }

    static int normalizeShowMask(int n) {
        if ((n & 2) == 0) {
            n &= 0xFFFFFFE3;
        }
        return n;
    }

    public static String patternToString(int n) {
        if (n < PATTERNS.length) {
            return PATTERNS[n];
        }
        return "" + (char)n;
    }

    public static String patternToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(TimeFormat.patternToString(nArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    TimeFormat(String string) {
        if (string == null) {
            string = fallbackPattern;
        }
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 0;
        char c = string.charAt(0);
        int n3 = 1;
        int n4 = 1;
        while (n4 < n) {
            char c2 = string.charAt(n4);
            if (c == c2) {
                ++n3;
            } else {
                nArray[n2++] = this.toCode(c, n3);
                c = c2;
                n3 = 1;
            }
            ++n4;
        }
        nArray[n2++] = this.toCode(c, n3);
        this.pattern = new int[n2];
        System.arraycopy(nArray, 0, this.pattern, 0, n2);
    }

    static {
        int[] nArray = new int[21];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 12;
        nArray[15] = 16;
        nArray[16] = 1;
        nArray[17] = 1;
        nArray[18] = 1;
        nArray[19] = 16;
        nArray[20] = 1;
        SHOW = nArray;
        PATTERNS = new String[]{"?", "YY", "YYYY", "M", "MM", "MMM", "D", "DD", "h", "hh", "H", "HH", "mm", "a", "ss", "z", "W", "WW", "MMMM", "Z", "w"};
        cache = new HashMap();
        defaultPattern = null;
    }
}

