/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class StringEscapeUtils {
    public static String escapeJava(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, false);
    }

    private static final String escapeJavaStyleString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(stringWriter, string, bl);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static final void escapeJavaStyleString(Writer writer, String string, boolean bl) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u0fff') {
                writer.write("\\u" + StringEscapeUtils.hex(c));
            } else if (c > '\u00ff') {
                writer.write("\\u0" + StringEscapeUtils.hex(c));
            } else if (c > '\u007f') {
                writer.write("\\u00" + StringEscapeUtils.hex(c));
            } else if (c < ' ') {
                switch (c) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            writer.write("\\u00" + StringEscapeUtils.hex(c));
                            break;
                        }
                        writer.write("\\u000" + StringEscapeUtils.hex(c));
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\'': {
                        if (bl) {
                            writer.write(92);
                        }
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(92);
                        writer.write(34);
                        break;
                    }
                    case '\\': {
                        writer.write(92);
                        writer.write(92);
                        break;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
            ++n2;
        }
    }

    private static final String hex(char c) {
        return Integer.toHexString(c).toUpperCase();
    }

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringEscapeUtils.unescapeJava(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static final void unescapeJava(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl2) {
                stringBuffer.append(c);
                if (stringBuffer.length() == 4) {
                    try {
                        int n3 = Integer.parseInt(stringBuffer.toString(), 16);
                        writer.write((char)n3);
                        stringBuffer.setLength(0);
                        bl2 = false;
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RuntimeException("Unable to parse unicode value: " + stringBuffer, numberFormatException);
                    }
                }
            } else if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
            } else if (c == '\\') {
                bl = true;
            } else {
                writer.write(c);
            }
            ++n2;
        }
        if (bl) {
            writer.write(92);
        }
    }
}

